////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   filechangemonitor.cpp
//  Version:     v1.00
//  Created:     15/11/2002 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "FileChangeMonitor.h"
#include <sys/stat.h>
#include <process.h>

INT64 g_ChangeFileTimeDelta = 0;

//////////////////////////////////////////////////////////////////////////
// Directory monitoring thread.
//////////////////////////////////////////////////////////////////////////
struct CFileChangeMonitorThread
{
public:
	UINT_PTR m_handle;
	
	bool m_bFileChanged;
	std::vector<HANDLE> m_handles;
	std::vector<std::string> m_dirs;
	DWORD m_mainThreadId;

	static HANDLE m_killEvent;


	CFileChangeMonitorThread()
	{
		m_bFileChanged = false;
		m_mainThreadId = GetCurrentThreadId();
		m_killEvent = ::CreateEvent( NULL,TRUE,FALSE,NULL );
		// First event in list is KillEvent.
		m_handles.push_back(m_killEvent);
		m_dirs.push_back("");
	}

	~CFileChangeMonitorThread()
	{
		::CloseHandle( m_killEvent );
		m_killEvent = 0;
	}

	void	Start()
	{
		_beginthread( ThreadFunc,0,this );
	}

	static unsigned int GetCurrentId();

protected:
	void FindChangedFiles( const std::string &dir );
	static void ThreadFunc( void *param )
	{
		CFileChangeMonitorThread *thread = (CFileChangeMonitorThread*)param;
		thread->Run();
	}

	void Run()
	{
		DWORD dwWaitStatus;

		int numHandles = (int)m_handles.size();

		// If First handle triggers, its quit.
		// Waiting thread.
		while (TRUE) 
		{ 
			// Wait for notification.
			dwWaitStatus = WaitForMultipleObjects( numHandles,&m_handles[0],FALSE,INFINITE );

			if (dwWaitStatus >= WAIT_OBJECT_0 && dwWaitStatus < WAIT_OBJECT_0+numHandles)
			{
				if (dwWaitStatus == WAIT_OBJECT_0)
				{
					// This is Thread Kill event.
					break;
				}
				// One of objects got triggered, find out which.
				int id = dwWaitStatus - WAIT_OBJECT_0;
				std::string dir = m_dirs[id];


				m_bFileChanged = true;

				// Now the intesting part.. we need to find which file have been changed.
				// The fastest way, is scan directoryto take current time

				if (FindNextChangeNotification(m_handles[id]) == FALSE)
				{
					// Error!!!.
					//ExitProcess(GetLastError());
				}
				// Notify main thread that something have changed.
				PostThreadMessage( m_mainThreadId,WM_FILEMONITORCHANGE,0,0 );
			}
		}

		// Close all change notification handles.
		for (int i = 1; i < m_handles.size(); i++)
		{
			FindCloseChangeNotification(m_handles[i]);
		}
	}
};

HANDLE CFileChangeMonitorThread::m_killEvent = 0;

//////////////////////////////////////////////////////////////////////////
CFileChangeMonitor::CFileChangeMonitor()
{
	m_thread = new CFileChangeMonitorThread;
}

//////////////////////////////////////////////////////////////////////////
CFileChangeMonitor::~CFileChangeMonitor()
{
	// Send to thread a kill event.
	StopMonitor();
}

//////////////////////////////////////////////////////////////////////////
bool CFileChangeMonitor::IsDirectory(const char* sFileName)
{
	struct __stat64 my_stat;
	if (_stat64(sFileName, &my_stat) != 0) return false;
	return ((my_stat.st_mode & S_IFDIR) != 0);
}

//////////////////////////////////////////////////////////////////////////
void CFileChangeMonitor::MonitorDirectories( const std::vector<std::string> &dirs )
{
	// Watch the C:\WINDOWS directory for file creation and 
	// deletion.
	for (int i = 0; i < dirs.size(); i++)
	{
		if (!IsDirectory( dirs[i].c_str() ))
			continue;
		
		m_thread->m_dirs.push_back(dirs[i]);

		// Create Notification Event.
		HANDLE dwHandle = FindFirstChangeNotification( dirs[i].c_str(),TRUE,FILE_NOTIFY_CHANGE_LAST_WRITE|FILE_NOTIFY_CHANGE_FILE_NAME); // watch file name changes 
		m_thread->m_handles.push_back(dwHandle);
	}

	// Start monitoring thread.
	m_thread->Start();
}

//////////////////////////////////////////////////////////////////////////
void CFileChangeMonitor::StopMonitor()
{
	if (m_thread && CFileChangeMonitorThread::m_killEvent != 0)
	{
		::SetEvent(CFileChangeMonitorThread::m_killEvent);
	}
}

//////////////////////////////////////////////////////////////////////////
bool CFileChangeMonitor::HaveModifiedFiles() const
{
	bool bAnyChanged = m_thread->m_bFileChanged;
	m_thread->m_bFileChanged = false;
	return bAnyChanged;
}