
#include "stdafx.h"

char sTargetFolder[_MAX_PATH] = "c:\\4";

//////////////////////////////////////////////////////////////////////////
bool IsFileExist( const char *filename )
{
	FILE *f = fopen(filename,"rb");
	if (f)
	{
		fclose(f);
		return true;
	}
	return false;
}



//////////////////////////////////////////////////////////////////////////
void ShareFile( const char *filename )
{
	char sTargetFile[_MAX_PATH];
	char tempfilename[_MAX_PATH];

	int num = 0;
	bool bFileExist = false;
	do 
	{
		sprintf(tempfilename,"ver1_shaderlist_%d",num );
		_makepath( sTargetFile,NULL,sTargetFolder,tempfilename,"txt" );
		bFileExist = IsFileExist(sTargetFile);
		num++;
	}
	while (bFileExist && num < 100);
	CopyFile( filename,sTargetFile,TRUE );
	DeleteFile( filename );
}

//////////////////////////////////////////////////////////////////////////
void LoadConfigFile( const char *exe_filename )
{
	char path_buffer[_MAX_PATH];
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	   
	_splitpath( exe_filename, drive, dir, fname, ext );
	_makepath( path_buffer, drive, dir, "sc_share", "ini" );

	FILE *f = fopen( path_buffer,"rt" );
  if (!f)
		return;

	char str[_MAX_PATH];
	fgets( str,sizeof(str),f );
	if (strlen(str) > 0)
		strcpy( sTargetFolder,str );

	fclose(f);
}

//////////////////////////////////////////////////////////////////////////
int _tmain(int argc, _TCHAR* argv[])
{
	if (argc < 2)
	{
		printf( "sc_share <filename>\n\tfilename - shaderlist.txt file path" );
		return 0;
	}

	LoadConfigFile( argv[0] );

	const char *filename = argv[1];
	ShareFile( filename );

	return 0;
}

