#include <Windows.h>

bool RunCommand(const wchar_t* command)
{
	bool success = true;

	STARTUPINFO si = {0};

	si.cb = sizeof( si );
	si.dwFlags = 0;

	wchar_t writeableCommandBuffer[2048];
	wcscpy_s(writeableCommandBuffer, sizeof(writeableCommandBuffer) / sizeof(writeableCommandBuffer[0]), command);

	PROCESS_INFORMATION pi;
	if (CreateProcess(
		0,                            // LPCTSTR lpApplicationName,
		writeableCommandBuffer,       // LPTSTR lpCommandLine,
		0,                            // LPSECURITY_ATTRIBUTES lpProcessAttributes,
		0,                            // LPSECURITY_ATTRIBUTES lpThreadAttributes,
		0,                            // BOOL bInheritHandles,
		0,                            // DWORD dwCreationFlags,
		0,                            // LPVOID lpEnvironment,
		0,                            // LPCTSTR lpCurrentDirectory,
		&si,                          // LPSTARTUPINFO lpStartupInfo,
		&pi))                         // LPPROCESS_INFORMATION lpProcessInformation
	{
		WaitForSingleObject(pi.hProcess, INFINITE);
	}
	else
	{
		success = false;
	}

	return success;
}

enum Mode
{
	Mode_None,
	Mode_PostInstall
};

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	bool success = true;

	// Determine what mode to run in.
	Mode mode = Mode_None;
	{
		// Get the first token from the command line.
		const char* start;
		for (start = lpCmdLine; isspace(*start); ++start);
		const char* end;
		for (end = start; isalnum(*end); ++end);
		char token[2048];
		size_t tokenLength = end - start;
		memcpy_s(token, sizeof(token) / sizeof(token[0]), lpCmdLine, tokenLength);
		token[tokenLength] = 0;

		// Check what mode we should run in.
		if (0 == _stricmp(token, "postinstall"))
			mode = Mode_PostInstall;
	}

	switch (mode)
	{
	case Mode_None:
		MessageBox(
			0,

			L"No mode specified - usage:\n"
			L"      VistaEssentialsApp.exe <mode>\n"
			L"   where mode is one of:\n"
			L"      postinstall\n",

	    L"No mode specified!",
		  MB_ICONERROR | MB_OK);
		break;

	case Mode_PostInstall:
		success = success && RunCommand(L"..\\Comrade\\ComradeSetup.exe /s /v\"/qb\"");
		success = success && RunCommand(L"Restart.exe");
		break;
	}

	return (success ? 0 : 1);
}
