// XenonConsoleDlg.cpp : implementation file
//

#include "stdafx.h"

#include "XenonConsole.h"
#include "XenonConsoleDlg.h"
#include ".\xenonconsoledlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CXenonConsoleDlg dialog



CXenonConsoleDlg::CXenonConsoleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CXenonConsoleDlg::IDD, pParent)
{
	m_pdmConnection = 0;
	m_pdmnSession = 0;
	m_pCh = pCommands;

	m_curInList = -1;

	strcpy(pCommands,"map;quit;");

	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CXenonConsoleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMMAND, m_Command);
	DDX_Control(pDX, IDC_CONSOLE, m_Console);
}

BEGIN_MESSAGE_MAP(CXenonConsoleDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDCANCEL, OnBnClickedCancel)
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
	ON_WM_SIZE()
END_MESSAGE_MAP()


void CXenonConsoleDlg::OnSize(UINT nType, int cx, int cy )
{
	RECT r;
	GetClientRect(&r);

	if(IsWindow(m_Command.m_hWnd))
	{
		WINDOWPLACEMENT wp;
		m_Command.GetWindowPlacement(&wp);
		int h = wp.rcNormalPosition.bottom - wp.rcNormalPosition.top;
		wp.rcNormalPosition.right = cx-m_CommandX;
		wp.rcNormalPosition.top = cy-m_CommandY;
		wp.rcNormalPosition.bottom = wp.rcNormalPosition.top + h;
		m_Command.SetWindowPlacement(&wp);
	}

	if(IsWindow(m_Console.m_hWnd))
	{
		WINDOWPLACEMENT wp;
		m_Console.GetWindowPlacement(&wp);
		wp.rcNormalPosition.right = cx-m_CommandX;
		wp.rcNormalPosition.bottom = cy-m_ConsoleY;
		m_Console.SetWindowPlacement(&wp);
	}


	CDialog::OnSize(nType, cx, cy);
}


BOOL CXenonConsoleDlg::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN && GetFocus() == &m_Command)
	{
		if(pMsg->wParam == VK_ESCAPE)
		{
			m_Command.SetWindowText("");
			return true;
		}
		if(pMsg->wParam == VK_UP)
		{
			m_curInList--;
			
			if(m_curInList<-1)
				m_curInList = m_commList.size() - 1;

			if(m_curInList>=0)
			{
				const char * pCom = (m_commList[m_curInList]).c_str();

				m_Command.SetWindowText(pCom);
				m_Command.SetSel(strlen(pCom),-1, FALSE);
			}
			else if(m_curInList==-1)
			{
				m_Command.SetWindowText("");
			}

			return true;
		}

		if(pMsg->wParam == VK_DOWN)
		{
			m_curInList++;
			
			if(m_curInList<0)
				m_curInList = -1;

			if(m_curInList < m_commList.size())
			{
				const char * pCom = (m_commList[m_curInList]).c_str();

				m_Command.SetWindowText(pCom);
				m_Command.SetSel(strlen(pCom),-1, FALSE);
			}
			else
			{
				m_curInList = -1;
				m_Command.SetWindowText("");
			}
			return true;
		}

		if(pMsg->wParam == VK_TAB)
		{
			CString str;
			m_Command.GetWindowText(str);

			if(!str.GetLength())
				return false;
			
			if(!m_FindBegin.GetLength())
				m_FindBegin = str;

			char pCom[64];
			char * pC = pCom;

			for(int i= 0; i<2; i++)
			{
				while(*m_pCh)
				{
					if(*m_pCh==';')
					{
						*pC++ = ' ';
						*pC = 0;
						if(!strnicmp (pCom, m_FindBegin, m_FindBegin.GetLength()))
						{
							m_Command.SetWindowText(pCom);
							m_Command.SetSel(strlen(pCom),-1, FALSE);
							m_pCh ++;
							return true;
						}
						pC = pCom;
					}
					else
						*pC++ = *m_pCh;
					
					m_pCh++;
				}
				m_pCh = pCommands;
			}
			return true;
		}
	}
	
	if(pMsg->message == WM_KEYDOWN)
	{
		m_pCh = pCommands;
		m_FindBegin ="";
	}
	return CDialog::PreTranslateMessage(pMsg);
}



DWORD __stdcall ExtNotifyFunc( const CHAR* strNotification )
{
	CXenonConsoleDlg * dlg = (CXenonConsoleDlg *) AfxGetApp()->GetMainWnd();
	if(!dlg)
		return E_FAIL;

	// Skip over dumb prefix and ! mark.
	while (*strNotification && *strNotification != '!')
		strNotification++;
	if (!*strNotification)
		return S_OK;
	strNotification++;

	dlg->Print(strNotification);
	return S_OK;
}


BOOL CXenonConsoleDlg::OpenConnection()
{
	// Open our connection
	HRESULT hr = DmOpenConnection( &m_pdmConnection );
	if( FAILED( hr ) )
	{
		MessageBox( "DmOpenConnection", "Error", MB_OK | MB_ICONERROR );
		return TRUE;
	}

	// Make sure we'll be able to receive notifications
	hr = DmOpenNotificationSession( 0, &m_pdmnSession);
	if( FAILED( hr ) )
	{
		MessageBox( "DmOpenNotificationSession", "Error", MB_OK | MB_ICONERROR );
		return TRUE;
	}

	hr = DmRegisterNotificationProcessor( m_pdmnSession, "FXEN", ExtNotifyFunc );
	if( FAILED( hr ) )
	{
		MessageBox( "DmRegisterNotificationProcessor", "Error", MB_OK | MB_ICONERROR );
		return TRUE;
	}


	// Send initial connect command to the External Command Processor so it knows we're here
	{
		DWORD dwResponseLen = MAX_PATH;
		CHAR  strResponse[MAX_PATH];

		hr = DmSendCommand( m_pdmConnection, "XCON!__connect__", strResponse, &dwResponseLen );
		if( FAILED(hr) )
		{
			MessageBox( "Couldn't connect to Application", "Error", MB_OK | MB_ICONERROR );
			return TRUE;
		}
	}
}


void CXenonConsoleDlg::CloseConnection()
{
	if(m_pdmConnection)
		DmCloseConnection( m_pdmConnection );
	m_pdmConnection = 0;

	if(m_pdmnSession)
		DmCloseNotificationSession( m_pdmnSession );
	m_pdmnSession = 0;
}


// CXenonConsoleDlg message handlers

BOOL CXenonConsoleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	m_Command.SetFocus();

	//char xbdmFile[MAX_PATH];
	//strcpy(xbdmFile, getenv("XEDK"));
	//strcat(xbdmFile, "\\bin\\win32\\xbdm.dll");

	RECT r;
	GetClientRect(&r);
	WINDOWPLACEMENT wp;
	m_Command.GetWindowPlacement(&wp);
	m_CommandX = (r.right - r.left) - wp.rcNormalPosition.right;
	m_CommandY = (r.bottom - r.top) - wp.rcNormalPosition.top;

	m_Console.GetWindowPlacement(&wp);
	m_ConsoleY = (r.bottom - r.top) - wp.rcNormalPosition.bottom;

	m_Console.SetLimitText(UINT_MAX);

	HMODULE hXBDM = LoadLibrary("xbdm.dll");
	if (!hXBDM)
	{
		MessageBox( "Couldn't load xbdm.dll", "Error", MB_OK | MB_ICONERROR );
		return TRUE;
	}

	OpenConnection();



	// Get names of all variables (and commands) from game
	{
		//*
		DWORD dwResponseLen = ALL_COMMANDS_SIZE;

		char Xcomm[1024] = "XCON!__getvars__";
		char getString[2048];

		char * ch = 0;
		while(!FAILED(DmSendCommand( m_pdmConnection, Xcomm, getString, &dwResponseLen )))
		{
			int len = strlen (getString);
			if(len == 0)
				break;

			int lenCom = strlen(pCommands);

			if(lenCom + len >= ALL_COMMANDS_SIZE )
				break;

			strcpy(&pCommands[lenCom], &getString[5]); // 5 - skip error code

			getString[len-1] = 0; // remove komu z krapkoy at the end
			ch = strrchr(getString, ';');
			if(!ch)
				break;

			dwResponseLen = ALL_COMMANDS_SIZE;
			sprintf(Xcomm, "XCON!__getvars__%s", ch+1);
		}
		/**/
	}




	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CXenonConsoleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CXenonConsoleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CXenonConsoleDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CXenonConsoleDlg::OnBnClickedCancel()
{
	CloseConnection();
	OnCancel();
}

void CXenonConsoleDlg::OnBnClickedOk()
{
	m_curInList = -1;
	CString str;
	m_Command.GetWindowText(str);

	if(!str.GetLength())
		return;

	char strRemoteCmd[1024];
	strcpy(strRemoteCmd, "XCON!");
	strcat(strRemoteCmd, str);

	DWORD dwResponseLen = MAX_PATH;
	CHAR  strResponse[MAX_PATH];

	// Send the command to the Xbox
	HRESULT hr = DmSendCommand( m_pdmConnection, strRemoteCmd, strResponse, &dwResponseLen );
	if( FAILED(hr) )
	{
		CloseConnection();
		OpenConnection();
		hr = DmSendCommand( m_pdmConnection, strRemoteCmd, strResponse, &dwResponseLen );
		if( FAILED(hr) )
			MessageBox( "DmSendCommand", "Error", MB_OK | MB_ICONERROR );
	}
	/**/

	m_Command.SetWindowText("");

	if(m_commList.size()==0 || strcmp (m_commList[m_commList.size()-1].c_str(), str))
	{
		m_commList.push_back(std::string(str));
	}

	//Print(str);
}

void CXenonConsoleDlg::Print(const char * pString)
{
	CString str = "\r\n";
	int nMaxConsoleLen = INT_MAX;
	m_Console.SetSel(nMaxConsoleLen,nMaxConsoleLen);
	m_Console.ReplaceSel(str + pString);
}