#include "StdAfx.h"
#include "StatsCollector.h"
#include <errno.h>

CMutex	CStatsCollector::m_dumpMutex;

CStatsCollector::CStatsCollector(uint32 toDump):m_toDump(toDump)
{
	m_packets.push_back(SPacket());
}

/*CStatsCollector::~CStatsCollector()
{

}*/

void CStatsCollector::Data(const uint32 session_id,const char* name,const float bits)
{
	CMutex::CLock lock(m_mtx);

	SPacket &pkt=m_packets.back();

	TNameToId::iterator i=m_nameToId.find(name);
	int id=m_nameToId.insert(std::make_pair(name,int(m_nameToId.size()))).first->second;

	pkt.Data.push_back(std::make_pair(id,bits));
}

void CStatsCollector::EndPacket()
{
	CMutex::CLock lock(m_mtx);

	if(m_packets.size()>=m_toDump)
		DumpPackets();

	m_packets.push_back(SPacket());
}

void CStatsCollector::DumpPackets()
{
	CMutex::CLock lock(m_mtx);

	SThreadInfo *p=new SThreadInfo;
	p->m_nameToId.swap(m_nameToId);
	p->m_packets.swap(m_packets);
	_beginthread(DumpThread,0,p);
}


void CStatsCollector::DumpThread(void* p)
{
	CMutex::CLock lock(m_dumpMutex);//HACK! can spawn endless threads if data dump speed is low

	std::auto_ptr<SThreadInfo> info((SThreadInfo*)p);

	TPacketArray &packets=info->m_packets;
	TNameToId &nameToId=info->m_nameToId;

	std::ofstream file;
	file.open("packet_stats.tmp",std::ios_base::out);

	//sorrt names
	std::vector<int> name_remap;
	name_remap.resize(nameToId.size());
	int id=0;
	for(TNameToId::iterator i=nameToId.begin();i!=nameToId.end();++i,++id)
		name_remap[i->second]=id;


/*	std::map<string,int> names;
	
	for(size_t i=0;i<packets.size();++i)
	{
		SPacket& pkt=packets[i];
		for(TDataMap::iterator j=pkt.Data.begin();j!=pkt.Data.end();++j)
			names[j->first]=0;
	}
	int id=0;
	for(std::map<string,int>::iterator i=names.begin();i!=names.end();++i,++id)
		i->second=id;
*/
	file<<
		"<?xml version=\"1.0\"?><?mso-application progid=\"Excel.Sheet\"?>"
		"<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\""
		" xmlns:o=\"urn:schemas-microsoft-com:office:office\""
		" xmlns:x=\"urn:schemas-microsoft-com:office:excel\""
		" xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\""
		" xmlns:html=\"http://www.w3.org/TR/REC-html40\">";
	file<<"<Worksheet ss:Name=\"Stats\">";
	file<<"<Table>"; 
	

	file<<"<Row>";
	id=0;
	for(TNameToId::iterator i=nameToId.begin();i!=nameToId.end();++i,++id)
	{
		file
			<<"<Cell ss:Index=\""
			<<id+2
			<<"\"><Data ss:Type=\"String\">"
			<<i->first
			<<"</Data></Cell>";
	}
	file<<"</Row>";


	std::map<int,float> values;
	for(size_t i=0;i<packets.size();++i)
	{
		file<<"<Row>";
		SPacket& pkt=packets[i];
		for(size_t j=0;j<pkt.Data.size();++j)
			values.insert(std::make_pair(name_remap[pkt.Data[j].first],0.0f)).first->second+=pkt.Data[j].second;

		file<<"<Cell><Data ss:Type=\"Number\">"<<i<<"</Data></Cell>";

		for(std::map<int,float>::iterator j=values.begin();j!=values.end();++j)
		{
			file
				<<"<Cell ss:Index=\""
				<<j->first+1+1
				<<"\"><Data ss:Type=\"Number\">";
			file<<j->second;
			file<<"</Data></Cell>";
		}
		file<<"</Row>";

		values.clear();
	}

	file<<"</Table></Worksheet>";
	file<<"</Workbook>";

	file.close();

	{
		SCOPED_GLOBAL_LOCK;

		if(remove("packet_stats.xml") && errno==EACCES)
		{
			std::cerr<<"Warning: cannot delete old packet_stats.xml. File might be opened by another application"<<std::endl;
		}
		else
		{
			if(rename("packet_stats.tmp","packet_stats.xml"))
			{
				std::cerr<<"Warning: cannot rename packet_stats.tmp to packet_stats.xml"<<std::endl;
			}
		}
	}
	//_endthread();
}

void CStatsCollector::Test()
{
	CStatsCollector sc(300);
	for(int i=0;i<11000;i++)
	{
		for(int j=0;j<30;j++)
		{
			char name[3];
			name[0]='A'+rand()%6;
			name[1]='A'+rand()%20;
			name[2]=0;
			sc.Data(0,name,rand()%1024);
		}
		sc.EndPacket();
	}
	//sc.DumpPackets();
	std::cout<<"CStatsCollector test complete"<<std::endl;

}