#include "stdafx.h"
#include "data.h"
#include <time.h>

void ReadSock( Socket& sock, std::string& value )
{
	uint32 length;
	ReadSock( sock, length );
	if (length > 1024)
		throw std::runtime_error("size too big");
	value.resize(0);
	for (uint32 i=0; i<length; i++)
	{
		uint8 ch;
		ReadSock( sock, ch );
		value += char(ch);
	}
}

void ReadSock( Socket& sock, SAnnotation& annot )
{
	ReadSock(sock, annot.index);
	ReadSock(sock, annot.annotation);
}

void ReadSock( Socket& sock, SPacket& pkt )
{
	ReadSock(sock, pkt.uniqueId);
	ReadSock(sock, pkt.isEncoding);
	ReadSock(sock, pkt.channel);
	ReadSock(sock, pkt.coding);
	ReadSock(sock, pkt.annotations);
}

void ReadSock( Socket& sock, uint8& value )
{
	value = sock.ReadByte();
}
