// EMERGENT GAME TECHNOLOGIES PROPRIETARY INFORMATION
//
// This software is supplied under the terms of a license agreement or
// nondisclosure agreement with Emergent Game Technologies and may not 
// be copied or disclosed except in accordance with the terms of that 
// agreement.
//
//      Copyright (c) 1996-2008 Emergent Game Technologies.
//      All Rights Reserved.
//
// Emergent Game Technologies, Chapel Hill, North Carolina 27517
// http://www.emergent.net

// Texture set
// -- Blur --
//  SrcTexture : Src Texture
//  ShaderTex1 : none
//  ShaderTex2 : none
// -- DoF --
//  SrcTexture : Src Texture
//  ShaderTex1 : Depth Texture
//  ShaderTex2 : 1/4 Scale Texture
// 
//  /* attention */
//   In this version 1/4 Scale Texture is created by Kinslayer but not used in shader.


//---------------------------------------------------------------------------
// Textures and Samplers
//---------------------------------------------------------------------------

texture SrcTexure
< 
    bool hidden = true;
    string NTM = "shader";
    int NTMIndex = 0;
>;

texture ShaderTex1
< 
    bool hidden = true;
    string NTM = "shader";
    int NTMIndex = 1;
>;

texture ShaderTex2
< 
    bool hidden = true;
    string NTM = "shader";
    int NTMIndex = 2;
>;

sampler2D SrcDefaultSampler =
sampler_state
{
    Texture = <SrcTexure>;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Point;
    AddressU = Clamp;
    AddressV = Clamp;
};

sampler2D DepthSampler =
sampler_state
{
    Texture = <ShaderTex1>;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Point;
    AddressU = Clamp;
    AddressV = Clamp;
};

sampler2D BlurSampler =
sampler_state
{
    Texture = <ShaderTex2>;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Point;
    AddressU = Clamp;
    AddressV = Clamp;
};


//---------------------------------------------------------------------------
// Values
//---------------------------------------------------------------------------

// Bloom Sampling
float2 g_DoF_akSampleOffsets[11] : GLOBAL;
float g_DoF_akSampleWeights[11] : GLOBAL;
float2 g_Dof_akBlurSampleOffset[4] : GLOBAL;
/*
float g_WValue : GLOBAL       = 2000.0f;
float g_NearPlaneDist : GLOBAL = 0.05f;
float g_NearFocusDist : GLOBAL = 0.20f;
float g_FarFocusDist : GLOBAL  = 0.30f;
float g_FarPlaneDist : GLOBAL  = 1.00f;
float g_NearPlaneBlurRate : GLOBAL = 1.0f;
float g_FarPlaneBlurRate : GLOBAL = 1.0f;
*/

float g_TexBlurScale : GLOBAL = 0.01f;
float g_FocusDist : GLOBAL = 0.50f;
float g_NearPlaneDist : GLOBAL = 0.05f;
float g_NearPlaneBlurRate : GLOBAL = 1.0f;
float g_FarPlaneDist : GLOBAL = 1.00f;
float g_FarPlaneBlurRate : GLOBAL = 1.0f;

float4x4 g_matWorldViewProj : WORLDVIEWPROJECTION;

//---------------------------------------------------------------------------
// Functions
//---------------------------------------------------------------------------
float GetDepth( float2 vTexCoord )
{
/*
	float4 depth4 = tex2D(DepthSampler, vTexCoord);
	float depth =  depth4.x*65536.0f + depth4.y*256.0f + depth4.z;
//	float depth =  depth4.w;
	return depth / g_WValue;
*/
	//float4 depth4 = tex2D(DepthSampler, vTexCoord);
	//float depth =  depth4.x*65536.0f + depth4.y*256.0f + depth4.z;
	float depth = tex2D(DepthSampler, vTexCoord).x;
	return depth;
}

float GetBrendRatio( float2 vTexCoord )
{
/*
	float depth = GetDepth( vTexCoord );
	float brend = 0.0f;
	if ( depth < g_FarFocusDist )
	{
		// Decriment liner function
		brend = g_NearPlaneBlurRate - g_NearPlaneBlurRate * (depth - g_NearPlaneDist)/(g_NearFocusDist - g_NearPlaneDist);
		brend = clamp( brend, 0.0f, g_NearPlaneBlurRate );
	}
	else
	{
		// Incriment liner function
		brend = g_FarPlaneBlurRate * (depth - g_FarFocusDist)/(g_FarPlaneDist - g_FarFocusDist);
		brend = clamp( brend, 0.0f, g_FarPlaneBlurRate );
	}
	return brend;
*/

	float depth = 1.f - GetDepth( vTexCoord );
	float brend;

	if( depth < g_FocusDist )
	{
		brend = (g_FocusDist - depth) / (g_FocusDist - g_NearPlaneDist);
		brend = clamp( brend, 0.0f, g_NearPlaneBlurRate );
	}else{
		brend = g_FarPlaneBlurRate * (depth - g_FocusDist) / (g_FarPlaneDist - g_FocusDist);
		brend = clamp( brend, 0.0f, g_FarPlaneBlurRate );
	}
	return brend;
/*
	float depth = GetDepth( vTexCoord );
	float brend;
	if( depth < g_FocusDist )
		brend = 1.f;
	else
		brend = 0.f;

	return brend;
*/
}

//---------------------------------------------------------------------------
// Vertex Shaders
//---------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Pos      : POSITION;
    float3 Tex0     : TEXCOORD0;
};

VS_OUTPUT VSMain(float4 inPos: POSITION, float3 inTex0: TEXCOORD0)
{
    VS_OUTPUT Out;
    Out.Pos = mul(inPos, g_matWorldViewProj);
    Out.Tex0 = inTex0;
    return Out;
}
//---------------------------------------------------------------------------
// Pixel Shaders
//---------------------------------------------------------------------------
float4 Blur_PassThrough_PS(float3 vTexCoord : TEXCOORD0) : COLOR0
{
	return tex2D(SrcDefaultSampler, vTexCoord.xy);
}


//---------------------------------------------------------------------------
float4 GaussBlur_PS(float3 vTexCoord : TEXCOORD0) : COLOR0
{
    float4 kSample = 0.0f;
    float4 kColor = 0.0f;
        
    float2 kSamplePosition;

    // Perform a one-directional gaussian blur
    for (int iSample = 0; iSample < 11; iSample++)
    {
        kSamplePosition = vTexCoord.xy + g_TexBlurScale * g_DoF_akSampleOffsets[iSample];
        kColor = tex2D(SrcDefaultSampler, kSamplePosition.xy);
        kSample += g_DoF_akSampleWeights[iSample] * kColor;
    }
    
    return kSample;
}


//---------------------------------------------------------------------------
float4 DoF_PS(float3 vTexCoord : TEXCOORD0) : COLOR0
{
	int i;
	float4 Src_color  = tex2D(SrcDefaultSampler, vTexCoord.xy);
	float4 Blur_color = tex2D(BlurSampler, vTexCoord.xy);
	
	// Calculate blur ratio.
	// If the depth of neighboring pixel is less than center's one,
	// blur ratio is added to center ratio.
//	float center_depth = GetDepth( vTexCoord );
	float blur_ratio = GetBrendRatio(vTexCoord);
//	int count = 1;
//	for( int i = 0; i < 4; i++ )
//	{
//		float sample_depth = GetDepth( vTexCoord.xy + g_Dof_akBlurSampleOffset[i] );
//		if ( sample_depth < center_depth )
//		{
//			blur_ratio += GetBrendRatio(vTexCoord + g_Dof_akBlurSampleOffset[i] );
//			count++;
//		}
//	}
//	blur_ratio /= count;
	return Src_color * (1.0f - blur_ratio) + Blur_color * blur_ratio;
// return float4(center_depth, center_depth, center_depth, 1.0f);

//	return float4(blur_ratio, blur_ratio, blur_ratio, 1.0f);
}

//---------------------------------------------------------------------------
float4 DoF_DepthTest(float3 vTexCoord : TEXCOORD0) : COLOR0
{
	return tex2D(DepthSampler, vTexCoord.xy);
}

//---------------------------------------------------------------------------
// Techniques
//---------------------------------------------------------------------------
technique DoF_PassThrough
{
    pass p0
    {
        VertexShader = compile vs_2_0 VSMain();
        PixelShader = compile ps_2_0 Blur_PassThrough_PS();
        ZEnable = false;
        AlphaBlendEnable = false;
    }
}

//---------------------------------------------------------------------------
technique DoF_Blur
{
    pass p0
    {
        VertexShader = compile vs_2_0 VSMain();
        PixelShader = compile ps_2_0 GaussBlur_PS();
//        PixelShader = compile ps_2_0 Blur_PassThrough_PS();
        ZEnable = false;
        AlphaBlendEnable = false;
    }
}

//---------------------------------------------------------------------------
technique DoF_RenderDoF
{
    pass p0
    {
        VertexShader = compile vs_3_0 VSMain();
        PixelShader = compile ps_3_0 DoF_PS();
//        PixelShader = compile ps_2_0 Blur_PassThrough_PS();

        // if check depth, remove comment out.
//        PixelShader = compile ps_2_0 DoF_DepthTest();

        ZEnable = false;
        AlphaBlendEnable = false;
    }
}