// EMERGENT GAME TECHNOLOGIES PROPRIETARY INFORMATION
//
// This software is supplied under the terms of a license agreement or
// nondisclosure agreement with Emergent Game Technologies and may not 
// be copied or disclosed except in accordance with the terms of that 
// agreement.
//
//      Copyright (c) 1996-2008 Emergent Game Technologies.
//      All Rights Reserved.
//
// Emergent Game Technologies, Chapel Hill, North Carolina 27517
// http://www.emergent.net

//-----------------------------------------------------------------------------
// **TEXTURES AND SAMPLERS**
//-----------------------------------------------------------------------------
texture Shader0Tex
<
    bool hidden = true;
    string NTM = "shader";
    int NTMIndex = 0;
>;

sampler2D Shader0PointClampSampler =
sampler_state
{
    Texture = <Shader0Tex>;
    MinFilter = Point;
    MagFilter = Point;
    MipFilter = None;
    AddressU = Clamp;
    AddressV = Clamp;
};

//-----------------------------------------------------------------------------
// **SHADER PROGRAMS**
//-----------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Vertex Shaders
//---------------------------------------------------------------------------
float4x4 g_WorldViewProj : WORLDVIEWPROJECTION;

struct VS_OUTPUT
{
    float4 Pos      : POSITION;
    float2 Tex0     : TEXCOORD0;
};

VS_OUTPUT VSMain(float4 inPos: POSITION, float2 inTex0: TEXCOORD0)
{
    VS_OUTPUT Out;
    Out.Pos = mul(inPos, g_WorldViewProj);
    Out.Tex0 = inTex0;
    return Out;
}

//-----------------------------------------------------------------------------
// Pixel Shader: PostProcessTarget_PassThrough_PS
//-----------------------------------------------------------------------------
float4 PostProcessTarget_PassThrough_PS(in float2 kScreenPosition : TEXCOORD0) : COLOR
{
    return tex2D(Shader0PointClampSampler, kScreenPosition);
}

//-----------------------------------------------------------------------------
// **TECHNIQUES**
//-----------------------------------------------------------------------------
technique PostProcessTarget_PassThrough
<
    bool UsesNiRenderState = true;
    bool UsesNiLightState = false;
>
{
    pass P0
    {
        VertexShader = compile vs_2_0 VSMain();
        PixelShader  = compile ps_2_0 PostProcessTarget_PassThrough_PS();
        ZEnable = false;
        AlphaBlendEnable = false;
    }
}

//-----------------------------------------------------------------------------
