//-----------------------------------------------------------------------------
// **TEXTURES AND SAMPLERS**
//-----------------------------------------------------------------------------
texture Shader0Tex
<
    bool hidden = true;
    string NTM = "shader";
    int NTMIndex = 0;
>;

sampler2D SrcDefaultSampler =
sampler_state
{
    Texture = <Shader0Tex>;
    MinFilter = Point;
    MagFilter = Point;
    MipFilter = None;
    AddressU = Clamp;
    AddressV = Clamp;
};

//---------------------------------------------------------------------------
// Values
//---------------------------------------------------------------------------

float2 g_ScrBlurCenter : GLOBAL = float2(0.0, 0.0);
float  g_ScrBlurPower : GLOBAL  = 5.f;

float4x4 g_WorldViewProj : WORLDVIEWPROJECTION;

//-----------------------------------------------------------------------------
// **SHADER PROGRAMS**
//-----------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Vertex Shaders
//---------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Pos      : POSITION;
    float2 Tex0     : TEXCOORD0;
};

VS_OUTPUT VSMain(float4 inPos: POSITION, float2 inTex0: TEXCOORD0)
{
    VS_OUTPUT Out;
    Out.Pos = mul(inPos, g_WorldViewProj);
    Out.Tex0 = inTex0;
    return Out;
}

//-----------------------------------------------------------------------------
// Pixel Shader
//-----------------------------------------------------------------------------
float4 Screen_Blur_PS(in float2 vTexCoord : TEXCOORD0) : COLOR
{
	float4 kColor = 0.0f;

	float2 ss_center = float2( (g_ScrBlurCenter.x + 1.0f) * 0.5f, (-g_ScrBlurCenter.y + 1.0f) * 0.5f );
	float  uOffset   = (ss_center.x - vTexCoord.x ) * (g_ScrBlurPower / 1280.f);
	float  vOffset   = (ss_center.y - vTexCoord.y ) * (g_ScrBlurPower /  720.f);

	float InvSampling = 1.0f/12.0f;

	float2 uv = vTexCoord.xy;

	for ( int i=0; i<12; i++ )
	{
		kColor += tex2D( SrcDefaultSampler, uv ) * InvSampling;
		uv.x   += uOffset;
		uv.y   += vOffset;
	}

	return kColor;
}

//-----------------------------------------------------------------------------
// **TECHNIQUES**
//-----------------------------------------------------------------------------
technique Screen_Blur
<
    bool UsesNiRenderState = true;
    bool UsesNiLightState = false;
>
{
    pass P0
    {
        VertexShader = compile vs_2_0 VSMain();
        PixelShader  = compile ps_2_0 Screen_Blur_PS();
        ZEnable = false;
        AlphaBlendEnable = false;
    }
}

//-----------------------------------------------------------------------------
