//-----------------------------------------------------------------------------
// **TEXTURES AND SAMPLERS**
//-----------------------------------------------------------------------------
texture Shader0Tex
<
    bool hidden = true;
    string NTM = "shader";
    int NTMIndex = 0;
>;

sampler2D SrcDefaultSampler =
sampler_state
{
    Texture = <Shader0Tex>;
    MinFilter = Point;
    MagFilter = Point;
    MipFilter = None;
    AddressU = Clamp;
    AddressV = Clamp;
};

texture Shader2Tex
<
    bool hidden = true;
    string NTM = "shader";
    int NTMIndex = 2;
>;

sampler2D SrcMaskSampler =
sampler_state
{
    Texture = <Shader2Tex>;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = None;
    AddressU = Wrap;
    AddressV = Wrap;
};

//---------------------------------------------------------------------------
// Values
//---------------------------------------------------------------------------
float4 g_ScrDistUV : GLOBAL    = float4(0.0, 0.0, 0.5, 0.5);
float4 g_ScrDistRGB : GLOBAL   = float4(1.0, 1.0, 1.0, 1.0);
float2 g_ScrDistPower : GLOBAL = float2(5.0, 0.25);
float2 g_ScrDistAlpha : GLOBAL = float2(1.0, 0.50);

float4x4 g_WorldViewProj : WORLDVIEWPROJECTION;

//-----------------------------------------------------------------------------
// **SHADER PROGRAMS**
//-----------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Vertex Shaders
//---------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Pos      : POSITION;
    float2 Tex0     : TEXCOORD0;
};

VS_OUTPUT VSMain(float4 inPos: POSITION, float2 inTex0: TEXCOORD0)
{
    VS_OUTPUT Out;
    Out.Pos = mul(inPos, g_WorldViewProj);
    Out.Tex0 = inTex0;
    return Out;
}

//-----------------------------------------------------------------------------
// Pixel Shader
//-----------------------------------------------------------------------------
float4 Screen_Distortion_PS(in float2 vTexCoord : TEXCOORD0) : COLOR
{
	float4 ShimmerColor;
	float4 base;
	float4 dist;
	float4 mask;
	float2 uv;
	float  a;
	float4 c[2];
	float4 output;

	base    = tex2D( SrcDefaultSampler, vTexCoord.xy);
	mask    = tex2D( SrcMaskSampler, vTexCoord.xy);
	mask.a *= g_ScrDistRGB.a;

	ShimmerColor    = tex2D( SrcMaskSampler, vTexCoord.xy + g_ScrDistUV.xy);
	ShimmerColor.xy = ( ShimmerColor.xy - 0.5f ) * 2.0f;
	uv   = vTexCoord.xy - ( ShimmerColor.xy ) * ShimmerColor.z * g_ScrDistPower.x;
	dist = tex2D( SrcDefaultSampler, uv);
	a    = g_ScrDistAlpha.x * mask.a;
	c[0] = base * (1.0 - a) + dist * a;

	ShimmerColor    = tex2D( SrcMaskSampler, vTexCoord.xy + g_ScrDistUV.zw);
	ShimmerColor.xy = ( ShimmerColor.xy - 0.5f ) * 2.0f;
	uv   = vTexCoord.xy - ( ShimmerColor.xy ) * ShimmerColor.z * g_ScrDistPower.y;
	dist = tex2D( SrcDefaultSampler, uv);
	a    = g_ScrDistAlpha.y * mask.a;
	c[1] = base * (1.0 - a) + dist * a;

	output = (c[0] + c[1]) * 0.5;

	output.rgb += g_ScrDistRGB.rgb * mask.a;

	return output;
}

//-----------------------------------------------------------------------------
// **TECHNIQUES**
//-----------------------------------------------------------------------------
technique Screen_Distortion
<
    bool UsesNiRenderState = true;
    bool UsesNiLightState = false;
>
{
    pass P0
    {
        VertexShader = compile vs_2_0 VSMain();
        PixelShader  = compile ps_2_0 Screen_Distortion_PS();
        ZEnable = false;
        AlphaBlendEnable = true;
    }
}

//-----------------------------------------------------------------------------
