//-----------------------------------------------------------------------------
// **TEXTURES AND SAMPLERS**
//-----------------------------------------------------------------------------
texture Shader0Tex
<
    bool hidden = true;
    string NTM = "shader";
    int NTMIndex = 0;
>;

sampler2D SrcSampler =
sampler_state
{
    Texture = <Shader0Tex>;
    MinFilter = Point;
    MagFilter = Point;
    MipFilter = None;
    AddressU = Clamp;
    AddressV = Clamp;
};

//---------------------------------------------------------------------------
// Values
//---------------------------------------------------------------------------

float g_RevContAlpha : GLOBAL = 1.f;

float4x4 g_WorldViewProj : WORLDVIEWPROJECTION;

//-----------------------------------------------------------------------------
// **SHADER PROGRAMS**
//-----------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Vertex Shaders
//---------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Pos      : POSITION;
    float2 Tex0     : TEXCOORD0;
};

VS_OUTPUT VSMain(float4 inPos: POSITION, float2 inTex0: TEXCOORD0)
{
    VS_OUTPUT Out;
    Out.Pos = mul(inPos, g_WorldViewProj);
    Out.Tex0 = inTex0;
    return Out;
}

//-----------------------------------------------------------------------------
// Pixel Shader
//-----------------------------------------------------------------------------
float4 Screen_RevCont_PS(in float2 vTexCoord : TEXCOORD0) : COLOR
{
	float4 mono;
	float4 base;
	float4 output;

	base       = tex2D( SrcSampler, vTexCoord.xy);
	mono.rgb   = (base.r + base.g + base.b) /  3.f;
	output.rgb = lerp( base.rgb, mono.rgb, g_RevContAlpha);
	output.a   = base.a;

	return output;
}

//-----------------------------------------------------------------------------
// **TECHNIQUES**
//-----------------------------------------------------------------------------
technique Screen_RevCont
<
    bool UsesNiRenderState = true;
    bool UsesNiLightState = false;
>
{
    pass P0
    {
        VertexShader = compile vs_2_0 VSMain();
        PixelShader  = compile ps_2_0 Screen_RevCont_PS();
        ZEnable = false;
        AlphaBlendEnable = true;
    }
}

//-----------------------------------------------------------------------------
