//-----------------------------------------------------------------------------
// **TEXTURES AND SAMPLERS**
//-----------------------------------------------------------------------------
texture Shader0Tex
<
    bool hidden = true;
    string NTM = "shader";
    int NTMIndex = 0;
>;

sampler2D SrcSampler0 =
sampler_state
{
    Texture = <Shader0Tex>;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = None;
    AddressU = Clamp;
    AddressV = Clamp;
};

texture Shader1Tex
<
    bool hidden = true;
    string NTM = "shader";
    int NTMIndex = 1;
>;

sampler2D SrcSampler1 =
sampler_state
{
    Texture = <Shader1Tex>;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = None;
    AddressU = Clamp;
    AddressV = Clamp;
};

texture Shader2Tex
<
    bool hidden = true;
    string NTM = "shader";
    int NTMIndex = 2;
>;

sampler2D SrcSampler2 =
sampler_state
{
    Texture = <Shader2Tex>;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = None;
    AddressU = Clamp;
    AddressV = Clamp;
};

//---------------------------------------------------------------------------
// Values
//---------------------------------------------------------------------------
float4x4 g_WorldViewProj : WORLDVIEWPROJECTION;

//-----------------------------------------------------------------------------
// **SHADER PROGRAMS**
//-----------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Vertex Shaders
//---------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Pos      : POSITION;
    float2 Tex0     : TEXCOORD0;
};

VS_OUTPUT VSMain(float4 inPos: POSITION, float2 inTex0: TEXCOORD0)
{
    VS_OUTPUT Out;
    Out.Pos = mul(inPos, g_WorldViewProj);
    Out.Tex0 = inTex0;
    return Out;
}

//-----------------------------------------------------------------------------
// Pixel Shader
//-----------------------------------------------------------------------------
float4 Tutorial_Movie_PS(in float2 vTexCoord : TEXCOORD0) : COLOR
{
	float4 frame;
	float4 alpha;
	float4 movie;
	float4 output;

	frame = tex2D( SrcSampler0, vTexCoord.xy);
	alpha = tex2D( SrcSampler1, vTexCoord.xy);
	movie = tex2D( SrcSampler2, vTexCoord.xy);

	output.rgb = lerp( frame.rgb, movie.rgb, alpha.a);
	output.a   = frame.a;

	return output;
}

//-----------------------------------------------------------------------------
// **TECHNIQUES**
//-----------------------------------------------------------------------------
technique Tutorial_Movie
<
    bool UsesNiRenderState = true;
    bool UsesNiLightState = false;
>
{
    pass P0
    {
        VertexShader = compile vs_2_0 VSMain();
        PixelShader  = compile ps_2_0 Tutorial_Movie_PS();
        ZEnable = false;
        AlphaBlendEnable = true;
    }
}

//-----------------------------------------------------------------------------
