// AssManMenu.h : Declaration of the CAssManMenu

#ifndef __ASSMANMENU_H_
#define __ASSMANMENU_H_

#include "resource.h"       // main symbols

#include "OutputDialog.h"
/////////////////////////////////////////////////////////////////////////////
// CAssManMenu
#define ID_MENU_CHECK_IN						0
#define ID_MENU_CHECK_OUT						1
#define ID_MENU_GET_LATEST_VERSION	2




class ATL_NO_VTABLE CAssManMenu : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CAssManMenu, &CLSID_AssManMenu>,
	public IDispatchImpl<IAssManMenu, &IID_IAssManMenu, &LIBID_ASSMANSHELLEXT>,
//Ext interfaces
	public IShellExtInit,
	public IContextMenu
{
public:
	CAssManMenu()
	{
    m_hCheckInBmp = LoadBitmap ( _Module.GetModuleInstance(),
                             MAKEINTRESOURCE(IDB_CHECKINBMP) );

    m_hCheckOutBmp = LoadBitmap ( _Module.GetModuleInstance(),
                               MAKEINTRESOURCE(IDB_CHECKOUTBMP) );
    m_hGetLatestVersion = LoadBitmap ( _Module.GetModuleInstance(),
                               MAKEINTRESOURCE(IDB_GETLATESTVERSIONBMP) );
		m_hReady=::CreateEvent(NULL, TRUE, FALSE, NULL);

	}
	virtual ~CAssManMenu()
	{
		//if(m_hReady)
		//::CloseHandle(m_hReady);
	}
DECLARE_REGISTRY_RESOURCEID(IDR_ASSMANMENU)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CAssManMenu)
	COM_INTERFACE_ENTRY(IAssManMenu)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IShellExtInit)
	COM_INTERFACE_ENTRY(IContextMenu)
END_COM_MAP()

// IAssManMenu
public:
// IShellExtInit
public:
	STDMETHOD(Initialize)(LPCITEMIDLIST, LPDATAOBJECT, HKEY);
public:
	HMENU _AddSubMenu(HMENU hParent,_String name,UINT nIndex,UINT nCmd,HBITMAP hBitmap);
	bool _AddMenuItem(HMENU hMenu,_String sName, UINT nIndex,UINT nCmd,HBITMAP hBitmap);
 // IContextMenu
	STDMETHOD(GetCommandString)(UINT, UINT, UINT*, LPSTR, UINT);
	STDMETHOD(InvokeCommand)(LPCMINVOKECOMMANDINFO);
	STDMETHOD(QueryContextMenu)(HMENU, UINT, UINT, UINT, UINT);
private:
	static DWORD WINAPI _WorkingThread(LPVOID lpParameter);
	void WorkingThread();
	void GetFromVSS(_String sDatasbase,_String sProjFolder,_String sDestFolder);
	void TraverseFolder(IVSSItemPtr pItem,_bstr_t sFolder);
	//this mean "Shall I apply the command on this file?"
	BOOL m_bDoIt;
	BOOL m_bIsRootDir;
	STRING_LIST m_lsFiles;
	HBITMAP m_hCheckInBmp;
	HBITMAP m_hCheckOutBmp;
	HBITMAP m_hGetLatestVersion;
	UINT m_uBaseCommand;
	COutputDialog m_dlg;
	HANDLE m_hReady;

	//
	_String m_sCmdDatabase;
	_String m_sCmdProjFolder;
	_String m_sCmdDestFolder;
	bool m_bCmdRecursive;
};

#endif //__ASSMANMENU_H_
