// AssManShellExt.cpp : Implementation of DLL Exports.


// Note: Proxy/Stub Information
//      To build a separate proxy/stub DLL, 
//      run nmake -f AssManShellExtps.mk in the project directory.

#include "stdafx.h"
#include "resource.h"
#include <initguid.h>
#include "AssManShellExt.h"

#include "AssManShellExt_i.c"
#include "AssManMenu.h"

#include "ConfigManager.h"
CAssManModule _Module;

BEGIN_OBJECT_MAP(ObjectMap)
OBJECT_ENTRY(CLSID_AssManMenu, CAssManMenu)
END_OBJECT_MAP()

CAssManModule::CAssManModule()
{
		m_pConfigManager=new CConfigManager;
}
CAssManModule::~CAssManModule()
{
		delete m_pConfigManager;
}

void CAssManModule::Init( _ATL_OBJMAP_ENTRY* p, HINSTANCE h,const GUID* plibid){
		CComModule::Init(p,h,plibid);
		if(FAILED(m_pConfigManager->Init())){
			ATLTRACE("Error initializing the DB");
		}
	}
/////////////////////////////////////////////////////////////////////////////
// DLL Entry Point

extern "C"
BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		_Module.Init(ObjectMap, hInstance, &LIBID_ASSMANSHELLEXT);
		DisableThreadLibraryCalls(hInstance);
	}
	else if (dwReason == DLL_PROCESS_DETACH)
		_Module.Term();
	return TRUE;    // ok
}

/////////////////////////////////////////////////////////////////////////////
// Used to determine whether the DLL can be unloaded by OLE

STDAPI DllCanUnloadNow(void)
{
	return (_Module.GetLockCount()==0) ? S_OK : S_FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// Returns a class factory to create an object of the requested type

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
	return _Module.GetClassObject(rclsid, riid, ppv);
}

/////////////////////////////////////////////////////////////////////////////
// DllRegisterServer - Adds entries to the system registry

STDAPI DllRegisterServer(void)
{
	//BEGIN EXT CODE////////////////////////////////////
	if ( 0 == (GetVersion() & 0x80000000UL) )
	{
		CRegKey reg;
		LONG    lRet;
		
		lRet = reg.Open ( HKEY_LOCAL_MACHINE,
			_T("Software\\Microsoft\\Windows\\CurrentVersion\\Shell Extensions\\Approved"),
			KEY_SET_VALUE );
		
		if ( ERROR_SUCCESS != lRet )
			return E_ACCESSDENIED;
		
		lRet = reg.SetValue ( _T("AssMan extension"),
			_T("{8641B3B4-F6F4-426F-8622-AAB1EA79D0DC}") );
		
		if ( ERROR_SUCCESS != lRet )
			return E_ACCESSDENIED;
	}
	
	//END EXT CODE////////////////////////////////////
	return _Module.RegisterServer(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// DllUnregisterServer - Removes entries from the system registry

STDAPI DllUnregisterServer(void)
{
	//BEGIN EXT CODE////////////////////////////////////
	if ( 0 == (GetVersion() & 0x80000000UL) )
	{
		CRegKey reg;
		LONG    lRet;
		
		lRet = reg.Open ( HKEY_LOCAL_MACHINE,
			_T("Software\\Microsoft\\Windows\\CurrentVersion\\Shell Extensions\\Approved"),
			KEY_SET_VALUE );
		
		if ( ERROR_SUCCESS == lRet )
		{
			lRet = reg.DeleteValue ( _T("{8641B3B4-F6F4-426F-8622-AAB1EA79D0DC}") );
		}
	}
	//END EXT CODE////////////////////////////////////
	return _Module.UnregisterServer(TRUE);
}


