// ConfigManager.cpp: implementation of the CConfigManager class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ConfigManager.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


CConfigManager::CConfigManager()
{
	m_sBaseDir=_T("C:\\MasterCD");
}

CConfigManager::~CConfigManager()
{

}

HRESULT CConfigManager::Init()
{
	unsigned long nMenuID=0;
	//lRet = reg.Open(HKEY_CURRENT_USER,_T("Software\\Crytek\\AssMan"),KEY_READ);
	//_asm int 3;
	MSXML::IXMLDOMDocumentPtr pDoc;	
	MSXML::IXMLDOMNodePtr pNode;
	MSXML::IXMLDOMNodeListPtr pNodeList;
	MSXML::IXMLDOMNamedNodeMapPtr pAttribMap;
	MSXML::IXMLDOMNamedNodeMapPtr pAttribMap2;
	
	pDoc.CreateInstance("MSXML.DOMDocument");
	pDoc->load(_bstr_t(_T("C:\\AssMan.cfg")));
	pNodeList=pDoc->getElementsByTagName(_T("assman"));
	pNode=pNodeList->Getitem(0);
	pAttribMap=pNode->Getattributes();
	pNode=pAttribMap->getNamedItem(_T("basedirectory"));
	m_sBaseDir=(TCHAR *)pNode->Gettext();
	TCHAR sTempDir[256];
	_tcscpy(sTempDir,m_sBaseDir.c_str());
	int n=0;
	while(sTempDir[n]!=0)
	{
		if(sTempDir[n]=='\\')
			sTempDir[n]='/';
		n++;
	}
	m_sBaseDir=sTempDir;
	ATLTRACE("m_sBaseDir=%s\n",m_sBaseDir.c_str());
	pNodeList=pDoc->getElementsByTagName(_T("skip"));
	LONG lLenght=0;
	pNodeList->get_length(&lLenght);
	try{ 
		
		for(LONG n=0;n<lLenght;n++){
			MSXML::IXMLDOMNodePtr pSkip;
			MSXML::IXMLDOMNodePtr pNode;
			pSkip=pNodeList->Getitem(n);
			pAttribMap=pSkip->Getattributes();
			pNode=pAttribMap->getNamedItem("value");
			m_lstSkip.push_back(((TCHAR*)pNode->Gettext()));
			ATLTRACE("SKIP =%s \n",((TCHAR*)pNode->Gettext()));
		}
	}
	catch(...)
	{
		ATLTRACE("Error reading skiplist \n");
	}
	/////////////////////
	pNodeList=pDoc->getElementsByTagName(_T("category"));
	lLenght=0;
	pNodeList->get_length(&lLenght);
	try{ 
		
		for(LONG n=0;n<lLenght;n++){
			MenuCategory cat;
			MSXML::IXMLDOMNodePtr pCategory;
			MSXML::IXMLDOMNodeListPtr pEntriesList;
			MSXML::IXMLDOMNodePtr pValue;
			pCategory=pNodeList->Getitem(n);
			pAttribMap=pCategory->Getattributes();
			pNode=pAttribMap->getNamedItem("caption");
			cat.sCaption=(TCHAR *)pNode->Gettext();
			pEntriesList=pCategory->GetchildNodes();// getElementsByTagName(_T("entry"));
			LONG nNumOfEntries=0;
			pEntriesList->get_length(&nNumOfEntries);

			ATLTRACE("-----------------------------------------\n");
			for(LONG j=0;j<nNumOfEntries;j++){
				try{
					MenuProject project;
					_String recursive;
					MSXML::IXMLDOMNodePtr pEntry;
					MSXML::IXMLDOMNodePtr pCaption;
					MSXML::IXMLDOMNodePtr pDatabase;
					MSXML::IXMLDOMNodePtr pProjFolder;
					MSXML::IXMLDOMNodePtr pDestFolder;
					MSXML::IXMLDOMNodePtr pRecursive;

					pEntry=pEntriesList->Getitem(j);
					pAttribMap2=pEntry->Getattributes();
					pCaption=pAttribMap2->getNamedItem(_bstr_t("caption"));
					pDatabase=pAttribMap2->getNamedItem(_bstr_t("database"));
					pProjFolder=pAttribMap2->getNamedItem(_bstr_t("projfolder"));
					pDestFolder=pAttribMap2->getNamedItem(_bstr_t("destinationfolder"));
					pRecursive=pAttribMap2->getNamedItem(_bstr_t("recursive"));
					
					project.sCaption=(TCHAR *)pCaption->Gettext();
					project.sDestinationFolder=(TCHAR *)pDestFolder->Gettext();
					project.sVSSDatabase=(TCHAR *)pDatabase->Gettext();
					project.sVSSProjPath=(TCHAR *)pProjFolder->Gettext();
					recursive=(TCHAR *)pRecursive->Gettext();
					if(recursive==_T("true"))
						project.bRecursive=true;
					else
						project.bRecursive=false;

					project.nMenuID=nMenuID++;

					ATLTRACE("\tENTRY------\n");
					ATLTRACE("\tCaption: %s\n",(TCHAR *)project.sCaption.c_str());
					ATLTRACE("\tDestFolder: %s\n",(TCHAR *)project.sDestinationFolder.c_str());
					ATLTRACE("\tDatabase: %s\n",(TCHAR *)project.sVSSDatabase.c_str());
					ATLTRACE("\tProjFolder: %s\n",(TCHAR *)project.sVSSProjPath.c_str());
					ATLTRACE("\t-----------\n");

					cat.lstMenus.push_front(project);
				}
				catch(_com_error &){
					ATLTRACE("--warning!--(xml error)\n");
					continue;
				}
			}
			ATLTRACE("-----------------------------------------\n");
			m_lstCategories.push_front(cat);
		}
		
	}
	catch(_com_error &){
		ATLTRACE("--warning!--(xml error)\n");
		
	}
	catch(...){
		return E_FAIL;
		
	}
	return S_OK;
}