// OutputDialog.cpp: implementation of the COutputDialog class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "AssManShellExt.h"
#include "AssManMenu.h"
#include "OutputDialog.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

LRESULT COutputDialog::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	LVCOLUMN rCol = { LVCF_FMT | LVCF_TEXT, LVCFMT_LEFT, 0, _T("Filename") };
	// List control initialization.
	
	m_hList = GetDlgItem(IDC_LIST);
	
	ListView_InsertColumn(m_hList, 0, &rCol);
	
	rCol.mask |= LVCF_SUBITEM;
	rCol.pszText = _T("Output");
	rCol.iSubItem = 1;
	
	ListView_InsertColumn(m_hList, 1, &rCol);
	
	ListView_SetColumnWidth(m_hList, 0, LVSCW_AUTOSIZE_USEHEADER);
	ListView_SetColumnWidth(m_hList, 1, LVSCW_AUTOSIZE_USEHEADER);
	
	// Show the window.
	
	CenterWindow(m_pCmdInfo->hwnd);
	ShowWindow(SW_SHOW);
	m_lsStatusMessages.clear();

	::EnableWindow(GetDlgItem(IDCANCEL), FALSE);
	::EnableWindow(GetDlgItem(IDC_STOP), TRUE);
	

	ATLTRACE("OnInitDialog");
	m_nListIndex=0;
	m_hThread=NULL;
	SetEvent(m_hReady);
	
	return 1;  // Let the system set the focus
}

LRESULT COutputDialog::OnItemchangedList(int idCtrl, LPNMHDR pnmh, BOOL& bHandled)
{
	NMLISTVIEW* pNMLV =(NMLISTVIEW*) pnmh;
	LVITEM      rItem = { 0 };
	// This handler is called when something about a list item changes.
	// We first check if there is a selection.  If not, ignore the message.
	
	if (-1 == pNMLV->iItem)
	{
		bHandled = false;
		return 0;
	}
	
	// If the item changing is becoming selected, display its associated
	// status message in the dialog.
	
	if (pNMLV->uNewState & LVIS_SELECTED)
	{
		rItem.mask  = LVIF_PARAM;
		rItem.iItem = pNMLV->iItem;
		
		ListView_GetItem(m_hList, &rItem);
		
		SetDlgItemText(IDC_STATUS, (LPCTSTR) rItem.lParam);
	}
	
	return 0;
}


void COutputDialog::AddDlgResult( _String file, _String result)
{
	LVITEM    rItem;
	m_lsStatusMessages.push_back(result);


	rItem.mask     = LVIF_PARAM | LVIF_TEXT;
	rItem.iItem    = m_nListIndex;
	rItem.iSubItem = 0;
	rItem.pszText  = const_cast < LPTSTR>(file.c_str());
	rItem.lParam   =(LPARAM) m_lsStatusMessages.back().c_str();
		
	ListView_InsertItem(m_hList, &rItem);
		
		// Set the text in column 2 to "succeeded" or "failed" depending 
		// on the outcome of the function call.
		
	ListView_SetItemText(m_hList, m_nListIndex++, 1, (TCHAR *)result.c_str());
	ListView_SetColumnWidth(m_hList, 0, LVSCW_AUTOSIZE_USEHEADER);
	ListView_SetColumnWidth(m_hList, 1, LVSCW_AUTOSIZE_USEHEADER);
	ListView_Scroll(m_hList,0,2000);

}

void COutputDialog::SetCompleted()
{
	::EnableWindow(GetDlgItem(IDCANCEL), TRUE);
	::SetWindowText(GetDlgItem(IDCANCEL),_T("OKI DOKI"));
	::EnableWindow(GetDlgItem(IDC_STOP), FALSE);
	
}

void COutputDialog::SetCurrFile(const TCHAR *sLabel)
{
	SetDlgItemText(IDC_CURRFILE, sLabel);
}
