// OutputDialog.h: interface for the COutputDialog class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OUTPUTDIALOG_H__B600D203_4AD9_4BB4_BA03_08A6F5A160B9__INCLUDED_)
#define AFX_OUTPUTDIALOG_H__B600D203_4AD9_4BB4_BA03_08A6F5A160B9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "resource.h"       // main symbols
#include <atlhost.h>
#include <shlobj.h>

class COutputDialog : public CDialogImpl<COutputDialog>
{
public:
	 
	COutputDialog ( ) :
			m_bStopSign(false), m_hList(NULL)
				
			{ }
			
			virtual ~COutputDialog() { }
			
			enum { IDD = IDD_OUTPUTDIALOG };
			
			BEGIN_MSG_MAP(CResultDialog)
				MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
				NOTIFY_HANDLER(IDC_LIST, LVN_ITEMCHANGED, OnItemchangedList)
				COMMAND_ID_HANDLER(IDC_STOP, OnStop)
				COMMAND_ID_HANDLER(IDCANCEL, OnCancel)
				END_MSG_MAP()
				
				LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
			LRESULT OnItemchangedList(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);
			
			LRESULT OnStop(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
			{
				_Module.m_bAbort=true;
				::MessageBox(this->m_pCmdInfo->hwnd,_T("Operation Aborted"),_T("AssMan"),MB_OK);
				::EnableWindow(GetDlgItem(IDCANCEL), TRUE);
				::EnableWindow(GetDlgItem(IDC_STOP), FALSE);

        m_bStopSign = true;
				return 0;
			}
			
			LRESULT OnCancel(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
			{
				_Module.m_bAbort=true;
				try{
				
				ATLTRACE("OnCancel\n");
				::WaitForSingleObject(m_hReady, 15000);
				::WaitForSingleObject(m_hThread, 15000);
				EndDialog(wID);
				}catch(...)
				{
					ATLTRACE("Error OnCancel\n");
				}
				return 0;
			}

			void SetCurrFile(const TCHAR *sLabel);
public:
	void SetCompleted();
	void AddDlgResult(_String file,_String result);
	bool         m_bStopSign;
	HWND         m_hList;
	HANDLE m_hReady;
	STRING_LIST  m_lsStatusMessages;    
	CMINVOKECOMMANDINFO* m_pCmdInfo;
	_String m_strMessage;
	unsigned long m_nListIndex;
	HANDLE m_hThread;
	
	
	
};

#endif // !defined(AFX_OUTPUTDIALOG_H__B600D203_4AD9_4BB4_BA03_08A6F5A160B9__INCLUDED_)
