using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace BuildMonkey
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class BuildMonkey : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button m_BuildButton;
		private System.Windows.Forms.ComboBox m_LabelCombo;
		private System.Windows.Forms.GroupBox m_LabelGroupBox;
		private System.Windows.Forms.RadioButton m_LabelRadioWeekly;
		private System.Windows.Forms.RadioButton m_LabelRadioCustom;
		private System.Windows.Forms.TextBox m_LabelCustomText;
		private System.Windows.Forms.RadioButton m_LabelRadioNoLabel;
		private System.Windows.Forms.GroupBox m_BuildTypeGroup;
		private System.Windows.Forms.RadioButton m_BuildTypeFull;
		private System.Windows.Forms.RadioButton m_BuildTypeCode;
		private System.Windows.Forms.RadioButton m_BuildTypeArt;
		private System.Windows.Forms.GroupBox m_BuildOptionsGroup;
		private System.Windows.Forms.CheckBox m_UseIncrediBuild;
		private System.Windows.Forms.CheckBox m_FastBuild;
		private System.Windows.Forms.RadioButton m_BuildTypeInstallshield;
		private System.Windows.Forms.ComboBox m_ComboBuildConfig;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public BuildMonkey()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			// set label by default to the current day of the week
			InitLabelCombo();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(BuildMonkey));
			this.m_BuildButton = new System.Windows.Forms.Button();
			this.m_LabelCombo = new System.Windows.Forms.ComboBox();
			this.m_LabelGroupBox = new System.Windows.Forms.GroupBox();
			this.m_LabelCustomText = new System.Windows.Forms.TextBox();
			this.m_LabelRadioCustom = new System.Windows.Forms.RadioButton();
			this.m_LabelRadioWeekly = new System.Windows.Forms.RadioButton();
			this.m_LabelRadioNoLabel = new System.Windows.Forms.RadioButton();
			this.m_BuildTypeGroup = new System.Windows.Forms.GroupBox();
			this.m_BuildTypeInstallshield = new System.Windows.Forms.RadioButton();
			this.m_BuildTypeArt = new System.Windows.Forms.RadioButton();
			this.m_BuildTypeCode = new System.Windows.Forms.RadioButton();
			this.m_BuildTypeFull = new System.Windows.Forms.RadioButton();
			this.m_BuildOptionsGroup = new System.Windows.Forms.GroupBox();
			this.m_FastBuild = new System.Windows.Forms.CheckBox();
			this.m_UseIncrediBuild = new System.Windows.Forms.CheckBox();
			this.m_ComboBuildConfig = new System.Windows.Forms.ComboBox();
			this.m_LabelGroupBox.SuspendLayout();
			this.m_BuildTypeGroup.SuspendLayout();
			this.m_BuildOptionsGroup.SuspendLayout();
			this.SuspendLayout();
			// 
			// m_BuildButton
			// 
			this.m_BuildButton.Location = new System.Drawing.Point(384, 272);
			this.m_BuildButton.Name = "m_BuildButton";
			this.m_BuildButton.Size = new System.Drawing.Size(112, 32);
			this.m_BuildButton.TabIndex = 0;
			this.m_BuildButton.Text = "Build";
			this.m_BuildButton.Click += new System.EventHandler(this.BuildButton_Click);
			// 
			// m_LabelCombo
			// 
			this.m_LabelCombo.Items.AddRange(new object[] {
															  "MON",
															  "TUE",
															  "WED",
															  "THU",
															  "FRI",
															  "SAT",
															  "SUN"});
			this.m_LabelCombo.Location = new System.Drawing.Point(152, 64);
			this.m_LabelCombo.Name = "m_LabelCombo";
			this.m_LabelCombo.Size = new System.Drawing.Size(136, 21);
			this.m_LabelCombo.TabIndex = 1;
			// 
			// m_LabelGroupBox
			// 
			this.m_LabelGroupBox.Controls.Add(this.m_LabelCustomText);
			this.m_LabelGroupBox.Controls.Add(this.m_LabelRadioCustom);
			this.m_LabelGroupBox.Controls.Add(this.m_LabelRadioWeekly);
			this.m_LabelGroupBox.Controls.Add(this.m_LabelRadioNoLabel);
			this.m_LabelGroupBox.Controls.Add(this.m_LabelCombo);
			this.m_LabelGroupBox.Location = new System.Drawing.Point(192, 8);
			this.m_LabelGroupBox.Name = "m_LabelGroupBox";
			this.m_LabelGroupBox.Size = new System.Drawing.Size(304, 160);
			this.m_LabelGroupBox.TabIndex = 2;
			this.m_LabelGroupBox.TabStop = false;
			this.m_LabelGroupBox.Text = "Label";
			// 
			// m_LabelCustomText
			// 
			this.m_LabelCustomText.Enabled = false;
			this.m_LabelCustomText.Location = new System.Drawing.Point(152, 96);
			this.m_LabelCustomText.Name = "m_LabelCustomText";
			this.m_LabelCustomText.Size = new System.Drawing.Size(136, 20);
			this.m_LabelCustomText.TabIndex = 3;
			this.m_LabelCustomText.Text = "Master";
			// 
			// m_LabelRadioCustom
			// 
			this.m_LabelRadioCustom.Location = new System.Drawing.Point(24, 96);
			this.m_LabelRadioCustom.Name = "m_LabelRadioCustom";
			this.m_LabelRadioCustom.Size = new System.Drawing.Size(120, 24);
			this.m_LabelRadioCustom.TabIndex = 2;
			this.m_LabelRadioCustom.Text = "Custom Label";
			this.m_LabelRadioCustom.CheckedChanged += new System.EventHandler(this.LabelRadioCustom_CheckedChanged);
			// 
			// m_LabelRadioWeekly
			// 
			this.m_LabelRadioWeekly.Checked = true;
			this.m_LabelRadioWeekly.Location = new System.Drawing.Point(24, 64);
			this.m_LabelRadioWeekly.Name = "m_LabelRadioWeekly";
			this.m_LabelRadioWeekly.Size = new System.Drawing.Size(120, 24);
			this.m_LabelRadioWeekly.TabIndex = 1;
			this.m_LabelRadioWeekly.TabStop = true;
			this.m_LabelRadioWeekly.Text = "Weekly Label";
			this.m_LabelRadioWeekly.CheckedChanged += new System.EventHandler(this.LabelRadioWeekly_CheckedChanged);
			// 
			// m_LabelRadioNoLabel
			// 
			this.m_LabelRadioNoLabel.Location = new System.Drawing.Point(24, 32);
			this.m_LabelRadioNoLabel.Name = "m_LabelRadioNoLabel";
			this.m_LabelRadioNoLabel.Size = new System.Drawing.Size(120, 24);
			this.m_LabelRadioNoLabel.TabIndex = 0;
			this.m_LabelRadioNoLabel.Text = "Don\'t Use Labels";
			this.m_LabelRadioNoLabel.CheckedChanged += new System.EventHandler(this.LabelRadioNoLabel_CheckedChanged);
			// 
			// m_BuildTypeGroup
			// 
			this.m_BuildTypeGroup.Controls.Add(this.m_BuildTypeInstallshield);
			this.m_BuildTypeGroup.Controls.Add(this.m_BuildTypeArt);
			this.m_BuildTypeGroup.Controls.Add(this.m_BuildTypeCode);
			this.m_BuildTypeGroup.Controls.Add(this.m_BuildTypeFull);
			this.m_BuildTypeGroup.Location = new System.Drawing.Point(16, 8);
			this.m_BuildTypeGroup.Name = "m_BuildTypeGroup";
			this.m_BuildTypeGroup.Size = new System.Drawing.Size(160, 160);
			this.m_BuildTypeGroup.TabIndex = 3;
			this.m_BuildTypeGroup.TabStop = false;
			this.m_BuildTypeGroup.Text = "Build Type";
			// 
			// m_BuildTypeInstallshield
			// 
			this.m_BuildTypeInstallshield.Location = new System.Drawing.Point(16, 128);
			this.m_BuildTypeInstallshield.Name = "m_BuildTypeInstallshield";
			this.m_BuildTypeInstallshield.Size = new System.Drawing.Size(112, 24);
			this.m_BuildTypeInstallshield.TabIndex = 3;
			this.m_BuildTypeInstallshield.Text = "InstallShield Build";
			this.m_BuildTypeInstallshield.CheckedChanged += new System.EventHandler(this.m_BuildTypeInstallshield_CheckedChanged);
			// 
			// m_BuildTypeArt
			// 
			this.m_BuildTypeArt.Location = new System.Drawing.Point(16, 96);
			this.m_BuildTypeArt.Name = "m_BuildTypeArt";
			this.m_BuildTypeArt.Size = new System.Drawing.Size(80, 24);
			this.m_BuildTypeArt.TabIndex = 2;
			this.m_BuildTypeArt.Text = "Art Build";
			this.m_BuildTypeArt.CheckedChanged += new System.EventHandler(this.BuildTypeArt_CheckedChanged);
			// 
			// m_BuildTypeCode
			// 
			this.m_BuildTypeCode.Location = new System.Drawing.Point(16, 64);
			this.m_BuildTypeCode.Name = "m_BuildTypeCode";
			this.m_BuildTypeCode.Size = new System.Drawing.Size(80, 24);
			this.m_BuildTypeCode.TabIndex = 1;
			this.m_BuildTypeCode.Text = "Code Build";
			this.m_BuildTypeCode.CheckedChanged += new System.EventHandler(this.BuildTypeCode_CheckedChanged);
			// 
			// m_BuildTypeFull
			// 
			this.m_BuildTypeFull.Checked = true;
			this.m_BuildTypeFull.Location = new System.Drawing.Point(16, 32);
			this.m_BuildTypeFull.Name = "m_BuildTypeFull";
			this.m_BuildTypeFull.Size = new System.Drawing.Size(80, 24);
			this.m_BuildTypeFull.TabIndex = 0;
			this.m_BuildTypeFull.TabStop = true;
			this.m_BuildTypeFull.Text = "Full Build";
			this.m_BuildTypeFull.CheckedChanged += new System.EventHandler(this.BuildTypeFull_CheckedChanged);
			// 
			// m_BuildOptionsGroup
			// 
			this.m_BuildOptionsGroup.Controls.Add(this.m_FastBuild);
			this.m_BuildOptionsGroup.Controls.Add(this.m_UseIncrediBuild);
			this.m_BuildOptionsGroup.Controls.Add(this.m_ComboBuildConfig);
			this.m_BuildOptionsGroup.Location = new System.Drawing.Point(16, 184);
			this.m_BuildOptionsGroup.Name = "m_BuildOptionsGroup";
			this.m_BuildOptionsGroup.Size = new System.Drawing.Size(160, 120);
			this.m_BuildOptionsGroup.TabIndex = 4;
			this.m_BuildOptionsGroup.TabStop = false;
			this.m_BuildOptionsGroup.Text = "Build Options";
			// 
			// m_FastBuild
			// 
			this.m_FastBuild.Location = new System.Drawing.Point(24, 56);
			this.m_FastBuild.Name = "m_FastBuild";
			this.m_FastBuild.Size = new System.Drawing.Size(112, 24);
			this.m_FastBuild.TabIndex = 1;
			this.m_FastBuild.Text = "Fast Build";
			// 
			// m_UseIncrediBuild
			// 
			this.m_UseIncrediBuild.Location = new System.Drawing.Point(24, 24);
			this.m_UseIncrediBuild.Name = "m_UseIncrediBuild";
			this.m_UseIncrediBuild.Size = new System.Drawing.Size(112, 24);
			this.m_UseIncrediBuild.TabIndex = 0;
			this.m_UseIncrediBuild.Text = "Use IncrediBuild";
			// 
			// m_ComboBuildConfig
			// 
			this.m_ComboBuildConfig.Items.AddRange(new object[] {
																	"Profile",
																	"Release",
																	"Debug"});
			this.m_ComboBuildConfig.Location = new System.Drawing.Point(24, 88);
			this.m_ComboBuildConfig.Name = "m_ComboBuildConfig";
			this.m_ComboBuildConfig.Size = new System.Drawing.Size(112, 21);
			this.m_ComboBuildConfig.TabIndex = 5;
			this.m_ComboBuildConfig.Text = "Profile";
			// 
			// BuildMonkey
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(512, 317);
			this.Controls.Add(this.m_BuildOptionsGroup);
			this.Controls.Add(this.m_BuildTypeGroup);
			this.Controls.Add(this.m_LabelGroupBox);
			this.Controls.Add(this.m_BuildButton);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Name = "BuildMonkey";
			this.Text = "BuildMonkey";
			this.m_LabelGroupBox.ResumeLayout(false);
			this.m_BuildTypeGroup.ResumeLayout(false);
			this.m_BuildOptionsGroup.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new BuildMonkey());
		}

		private void InitLabelCombo()
		{
			switch(System.DateTime.Now.DayOfWeek)
			{
				case DayOfWeek.Monday:
					m_LabelCombo.Text = "MON";
					break;
				case DayOfWeek.Tuesday:
					m_LabelCombo.Text = "TUE";
					break;
				case DayOfWeek.Wednesday:
					m_LabelCombo.Text = "WED";
					break;
				case DayOfWeek.Thursday:
					m_LabelCombo.Text = "THU";
					break;
				case DayOfWeek.Friday:
					m_LabelCombo.Text = "FRI";
					break;
				case DayOfWeek.Saturday:
					m_LabelCombo.Text = "SAT";
					break;
				case DayOfWeek.Sunday:
					m_LabelCombo.Text = "SUN";
					break;
			}
		}

		private string GetLabel()
		{
			if (m_LabelRadioWeekly.Checked)
				return m_LabelCombo.Text;

			if (m_LabelRadioCustom.Checked)
				return m_LabelCustomText.Text;

			return "";
		}

		private string GetBuildType()
		{
			if (m_BuildTypeCode.Checked)
				return "Code";

			if (m_BuildTypeArt.Checked)
				return "Art";

			if (m_BuildTypeInstallshield.Checked)
				return "Installshield";

			return "Full";
		}

		private void BuildButton_Click(object sender, System.EventArgs e)
		{
			// build command-line
			string cmdLine = "buildmonkey_build.js";

			// labeled build
			string label = GetLabel();
			if (label != "")
			{
				cmdLine += " /SSafeCodeLabel:" + label;
			}

			// kind of build
			string buildType = GetBuildType();
			if (buildType != "")
			{
				cmdLine += " /BuildType:" + buildType;
			}

			// config to use for build
			cmdLine += " /BuildConfig:" + m_ComboBuildConfig.Text;

			// try to use IncrediBuild?
			if (m_UseIncrediBuild.Enabled && m_UseIncrediBuild.Checked)
			{
				cmdLine += " /UseIncrediBuild:true";
			}

			// 
			if (m_FastBuild.Enabled && m_FastBuild.Checked)
			{
				cmdLine += " /FastBuild:true";
			}

			// execute the
			System.Diagnostics.Process.Start("cscript", cmdLine);
		}

		private void DoInstallShieldBuild()
		{
			System.Windows.Forms.MessageBox.Show("Make sure that D:/MasterCD_Install/Root contains all files to be included in the build!");
		}

		private void LabelRadioNoLabel_CheckedChanged(object sender, System.EventArgs e)
		{
			m_LabelCombo.Enabled = false;
			m_LabelCustomText.Enabled = false;
		}

		private void LabelRadioWeekly_CheckedChanged(object sender, System.EventArgs e)
		{
			m_LabelCombo.Enabled = true;
			m_LabelCustomText.Enabled = false;
		}

		private void LabelRadioCustom_CheckedChanged(object sender, System.EventArgs e)
		{
			m_LabelCombo.Enabled = false;
			m_LabelCustomText.Enabled = true;		
		}

		private void BuildTypeCode_CheckedChanged(object sender, System.EventArgs e)
		{
			m_UseIncrediBuild.Enabled = true;
			m_FastBuild.Enabled = true;
		}

		private void BuildTypeFull_CheckedChanged(object sender, System.EventArgs e)
		{
			m_UseIncrediBuild.Enabled = true;
			m_FastBuild.Enabled = true;
		}

		private void BuildTypeArt_CheckedChanged(object sender, System.EventArgs e)
		{
			m_UseIncrediBuild.Enabled = false;
			m_FastBuild.Enabled = true;
		}

		private void m_BuildTypeInstallshield_CheckedChanged(object sender, System.EventArgs e)
		{
			m_UseIncrediBuild.Enabled = true;
			m_FastBuild.Enabled = true;
		}
	}
}
