// JScript.

///////////////////////////////////////////////////////////////////////////////
// Globals.
///////////////////////////////////////////////////////////////////////////////

// Create Shell objects.
var WshShell = WScript.CreateObject("WScript.Shell");
var FSO = WScript.CreateObject("Scripting.FileSystemObject");
var ForReading = 1, ForWriting = 2, ForAppending = 8;
var TristateUseDefault = -2, TristateTrue = -1, TristateFalse = 0;
  
var Result = 0;
var Error = false;
var ErrorString = "";

// Email where confirmation Emails are sent.
var SuccessEmail="xcode@crytek.de";
var FailEmail="xcode@crytek.de";
var MailLogin="MS Exchange Settings";

var BuildNumber = 0;
var BuildLog = "build.log" 
var LogFile;
// Timings.
var StartTime,EndTime;
var StartSSafeTime,EndSSafeTime;
var StartCompileTime,EndCompileTime;
var StartFinalCopyTime,EndFinalCopyTime;

// Source safe executable.
var SSafeCode = "\\\\Server1\\Vss\\win32\\ss.exe";
var SSafeArtwork = "\\\\Server2\\XISLE\\ArtworkVss\\win32\\ss.exe";
var SSafeCodeProject = "$/FarCryPatch1/SourceCode";
var SSafeCodeProjectAdditional = "$/Game01AdditionalFiles";
var SSafeProject_Scripts = "$/FarCryPatch1/Scripts";
var SSafeProject_Shaders = "$/FarCryPatch1/Shaders";
var SSafeArtworkProject = "$/MASTERCD";
var SSafeLog = "ss.log";

var StorageDrive = "E:";
var BuildDrive = "D:";
var TempDrive = "D:";

var MasterCD = "C:\\MasterCD";
var SourcesFolder = "Sources";
var MasterCDInstall = BuildDrive+"\\MasterCD_Install";
var TargetMasterCD = BuildDrive+"\\MasterCD_Build";
var TargetMasterCD_Packs = BuildDrive+"\\MasterCD_Build";
var StorageMasterCD = StorageDrive+"\\MasterCDs";
var StorageAssets = StorageDrive+"\\Assets";
var TargetMasterCD_InMail = "S:";
var TargetSourcesFolder = StorageDrive+"\\Sources";
var InstallShieldDestinationFolder = StorageDrive+"\\Installs";
var PaksFolder = "FCData";

var CppLog = "cpp.log";
var MsDevStudio = "\"C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Common7\\Ide\\devenv.exe\"";
var WinRar = "\"C:\\Program Files\\WinRar\\WinRar.exe\"";
var BuildConsole = "\"C:\\Program Files\\Xoreax\\IncrediBuild\\BuildConsole.exe\""; // Incredibuild Command Line build tool.
var ResourceCompiler = MasterCD+"/Bin32/rc.exe"; // Incredibuild Command Line build tool.
var FarCryCppWorkspace = SourcesFolder + "\\Game01.sln";
var FarCryCppProject = "FarCry";
var WaterMarkDLL = MasterCD+"/Bin32/CrySystem.dll";

var StartTime = new Date();

var oCompileShell;

///////////////////////////////////////////////////////////////////////////////
// Process Command-Line parameters
///////////////////////////////////////////////////////////////////////////////

var SSafeCodeLabel = "";

if (WScript.Arguments.Named.Exists("SSafeCodeLabel"))
{
	SSafeCodeLabel = WScript.Arguments.Named.Item("SSafeCodeLabel");
}

var BuildType = "Full";
var BuildCode = true;
var BuildArt  = true;
var InstallShield = false;

if (WScript.Arguments.Named.Exists("BuildType"))
{
	BuildType = WScript.Arguments.Named.Item("BuildType");
}

if (BuildType == "Full")
{
	BuildCode = true;
	BuildArt  = true;
}
else if (BuildType == "Code")
{
	BuildCode = true;
	BuildArt  = false;
}
else if (BuildType == "Art")
{
	BuildCode = false;
	BuildArt  = true;
}
else if (BuildType == "Installshield")
{
	BuildType = "Full";
	BuildCode = true;
	BuildArt  = true;
	InstallShield = true;
}

var UseIncrediBuild = false;
if (WScript.Arguments.Named.Exists("UseIncrediBuild"))
{
	if (WScript.Arguments.Named.Item("UseIncrediBuild") == "true")
		UseIncrediBuild = true;
	else
		UseIncrediBuild = false;
}

// 
var FastBuild = false;
if (WScript.Arguments.Named.Exists("FastBuild"))
{
	if (WScript.Arguments.Named.Item("FastBuild") == "true")
		FastBuild = true;
	else
		FastBuild = false;
}

var BuildConfig = "Profile";
if (WScript.Arguments.Named.Exists("BuildConfig"))
{
	BuildConfig = WScript.Arguments.Named.Item("BuildConfig");
}


///////////////////////////////////////////////////////////////////////////////
// Functions.
///////////////////////////////////////////////////////////////////////////////

var NumLogs = 0;
function Log(str) 
{
	LogFile.WriteLine( str );
	WScript.StdOut.WriteLine( str );

	NumLogs = NumLogs + 1;
}

///////////////////////////////////////////////////////////////////////////////
// Logs time of operation and elapsed time since start of build.
///////////////////////////////////////////////////////////////////////////////
function LogTime( t0 )
{
	var tnow = new Date();
	Log( "Done in "+GetTimeDiff(t0,tnow) );
	Log( "Elapsed time since build start: "+GetTimeDiff(StartTime,tnow) );
	Log("");
}

function MailSuccess()
{
	// Send build confirmation Message.
	var files = new Array();
	files[0] = MakeFullName( BuildLog );
	files[1] = MakeFullName( SSafeLog );
	files[2] = MakeFullName( CppLog );
	var Msg = "Automated Daily Build at "+GetDateString()+", "+GetTimeString()+" completed successfully.";
	Msg = Msg + "\n\nLatest Build is Located at "+ TargetMasterCD_InMail;
	Msg = Msg + "\nTotal Build Time: "+GetTimeDiff(StartTime,EndTime);
	var str = " ";
	if (FastBuild) str = " Fast ";
	SendMail( SuccessEmail,Msg,"Automated Daily"+str+"Build, "+GetDateString()+", "+GetTimeString(),files,1 );
}

function MailFailure()
{
	// Send build confirmation Message.
	var files = new Array();
	files[0] = MakeFullName( BuildLog );
	files[1] = MakeFullName( SSafeLog );
	files[2] = MakeFullName( CppLog );
	var str = " ";
	if (FastBuild) str = " Fast ";
	SendMail( FailEmail,"Automated Daily"+str+"Build at "+GetDateString()+", "+GetTimeString()+" failed.","Automated Daily Build Failed, "+GetDateString(),files,2 );
}

function EndLog()
{
	EndTime = new Date();
   
	Log( "Build ended at " + GetDateString() + ", " + GetTimeString()  );

	if (BuildCode)
	{	
		Log( "Source Safe Retrieve Time(Code): "+GetTimeDiff(StartSSafeTime,EndSSafeTime) );
		Log( "Compile Time: "+GetTimeDiff(StartCompileTime,EndCompileTime) );
	}
	if (BuildArt)
	{	
		Log( "Source Safe Retrieve Time(MasterCD): "+GetTimeDiff(StartSSafeTimeMasterCD,EndSSafeTimeMasterCD) );
	}	
	Log( "Final Copy Time: "+GetTimeDiff(StartFinalCopyTime,EndFinalCopyTime) );
	Log( "Total Build Time: "+GetTimeDiff(StartTime,EndTime) );
	Log("Build succesfully finished.");
	
	// Log Success event.
	WshShell.LogEvent( 0, "Automated Daily Build Completed Successfully" );
	
	MailSuccess();
}

function GetTimeDiff( t0,t1 )
{
	var TimeDiff = t1.getTime() - t0.getTime();
	var SecMilli = 1000;
	var MinMilli = 1000 * 60;
	var HrMilli = MinMilli * 60;
	var DyMilli = HrMilli * 24;
	
	var t,h,m,s;
	t = TimeDiff;
	h = Math.floor( t / HrMilli);
	t = TimeDiff % HrMilli;
	m = Math.floor( t / MinMilli );
	t = t % MinMilli;
	s = Math.floor( t / SecMilli );
	var str = ""+h+"h:"+m+"m:"+s+"s";
	return str;
}

function GetDateString()
{
	var d = new Date()
	return d.getDate() + "/" + (d.getMonth()+1)+"/"+d.getYear();
}

function GetTimeString_PathCompliant()
{
	
	 var d = new Date();
	 var c = "_";
   var s = "("+d.getHours() + c + d.getMinutes() + c + d.getSeconds()+")";
   return(s);
}


function GetTimeString()
{
	 var d = new Date();
	 var c = ":";
   var s = d.getHours() + c + d.getMinutes() + c + d.getSeconds();
   return(s);
}

function DeleteFiles( FileSpec )
{
	Log( "Delete Files: "+FileSpec );
	WshShell.Run( "cmd /c del "+FileSpec+" /F /S /Q",1,true );
}

function MakeFolder( folder )
{
	Log( "Making Folder: "+folder );
	//WshShell.Run( "cmd /E:ON /C mkdir "+folder,1,true );
	if (FSO.FolderExists(folder) == false)
	{
		try
		{
			FSO.CreateFolder(folder);
		}
		catch(e)
		{
			Log("Warning: "+e.Description);
		}
	}
}

// e.g. PackFolder("c:/dir","destzipfile.zip")
// needs pkzip25 to be installed
// Pack folder with params.
// ratio = 0 store 1,2,3,4.. compress.
// exclude file.
function PackFolder( basesourcedir,sourcedir,destzipfile,ratio,excludeListFile,includeListFile )
{
	Log( "Pack Folder "+sourcedir+" to "+destzipfile );
	
	var t0 = new Date();

	var curDir = WshShell.CurrentDirectory;
  
	// Sets current directory to source dir
	WshShell.CurrentDirectory = basesourcedir;
	
	
	var cmdline = curDir+"/pkzip25.exe -add=update -dir=current -Recurse -nozipextension -nofix "+destzipfile+" ";

	if (excludeListFile != "")
		cmdline += "-excl=@"+ curDir + "\\" + excludeListFile + " ";
	
	if (includeListFile != "")
		cmdline += "-include=@" + curDir + "\\" + includeListFile + " ";
	else
	{
		if (sourcedir != "")
			cmdline += " "+sourcedir+"\\* ";
		else
			cmdline += " * ";
	}
		
	if (ratio == 0)
		cmdline += "-store ";
	else if (ratio == 1)
		cmdline += "-fast ";
	else if (ratio == 2)
		cmdline += "-max ";
 
	//WshShell.Run( curDir+"/pkzip25 -add -Directories -Recurse "+destzipfile+" *.*",1,true );
	// Store in archive not compress.
	/*
	var cmdline = curDir+"/7z.exe u -tzip " + destzipfile + " * -r -bd ";
	if (ratio == 0)
		cmdline += "-mx0 ";
	else if (ratio == 1)
		cmdline += "-mx1 ";
	else if (ratio == 2)
		cmdline += "-mx9 ";
		
	if (excludeListFile != "")
		cmdline += "-x@"+ curDir  + "\\" + excludeListFile + " ";
		*/
		
	Log( cmdline );
	WshShell.Run( cmdline, 1, true);
  
	// Restore previous directory.
	WshShell.CurrentDirectory = curDir;

	Log( "Pack Folder "+sourcedir+" to "+destzipfile+" Complete." );
	LogTime( t0 );
}

function PackFolderNoRecursive( basesourcedir,sourcedir,destzipfile,ratio,excludeListFile,includeListFile )
{
	Log( "Pack Folder "+sourcedir+" to "+destzipfile );
	
	var t0 = new Date();

	var curDir = WshShell.CurrentDirectory;
  
	// Sets current directory to source dir
	WshShell.CurrentDirectory = basesourcedir;
	
	
	var cmdline = curDir+"/pkzip25.exe -add=update -nozipextension -nofix "+destzipfile+" ";
	if (sourcedir != "")
		cmdline += " "+sourcedir+"\\*.* ";
	else
		cmdline += " *.* ";

	if (excludeListFile != "")
		cmdline += "-excl=@"+ curDir + "\\" + excludeListFile + " ";
	if (includeListFile != "")
		cmdline += "-include=@" + curDir + "\\" + includeListFile + " ";
		
	if (ratio == 0)
		cmdline += "-store ";
	else if (ratio == 1)
		cmdline += "-fast ";
	else if (ratio == 2)
		cmdline += "-max ";
 
	//WshShell.Run( curDir+"/pkzip25 -add -Directories -Recurse "+destzipfile+" *.*",1,true );
	// Store in archive not compress.
	/*
	var cmdline = curDir+"/7z.exe u -tzip " + destzipfile + " * -r -bd ";
	if (ratio == 0)
		cmdline += "-mx0 ";
	else if (ratio == 1)
		cmdline += "-mx1 ";
	else if (ratio == 2)
		cmdline += "-mx9 ";
		
	if (excludeListFile != "")
		cmdline += "-x@"+ curDir  + "\\" + excludeListFile + " ";
		*/
		
	Log( cmdline );
	WshShell.Run( cmdline, 1, true);
  
	// Restore previous directory.
	WshShell.CurrentDirectory = curDir;

	Log( "Pack Folder "+sourcedir+" to "+destzipfile+" Complete." );
	LogTime( t0 );
}

function PackFolder7z( sourcedir,destzipfile,ratio,excludeListFile,includeFiles )
{
	Log( "Pack Folder "+sourcedir+" to "+destzipfile );
	
	var t0 = new Date();

	var curDir = WshShell.CurrentDirectory;
  
	// Sets current directory to source dir
	WshShell.CurrentDirectory = sourcedir;
	
	// Store in archive not compress.
	var cmdline = curDir+"/7z.exe a -tzip " + destzipfile + " * -r -bd ";
	if (ratio == 0)
		cmdline += "-mx0 ";
	else if (ratio == 1)
		cmdline += "-mx1 ";
	else if (ratio == 2)
		cmdline += "-mx9 ";
		
	if (excludeListFile != "")
		cmdline += "-x@"+ curDir  + "\\" + excludeListFile + " ";
		
	if (includeFiles != "")
		cmdline += "-i!"+ includeFiles + " ";
		
	Log( cmdline );
	WshShell.Run( cmdline, 1, true);
  
	// Restore previous directory.
	WshShell.CurrentDirectory = curDir;

	Log( "Pack Folder "+sourcedir+" to "+destzipfile+" Complete." );
	LogTime( t0 );
}

function RarFolder( sourcedir,destzipfile,ratio,excludeListFile,includeFiles )
{
	Log( "Pack Folder "+sourcedir+" to "+destzipfile );
	
	var t0 = new Date();
	
	var curDir = WshShell.CurrentDirectory;
	WshShell.CurrentDirectory = sourcedir;

	// Store in archive not compress.
	// -r recursive, -ed not add empty folders.
	var cmdline = WinRar + " a " + destzipfile + " " + sourcedir + "\\* -r -ed ";
	if (ratio == 0)
		cmdline += "-m0 ";
	else if (ratio == 1)
		cmdline += "-m2 ";
	else if (ratio == 2)
		cmdline += "-m5 ";
		
	if (excludeListFile != "")
		cmdline += "-x@"+ curDir  + "\\" + excludeListFile + " ";
		
//	if (includeFiles != "")
	//	cmdline += "-i!"+ includeFiles + " ";
		
	Log( cmdline );
	WshShell.Run( cmdline, 1, true);
	
	WshShell.CurrentDirectory = curDir;
  
	Log( "Pack Folder "+sourcedir+" to "+destzipfile+" Complete." );
	LogTime( t0 );
}

function UnpackFolder( zipfile,targetFolder )
{
	Log( "UnPacking zip file "+zipfile+" to "+targetFolder );
	
	var t0 = new Date();

	var cmdline = curDir+"/pkzip25.exe -extr=all " + zipfile + "-dir " + targetFolder;
 
	Log( cmdline );
	WshShell.Run( cmdline, 1, true);

	LogTime( t0 );
}

function CopyFolder( dir1,dir2 )
{
	var t0 = new Date();
	Log( "Copy Folder "+dir1+" to "+dir2 );
	//FSO.CopyFolder(dir1,dir2,true);
	// Use xcopy instead.
	var cmdline = "xcopy " + dir1 + " " + dir2 + " /E /I /Q /R /K /Y";
	Log( cmdline );
	WshShell.Run( cmdline, 1, true);
	Log( "Copy Folder "+dir1+" to "+dir2+" Complete." );
	LogTime( t0 );
}

// Delete all temporary files.
function DeleteTemporary() 
{
	if (FSO.FileExists( SSafeLog ))
	{
		FSO.DeleteFile( SSafeLog );
	}
	if (FSO.FileExists( CppLog ))
	{
		FSO.DeleteFile( CppLog );
	}
	
	if (FastBuild)
		return;

	// Delete target MasterCD
	if (FSO.FolderExists( MasterCDInstall ))
		FSO.DeleteFolder( MasterCDInstall,true );
				
	// Delete MasterCD
	if (FSO.FolderExists( MasterCD ))
		FSO.DeleteFolder( MasterCD,true );

	if (FSO.FolderExists( TargetMasterCD ))
		FSO.DeleteFolder( TargetMasterCD,true );
		
	if (FSO.FolderExists( TargetMasterCD_Packs ))
		FSO.DeleteFolder( TargetMasterCD_Packs,true );
			
	// Delete Working folder.
	if (FSO.FolderExists( SourcesFolder ))
		FSO.DeleteFolder( SourcesFolder,true );
	
	// Open log.
  return;
}

//I didn't found a format expression to do that
function FormatMonth(n)
{
	if(n<10) {
		return "0"+n;
	}
	return n;
}

function GetBuildNumber()
{
	// Update Build number.
	var buildNo = 0;
	var file = FSO.GetFile( "build_number.txt" );
	var ts = file.OpenAsTextStream( ForReading,TristateUseDefault );
	var str = ts.Read(100);
  ts.Close();
  var buildNo = parseInt(str);
  if (isNaN(buildNo)) { buildNo = 0; }
  buildNo = buildNo+1;
  BuildNumber = buildNo;
  return BuildNumber;
}

function Init()
{

	LogFile = FSO.CreateTextFile( BuildLog,true );           // Create a file.
	// Log when build started.
	StartTime = new Date();
	
	if (!FastBuild)
	{
		Log( "Build started at " + GetDateString() + ", " + GetTimeString()  );
	}
	else
	{
		Log( "Fast Build started at " + GetDateString() + ", " + GetTimeString()  );
	}
	
	BuildNumber = GetBuildNumber();
	
	var d = StartTime;
	//TargetMasterCD = TargetMasterCD + "/MASTERCD" + "_" + FormatMonth(d.getMonth()+1) + "_" + d.getDate()+"_"+GetTimeString_PathCompliant(); // Ignore Year +"_"+d.getYear();
	
	var buildIdStr = "(" + BuildNumber + ")" + "_" + FormatMonth(d.getMonth()+1) + "_" + d.getDate();
	TargetMasterCD_InMail = TargetMasterCD_InMail + "\\MASTERCD" + buildIdStr;
	StorageMasterCD = StorageMasterCD + "\\MASTERCD" + buildIdStr;
	InstallShieldDestinationFolder = InstallShieldDestinationFolder + "\\Install" + buildIdStr;
	WScript.Echo ("Target MasterCD = "+StorageMasterCD+"\n");
	StorageAssets = StorageAssets + "\\MASTERCD" + buildIdStr;
	WScript.Echo ("Target Assets   = "+StorageAssets+"\n");
	TargetSourcesFolder = TargetSourcesFolder + "\\Source" + buildIdStr;
	WScript.Echo ("Target Sources  = "+TargetSourcesFolder+"\n");

	DeleteTemporary();

	MakeFolder(MasterCDInstall);
	MakeFolder(TargetMasterCD);
	MakeFolder(TargetMasterCD_Packs);
	MakeFolder(TargetMasterCD_Packs+"\\"+PaksFolder);
	MakeFolder(TargetMasterCD_Packs+"\\"+PaksFolder+"\\Localized");
}

function ErrorExit( ErrStr )
{
	ErrorString =ErrStr;
	Error = true;
	WshShell.LogEvent( 1, "Automated Daily Build Failed." );
	WshShell.LogEvent( 1,ErrorString );
	MailFailure();
	WScript.Echo (  ErrorString  );
	WScript.Quit(1);
}

function GetSourceSafeProject(  ssFile,ssProject,toFolder,label )
{
	Log( "--------------------------------" );
	Log( "Getting Project: "+ssProject+" From Source Safe Database: "+ssFile );
	// Make sure we create folder first.
	MakeFolder( toFolder );
	var ssLog = MakeFullName( SSafeLog );
	// -GTM Local copy is given the date and time that the file was last modified, not the current date and time.
	// -R Perform command recursively.
	// -I-Y Instructs VSS to answer Yes to all Yes or No questions.
	// -GLpath Copies a file to the specified folder, not to the current or working folder.
	var CmdLine = ssFile + " Get " + ssProject + " -GTM -R -I-Y -O&"+ssLog;
	if (toFolder != "")
	{
		CmdLine = CmdLine + " -GL"+toFolder;
	}
	if (label != "")
	{
		CmdLine = CmdLine + " -VL"+label;
	}
	Log(  CmdLine );
	var t0 = new Date();
	Result = WshShell.Run( CmdLine,1,true );
	if (Result != 0)
	{
		ErrorExit( "Error Getting Project: "+ssProject+" From Source Safe Database: "+ssFile );
		return false;
	}
	LogTime( t0 );
	return true;
}

function CompileProject(  workspace,project,config  )
{
	Log( "--------------------------------" );
	Log( "Compiling Solution: "+workspace+" In Configuration: "+config );
	var CmdLine;

	if (UseIncrediBuild)
	{
		CmdLine = BuildConsole + " "+workspace+" /Cfg=\"" + config + "\" /Prj=* /Rebuild /BrowseInfo=OFF /Log=" + CppLog;
		//CmdLine = BuildConsole + " "+workspace+" /Cfg=\"" + config + "\" /Prj=* /BrowseInfo=OFF /Log=" + CppLog;
	}
	else
	{
		CmdLine = MsDevStudio + " " + workspace + " /build "+config + " /out " + CppLog;
	}
	
	//var CmdLine = MsDevStudio + " " + workspace + " /MAKE "+project+" - "+config + " /REBUILD /OUT " + CppLog;
	Log( CmdLine );
	// # //c/msdev/common/MsDev98/bin/msdev $CPP_PROJECT /MAKE RELEASE /OUT cppbuild.log
	var t0 = new Date();
	
	/*
	oCompileShell = WshShell.Exec( CmdLine );
	if (!UseIncrediBuild)
	{
		while (oCompileShell.Status == 0)
		{
			WScript.Sleep(100);
		}
	}
	Result = oCompileShell.ExitCode;
	*/

	Result = WshShell.Run( CmdLine,1,true );
	if (Result != 0)
	{
		ErrorExit( "Error while compiling Project: "+project+" In Configuration: "+config );
		return false;
	}
	LogTime( t0 );
	return true;
}

function MakeFullName( FileName )
{
	return WScript.ScriptFullName.replace( WScript.ScriptName,"" ) + FileName;
}

function SendMail( recipient,msg,subject,attachmentsArray,importance )
{
	var objSession, oInbox, colMessages, oMessage, colRecipients,colAttachments;
	
	Log( "Sending Mail to "+recipient+", With subject: "+subject );

	objSession = new ActiveXObject( "MAPI.Session" );
	objSession.Logon( MailLogin );

	oInbox = objSession.Inbox;
	colMessages = oInbox.Messages;
	oMessage = colMessages.Add();
	colRecipients = oMessage.Recipients;
	colAttachments = oMessage.Attachments;
	
	colRecipients.Add( recipient );
	colRecipients.Resolve();
	
	var i;
	for (var i = 0; i < attachmentsArray.length; i++)
	{
		if (FSO.FileExists( attachmentsArray[i] ))
		{
			colAttachments.Add( attachmentsArray[i],0,1,attachmentsArray[i]  );
		}
	}
	
	oMessage.Importance = importance;
	oMessage.Subject = subject;
	oMessage.Text = msg;
	oMessage.Send();
	objSession.Logoff();
}

function UpdateResourceBuildNumber( rcFile,build1,build2,buildNo )
{
	var file,ts,str;
	
	/////////////////////////////////////////
	file = FSO.GetFile( rcFile );
	ts = file.OpenAsTextStream(  ForReading,TristateUseDefault );
	str = ts.Read(1000000);
  ts.Close();
   	
	var re1 = /^ FILEVERSION ([0-9]+),([0-9]+),([0-9]+),([0-9]+)/gm;
	var re2 = /^ PRODUCTVERSION ([0-9]+),([0-9]+),([0-9]+),([0-9]+)/gm;
	
	var re3 = /VALUE "FileVersion", "([0-9]+), ([0-9]+), ([0-9]+), ([0-9]+)/gm;
	var re4 = /VALUE "ProductVersion", "([0-9]+), ([0-9]+), ([0-9]+), ([0-9]+)/gm;
	
	str = str.replace( re1," FILEVERSION $1,"+build1+","+build2+","+buildNo );
	str = str.replace( re2," PRODUCTVERSION $1,"+build1+","+build2+","+buildNo );
	str = str.replace( re3,"VALUE \"FileVersion\", \"$1, "+build1+", "+build2+", "+buildNo );
	str = str.replace( re4,"VALUE \"ProductVersion\", \"$1, "+build1+", "+build2+", "+buildNo );
	
	var readOnly = false;
	// ReadOnly ?
	if (file.attributes & 1)
	{
		readOnly = true;
		// Clear read only flag.
		file.attributes = file.attributes & (~1);
	}
	
	var outfile = FSO.CreateTextFile( rcFile, true);
	outfile.Write( str );
	outfile.Close();
	
	if (readOnly)
	{
		file = FSO.GetFile( rcFile );
		file.attributes = file.attributes | 1;
	}
}

function UpdateBuildNumber()
{
	var d = new Date();
	var buildNum1 = d.getMonth()+1;
	var buildNum2 = d.getDate();

	var buildNum1 = 1;
	var buildNum2 = 1;
	
	// Update Build number.
	var buildNo = 0;
	var file = FSO.GetFile( "build_number.txt" );
	var ts = file.OpenAsTextStream( ForReading,TristateUseDefault );
	var str = ts.Read(100);
	ts.Close();
	var buildNo = parseInt(str);
	if (isNaN(buildNo)) { buildNo = 0; }
	buildNo = buildNo+1;
	str = buildNo;
	
	UpdateResourceBuildNumber( SourcesFolder + "/Editor/CryEdit.rc",buildNum1,buildNum2,buildNo );
	UpdateResourceBuildNumber( SourcesFolder + "/FarCry/FarCry.rc",buildNum1,buildNum2,buildNo );
	UpdateResourceBuildNumber( SourcesFolder + "/FarCry_WinSV/FarCry_WinSV.rc",buildNum1,buildNum2,buildNo );
	UpdateResourceBuildNumber( SourcesFolder + "/CrySystem/CrySystem.rc",buildNum1,buildNum2,buildNo );
}

function StampFarCryCRC32()
{
	var cmdline = "CryWaterMark.exe " + WaterMarkDLL;
	Log( cmdline );
	WshShell.Run( cmdline,1,true );
}

function SaveBuildNumber()
{
	// Update Build number.
	var buildNo = 0;
	var file = FSO.GetFile( "build_number.txt" );
	var ts = file.OpenAsTextStream( ForReading,TristateUseDefault );
	var str = ts.Read(100);
	ts.Close();
	var buildNo = parseInt(str);
	if (isNaN(buildNo)) { buildNo = 0; }
	buildNo = buildNo+1;
	str = buildNo;
	file = FSO.CreateTextFile( "build_number.txt" );
	file.Write( buildNo );
	file.Close();
}

///////////////////////////////////////////////////////////////////////////////
function GenCompiledCGFs()
{
	var t0 = new Date();
	// Remember current directory.
	var curDir = WshShell.CurrentDirectory;
  
    // Sets current directory to mastercd.
	WshShell.CurrentDirectory = TargetMasterCD;
 
	//var cmdline = "cmd /c " + curDir + "\\compile_cgfs.bat >> compile_cgfs.log";
	var cmdline = ResourceCompiler + " Objects\\*.cgf /quiet /AnimatedCGF=1 /StaticCGF=0 /logfiles";
	Log( cmdline );
	WshShell.Run( cmdline,1,true );

	cmdline = curDir+"/pkzip25.exe -add=update -fast -dir=current -Recurse -nozipextension -nofix "+TargetMasterCD_Packs+"\\"+PaksFolder+"\\CCGF_CACHE.PAK CCGF_CACHE/* -include=Objects/*.ccg";
	Log( cmdline );
	WshShell.Run( cmdline,1,true );
  
	// Restore previous directory.
	WshShell.CurrentDirectory = curDir;
	
	LogTime( t0 );
}

///////////////////////////////////////////////////////////////////////////////
// Make pak files.
///////////////////////////////////////////////////////////////////////////////
function MakePakFiles()
{
	// Make Pak folders if not exist.
	PackFolder( TargetMasterCD,"Objects",TargetMasterCD_Packs+"\\"+PaksFolder+"\\Objects.pak",1,"zip_noCommon.lst","" );
	PackFolder( TargetMasterCD,"Sounds",TargetMasterCD_Packs+"\\"+PaksFolder+"\\Sounds.pak",0,"zip_noCommon.lst","" );
	PackFolder( TargetMasterCD,"Textures",TargetMasterCD_Packs+"\\"+PaksFolder+"\\Textures.pak",1,"zip_noCommon.lst","" );
	PackFolder( TargetMasterCD,"Music",TargetMasterCD_Packs+"\\"+PaksFolder+"\\Music.pak",0,"zip_noCommon.lst","" );
	PackFolder( TargetMasterCD,"Scripts",TargetMasterCD_Packs+"\\"+PaksFolder+"\\Scripts.pak",1,"zip_noCommon.lst","" );
	PackFolder( TargetMasterCD,"Shaders",TargetMasterCD_Packs+"\\"+PaksFolder+"\\Shaders.pak",1,"zip_noCommon.lst","" );
	PackFolder( TargetMasterCD,"Languages",TargetMasterCD_Packs+"\\"+PaksFolder+"\\Localized\\English.pak",0,"zip_noLang.lst","" );
}

function GetCodeFromSourceSafe()
{
	Log("Getting Source Files from SourceSafe Database.");

	GetSourceSafeProject( SSafeCode,SSafeCodeProject,SourcesFolder,SSafeCodeLabel );
	GetSourceSafeProject( SSafeCode,SSafeCodeProjectAdditional,SourcesFolder, SSafeCodeLabel);
	// get script files
	GetSourceSafeProject( SSafeCode,SSafeProject_Scripts,TargetMasterCD+"\\Scripts", SSafeCodeLabel);
	GetSourceSafeProject( SSafeCode,SSafeProject_Shaders,TargetMasterCD+"\\Shaders", SSafeCodeLabel );
	
	//if (BuildCode && !BuildArt)
	//{
		// get shader files
		//GetSourceSafeProject( SSafeArtwork,"$/MASTERCD/SHADERS",MasterCD+"/SHADERS", "" );
	//}

	return true;	
}

function GetMasterCDFromSourceSafe()
{
	var t0 = new Date();
	///////////////////////////////////////////////////////////////////////////////
	// Get MasterCD data.
	///////////////////////////////////////////////////////////////////////////////
	Log("Get MasterCD Data from SourceSafe."+TargetMasterCD);
	try {
		var sync=new ActiveXObject("AssManX.Sync");
		sync.SetWorkingDir(TargetMasterCD);
		sync.AddProject("\\\\server2\\XISLE\\ArtworkVss\\srcsafe.ini",SSafeArtworkProject);
		//sync.AddProject("\\\\server2\\XISLE\\ArtworkVss\\srcsafe.ini","$/Tools");
		//sync.AddProject("\\\\server1\\VSS\\srcsafe.ini","$/MasterCD_Programmers");
		sync.AddFileFilter("exp");
		sync.AddFileFilter("lib");
		sync.AddFileFilter("max");
		sync.AddFileFilter("psd");
		sync.AddFileFilter("tmp");
		sync.AddFileFilter("bak");
	//	sync.AddFileFilter("cry");
		sync.DoIt();
	}
	catch(e)
	{
		Log("ERROR "+e.Description);
		ErrorExit("getting the mastercd data from the VSS DB");
		return false;
	}
	Log( "" );
	LogTime( t0 );
	
	return true;
}

function RemoveReadOnlyFlag()
{
	var curDir = WshShell.CurrentDirectory;
  // Sets current directory to source dir
	WshShell.CurrentDirectory = TargetMasterCD;
		
	// Remove read-only attribute in root of MasterCD.
	cmdline = "attrib -R *";
	Log( cmdline );
	WshShell.Run( cmdline,1,true );
	
	cmdline = "attrib -R Profiles\\* /S /D";
	Log( cmdline );
	WshShell.Run( cmdline,1,true );

	// Restore previous directory.
	WshShell.CurrentDirectory = curDir;
}

///////////////////////////////////////////////////////////////////////////////
// Main.
///////////////////////////////////////////////////////////////////////////////


// Goto batch mode.
WScript.Interactive = true;

Init();

///////////////////////////////////////////////////////////////////////////////
// Getting stuff from Source Safe.
///////////////////////////////////////////////////////////////////////////////
if (BuildCode)
{
	StartSSafeTime = new Date();
	GetCodeFromSourceSafe();
	EndSSafeTime = new Date();
	
	///////////////////////////////////////////////////////////////////////////////
	// Update resource files with new build version.
	///////////////////////////////////////////////////////////////////////////////
	UpdateBuildNumber();

	///////////////////////////////////////////////////////////////////////////////
	// Compiling.
	///////////////////////////////////////////////////////////////////////////////
	Log("Compiling FarCry Solution.");
	StartCompileTime = new Date();
	CompileProject( FarCryCppWorkspace,FarCryCppProject, BuildConfig );
	StampFarCryCRC32();
	EndCompileTime = new Date();
}

if (BuildArt)
{
	///////////////////////////////////////////////////////////////////////////////
	// Get all MasterCD assets.
	///////////////////////////////////////////////////////////////////////////////
	StartSSafeTimeMasterCD = new Date();
	GetMasterCDFromSourceSafe();
	EndSSafeTimeMasterCD = new Date();
}

if (BuildCode)
{
/*
	if (UseIncrediBuild)
	{
		Log("Waiting for compilation to finish..." );
		while (oCompileShell.Status == 0)
		{
			WScript.Sleep(100);
		}
		Result = oCompileShell.ExitCode;
		if (Result != 0)
		{
			ErrorExit( "Error compiling sources" );
		}
		EndCompileTime = new Date();
		LogTime(StartCompileTime);
	}
*/
	///////////////////////////////////////////////////////////////////////////////
	// Archive sources folder.
	///////////////////////////////////////////////////////////////////////////////
	Log("Packing and Copying Sources to target Sources folder." );
	PackFolder(SourcesFolder,"", TargetSourcesFolder+"_pack.zip",1,"zip_noCppTemp.lst","" )
}

if (BuildCode)
{
	///////////////////////////////////////////////////////////////////////////////
	// Delete unneeded files.
	///////////////////////////////////////////////////////////////////////////////
	Log("Deleting temporary files.");
	DeleteFiles( MasterCD+"\\*.exp" );
	DeleteFiles( MasterCD+"\\*.lib" );

	// Move MasterCD to its target folder.
	Log("Copy Executables to target MasterCD folder." );
	CopyFolder( MasterCD, TargetMasterCD );
}

{
	// Delete source safe junk.
	var cmdline = "cmd /c del /f /s " + TargetMasterCD + "\\*.scc";
	Log( cmdline );
	WshShell.Run( cmdline, 1, true );
}

if (BuildArt)
{
	///////////////////////////////////////////////////////////////////////////////
	// Generate Compiled CGFs.
	///////////////////////////////////////////////////////////////////////////////
	Log("Generate Compiled CGFs.");
	GenCompiledCGFs();

	///////////////////////////////////////////////////////////////////////////////
	// Perform packing operations
	///////////////////////////////////////////////////////////////////////////////
	var t0 = new Date();
	Log("Making PAK Files...");
	MakePakFiles();
	Log("PAK Files created.");
	LogTime( t0 );
}

///////////////////////////////////////////////////////////////////////////////
// Copy Created MasterCD to its final location.
///////////////////////////////////////////////////////////////////////////////

// this step is dependant of the build we are making
Log("Copy Build To Final Directory.");
StartFinalCopyTime = new Date();
if (BuildType == "Full")
{
	Log( "Pack Build to Destination Folder");
	
	RemoveReadOnlyFlag();
 
	// Restore previous directory.
	var t0 = new Date();
	// Use 7z here, pkzip25 makes corrupted file in this case.
	PackFolderNoRecursive( TargetMasterCD,"",StorageMasterCD+"_pack.zip",1,"zip_noFinal.lst","" );
	PackFolder( TargetMasterCD,"",StorageMasterCD+"_pack.zip",1,"zip_noFinal.lst","zip_inFinal.lst" );
	PackFolder( TargetMasterCD,PaksFolder,StorageMasterCD+"_data.zip",0,"","" );
	LogTime( t0 );

	if( InstallShield )
	{
		// get necessary files for Installshield
		Log("Getting Installshield Files from SourceSafe Database.");
		GetSourceSafeProject( SSafeCode, "$/MasterCD_Install", MasterCDInstall, "" );

		Log( "Run InstallShield over FarCry Folder");
		
		var RootDir = MasterCDInstall+"\\Root";
		
		// Here should copy data to install shield root folder.
		UnpackFolder( StorageMasterCD+"_pack.zip",RootDir );
		UnpackFolder( StorageMasterCD+"_data.zip",RootDir );
	
		var curDir = WshShell.CurrentDirectory;
  	// Sets current directory to source dir
		WshShell.CurrentDirectory = MasterCDInstall; 
		
		// Remove read-only attribute.
		cmdline = "attrib -R * /S /D";
		Log( cmdline );
		WshShell.Run( cmdline,1,true );
		
		DeleteFiles( "*.pdb" );

		Log("cmd /c InstallShield.bat ReleaseDVD " + InstallShieldDestinationFolder);
		WshShell.Run("cmd /c InstallShield.bat ReleaseDVD " + InstallShieldDestinationFolder, 1, true);  

		// Restore previous directory.
		WshShell.CurrentDirectory = curDir;
	}
	
}
else if (BuildType == "Code")
{
	PackFolder(MasterCD,"",StorageMasterCD+"_code_pack.zip",1,"","")
}
else if (BuildType == "Art")
{
	PackFolder(TargetMasterCD,StorageAssets+"_assets.zip",0,"","")
}

SaveBuildNumber();
EndFinalCopyTime = new Date();

EndLog();