// CgfThumb.h : Declaration of the CCgfThumb

#pragma once
#include "resource.h"       // main symbols

#include "ShObjIdl.h"
#include "ObjIdl.h"


// ICgfThumb
[
	object,
	uuid("0690BCF6-CD67-4B06-B2E5-13E050CA3060"),
	dual,	helpstring("ICgfThumb Interface"),
	pointer_default(unique)
]
__interface ICgfThumb : IDispatch
{
};



// CCgfThumb

[
	coclass,
	threading("apartment"),
	vi_progid("CgfThumbs.CgfThumb"),
	progid("CgfThumbs.CgfThumb.1"),
	version(1.0),
	uuid("4A32B61C-3FA3-4084-8C82-A5D7FF5EB698"),
	helpstring("CgfThumb Class")
]
class ATL_NO_VTABLE CCgfThumb : 
	public ICgfThumb,
	public IDispatchImpl<IExtractImage, &__uuidof(IExtractImage), &LIBID_ShellObjects, /* wMajor = */ 1, /* wMinor = */ 0>,
	public IDispatchImpl<IExtractImage2, &__uuidof(IExtractImage2), &LIBID_ShellObjects, /* wMajor = */ 1, /* wMinor = */ 0>,
	public IDispatchImpl<IPersistFile, &__uuidof(IPersistFile), &LIBID_ShellObjects, /* wMajor = */ 1, /* wMinor = */ 0>
{
	CString m_file;
	CSize m_bmpSize;
	int m_bmpColorDepth;
	HBITMAP m_hBmp;
public:
	CCgfThumb()
	{
		m_hBmp = 0;
	}

	~CCgfThumb()
	{
		if (m_hBmp)
		{
			DeleteObject(m_hBmp);
		}
	}

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease() 
	{
	}

public:

	// IExtractImage Methods
public:
	STDMETHOD(GetLocation)( LPWSTR  pszPathBuffer,  DWORD  cch,  DWORD *  pdwPriority,  const SIZE *  prgSize,  DWORD  dwRecClrDepth,  DWORD *  pdwFlags)
	{
		m_bmpSize = *prgSize;
		m_bmpColorDepth = dwRecClrDepth;

		//*pdwPriority = 10;
		//if (pdwFlags)
			//*pdwFlags |= IEIFLAG_CACHE;

		// Add your function implementation here.
		CString str = GetBitmapFileName();
		CA2W pszW( str );
		wcscpy( pszPathBuffer,pszW );

		if (pdwFlags)
		{
			if (*pdwFlags & IEIFLAG_ASYNC)
				return E_PENDING; 
			else
				return NOERROR;
		}
		return NOERROR;
	}
	CString GetBitmapFileName() const 
	{
		// Add your function implementation here.
		char path_buffer[_MAX_PATH];
		char drive[_MAX_DRIVE];
		char dir[_MAX_DIR];
		char fname[_MAX_FNAME];
		char ext[_MAX_EXT];

		CString str;
		_splitpath( m_file,drive,dir,fname,ext );
		_makepath( path_buffer,drive,dir,fname,".tmb" );
		return path_buffer;
	}
	STDMETHOD(Extract)( HBITMAP *  phBmpThumbnail)
	{
		if (m_hBmp)
			DeleteObject(m_hBmp);
		m_hBmp = (HBITMAP)LoadImage( NULL,GetBitmapFileName(),IMAGE_BITMAP,m_bmpSize.cx,m_bmpSize.cy,LR_LOADFROMFILE );
		//if (m_hBmp)
			*phBmpThumbnail = m_hBmp;
		return NOERROR; 
	}

	// IExtractImage2 Methods
public:
	STDMETHOD(GetDateStamp)( FILETIME *  pDateStamp)
	{
		 // First, open the file and get its length.

    HANDLE hFile = CreateFile ( m_file, GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL );
    if (INVALID_HANDLE_VALUE != hFile )
    {
			GetFileTime( hFile,NULL,NULL,pDateStamp );
			CloseHandle ( hFile );
    }
		return NOERROR;
	}


// IPersistFile Methods
public:
	virtual HRESULT STDMETHODCALLTYPE IsDirty( void)
	{
		return E_NOTIMPL;
	}

	virtual HRESULT STDMETHODCALLTYPE Load( 
		/* [in] */ LPCOLESTR pszFileName,
		/* [in] */ DWORD dwMode)
	{
		m_file = pszFileName;
		return S_OK;
	}

	virtual HRESULT STDMETHODCALLTYPE Save( 
		/* [unique][in] */ LPCOLESTR pszFileName,
		/* [in] */ BOOL fRemember)
	{
		return E_NOTIMPL;
	}

	virtual HRESULT STDMETHODCALLTYPE SaveCompleted( 
		/* [unique][in] */ LPCOLESTR pszFileName)
	{
		return E_NOTIMPL;
	}

	virtual HRESULT STDMETHODCALLTYPE GetCurFile( 
		/* [out] */ LPOLESTR *ppszFileName)
	{
		return E_NOTIMPL;
	}

	virtual HRESULT STDMETHODCALLTYPE GetClassID( 
            /* [out] */ CLSID *pClassID)
	{
		return E_NOTIMPL;
	}
};

