// ChartViewerView.cpp : implementation of the CChartViewerView class
//

#include "stdafx.h"
#include "ChartViewer.h"
#include <assert.h>										// assert()

#include "ChartViewerDoc.h"
#include "ChartViewerView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CChartViewerView

IMPLEMENT_DYNCREATE(CChartViewerView, CScrollView)

BEGIN_MESSAGE_MAP(CChartViewerView, CScrollView)
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
	ON_COMMAND(ID_XZOOM_IN2X, OnXZoomIn2x)
	ON_COMMAND(ID_XZOOM_OUT2X, OnXZoomOut2x)
	ON_COMMAND(ID_YZOOM_IN2X, OnYZoomIn2x)
	ON_COMMAND(ID_YZOOM_OUT2X, OnYZoomOut2x)
	ON_WM_MOUSEWHEEL()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_ERASEBKGND()
	ON_WM_HSCROLL()
END_MESSAGE_MAP()

// CChartViewerView construction/destruction

CChartViewerView::CChartViewerView()
{
	m_iSelectionIndex=-1;
}

CChartViewerView::~CChartViewerView()
{
}

BOOL CChartViewerView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CScrollView::PreCreateWindow(cs);
}

// CChartViewerView drawing

void CChartViewerView::OnDraw( CDC *pDC )
{
	assert(pDC);
	CChartViewerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// with double Buffering
/*
	CRect	r;
	GetClientRect(&r);

	Bitmap bmp(r.right,r.bottom);

	// Create a Graphics object that is associated with the image.
	Graphics* Second = Graphics::FromImage(&bmp);

	Graphics FrontBuffer(pDC->GetSafeHdc());

	GetDocument()->Draw(Second,m_DisplayInfo);

	// Draw the altered image.
	FrontBuffer.DrawImage(&bmp,r.left,r.top,r.right,r.bottom);
*/

	// without double buffering

 	Graphics FrontBuffer(pDC->GetSafeHdc());

	GetDocument()->Draw(&FrontBuffer,m_DisplayInfo);
}


// CChartViewerView printing

BOOL CChartViewerView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CChartViewerView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CChartViewerView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}


// CChartViewerView diagnostics

#ifdef _DEBUG
void CChartViewerView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CChartViewerView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CChartViewerDoc* CChartViewerView::GetDocument() const // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CChartViewerDoc)));
	return (CChartViewerDoc*)m_pDocument;
}
#endif //_DEBUG


// CChartViewerView message handlers

void CChartViewerView::OnInitialUpdate()
{ 
	CScrollView::OnInitialUpdate();

	//	m_LegendWindow.DestroyWindow();
	if(!m_LegendWindow.GetSafeHwnd())
	{
		m_LegendWindow.Create(CLegendWindow::IDD,AfxGetMainWnd());
		m_LegendWindow.SetWindowPos(0,700,20,0,0,SWP_NOSIZE|SWP_SHOWWINDOW);
	}

	SetScrollSizes(MM_TEXT,GetDocument()->GetDocSize(m_DisplayInfo));		
}	


void CChartViewerView::ChangeScrollSizes( const int iniAroundWindowX, const int iniXFactor16, const int iniYFactor16k )
{
	CRect	r;
	GetClientRect(&r);

	POINT pt=GetScrollPosition();

	DWORD dwPos=m_DisplayInfo.AbsoluteX2Position(pt.x+iniAroundWindowX);

//	char str[1024];

//	sprintf(str,"before: m_DisplayInfo.GetLeft16()=%d pt.x=%d\n",m_DisplayInfo.GetLeft16(),pt.x);
//	OutputDebugString(str);

	if(!m_DisplayInfo.SetXScale16((m_DisplayInfo.GetXScale16()*iniXFactor16)/16))
	if(!m_DisplayInfo.SetYScale16k((m_DisplayInfo.GetYScale16k()*iniYFactor16k)/(16*1024)))
		return;

	Invalidate();
//	UpdateWindow();
	SetScrollSizes(MM_TEXT,GetDocument()->GetDocSize(m_DisplayInfo));

	pt.x=m_DisplayInfo.Position2X(dwPos)-iniAroundWindowX;
	pt.y=((pt.y+r.bottom)*iniYFactor16k)/(16*1024)-r.bottom;
	ScrollToPosition(pt);
	pt=GetScrollPosition();

	m_DisplayInfo.SetLeft16(m_DisplayInfo.AbsoluteX2Position(pt.x));

//	sprintf(str,"after: m_DisplayInfo.GetLeft16()=%d pt.x=%d\n",m_DisplayInfo.GetLeft16(),pt.x);
//	OutputDebugString(str);
}

// called the document data has changed (load)	
void CChartViewerView::Reinit( void )
{
	CRect	r;
	GetClientRect(&r);

//	OnInitialUpdate();

	m_DisplayInfo.Init();
	m_LegendWindow.SetConnectionAndRefresh(this);

	int iMaxPos,iMaxValue;
	GetDocument()->GetDocDimensions(iMaxPos,iMaxValue);

	m_DisplayInfo.SetYScale16k((16*1024*r.bottom)/iMaxValue);

	m_iSelectionIndex=-1;

	SetScrollSizes(MM_TEXT,GetDocument()->GetDocSize(m_DisplayInfo));		
}



void CChartViewerView::OnXZoomIn2x()
{
	CRect	r;
	GetClientRect(&r);

	ChangeScrollSizes(r.right/2,16*2,16*1024);
}


void CChartViewerView::OnXZoomOut2x()
{
	CRect	r;
	GetClientRect(&r);

	ChangeScrollSizes(r.right/2,16/2,16*1024);
}


void CChartViewerView::OnYZoomIn2x()
{
	CRect	r;
	GetClientRect(&r);

	ChangeScrollSizes(r.right/2,16,16*1024*2);
}


void CChartViewerView::OnYZoomOut2x()
{
	CRect	r;
	GetClientRect(&r);

	ChangeScrollSizes(r.right/2,16,16*1024/2);
}


BOOL CChartViewerView::OnMouseWheel( UINT nFlags, short zDelta, CPoint pt )
{
	ScreenToClient(&pt);

	int iInOut=zDelta/WHEEL_DELTA;

	if(iInOut>0)ChangeScrollSizes(pt.x,16*(1<<iInOut),16*1024);
		else ChangeScrollSizes(pt.x,16/(1<<(-iInOut)),16*1024);

	return(TRUE);		// TRUE, otherwise the standard wheelmouse handler is called
}


void CChartViewerView::OnLButtonDown(UINT nFlags, CPoint point)
{
//	ScreenToClient(&point);
	CPoint scroll=GetDeviceScrollPosition();

	CChartViewerDoc *doc=GetDocument();											assert(doc);
	CChartData *data=doc->GetDocumentDataPtr();							assert(data);

	if(!data->GetLayerNo(0))		// there is no layer
		return;

	// get from any layer
	DWORD dwNewIndex=   data->GetLayerNo(0)->GetIndexFromPosition( m_DisplayInfo.AbsoluteX2Position(point.x+scroll.x) );

	if(m_iSelectionIndex==(int)dwNewIndex)m_iSelectionIndex=-1;		// deselect
		else m_iSelectionIndex=(int)dwNewIndex;											// select new pos

	m_LegendWindow.SetConnectionAndRefresh(this);
	Invalidate();
	UpdateWindow();

	//	CScrollView::OnLButtonDown(nFlags, point);
}


void CChartViewerView::OnLButtonUp(UINT nFlags, CPoint point)
{
	CScrollView::OnLButtonUp(nFlags, point);
}



void CChartViewerView::OnRButtonDown(UINT nFlags, CPoint point)
{
	m_RelMouse.OnButtonDown(GetSafeHwnd());	

	CScrollView::OnRButtonDown(nFlags, point);
}

int CChartViewerView::GetCursorIndex()
{
	return m_iSelectionIndex;
}


void CChartViewerView::OnRButtonUp(UINT nFlags, CPoint point)
{
	m_RelMouse.OnButtonUp();	

	CScrollView::OnRButtonUp(nFlags, point);
}

void CChartViewerView::OnMouseMove(UINT nFlags, CPoint point)
{
	int relX,relY;
	bool bButtonDown=(nFlags&MK_RBUTTON)!=0;

	m_RelMouse.OnMouseMove(GetSafeHwnd(),bButtonDown,relX,relY);	
		if(bButtonDown)RelativeMouseMovement(nFlags,relX,relY);

	CScrollView::OnMouseMove(nFlags, point);
}


void CChartViewerView::RelativeMouseMovement( DWORD iniFlags, const int iniX, const int iniY )
{
	POINT pt=GetScrollPosition();

	pt.x-=iniX;

	ScrollToPosition(pt);

	CPoint ptDev=GetDeviceScrollPosition();

	m_DisplayInfo.SetLeft16(m_DisplayInfo.AbsoluteX2Position(ptDev.x));
}


BOOL CChartViewerView::OnEraseBkgnd(CDC* pDC)
{
//	return(false);
	return CScrollView::OnEraseBkgnd(pDC);
}




void CChartViewerView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	CScrollView::OnHScroll(nSBCode, nPos, pScrollBar);

	CPoint ptDev=GetDeviceScrollPosition();

	m_DisplayInfo.SetLeft16(m_DisplayInfo.AbsoluteX2Position(ptDev.x));
}


