// ChartViewerView.h : interface of the CChartViewerView class
//


#pragma once

#include "ChartData.h"							// CChartData
#include "RelativeMouseInput.h"			// CRelativeMouseInput
#include "LegendWindow.h"						// CLegendWindow



class CChartViewerView : public CScrollView
{
protected: // create from serialization only
	CChartViewerView();
	DECLARE_DYNCREATE(CChartViewerView)

// Attributes
public:
	CChartViewerDoc* GetDocument() const;

	//! \retunr -1 if cursor is deactivated
	int GetCursorIndex();

// Operations
public:

// Overrides
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);

// Implementation ---------------------------------------------------------------------

public:
	//! destructor
	virtual ~CChartViewerView();

	// called the document data has changed (load)	
	void Reinit( void );

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	int																		m_iSelectionIndex;			//!< -1 means cursor is deactivated
	
protected:

	CChartData::CChartDisplayInfo					m_DisplayInfo;					//!< 
	CRelativeMouseInput										m_RelMouse;							//!< for relative mouse movement
	CLegendWindow													m_LegendWindow;					//!< modeless dialog

		void RelativeMouseMovement( DWORD indwFlags, const int iniX, const int iniY );
	
	void ChangeScrollSizes( const int iniAroundWindowX, const int iniXFactor16, const int iniYFactor16k );

// Generated message map functions
protected:
	DECLARE_MESSAGE_MAP()
public:
	virtual void OnInitialUpdate();
	afx_msg void OnXZoomIn2x();
	afx_msg void OnXZoomOut2x();
	afx_msg void OnYZoomIn2x();
	afx_msg void OnYZoomOut2x();
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);

	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
};

#ifndef _DEBUG  // debug version in ChartViewerView.cpp
inline CChartViewerDoc* CChartViewerView::GetDocument() const
   { return reinterpret_cast<CChartViewerDoc*>(m_pDocument); }
#endif

