//////////////////////////////////////////////////////////////////////
//
//	Crytek Common Source code
//	
//	File:CryEngineDecalInfo.h
//	Description: declaration of struct CryEngineDecalInfo.
//
//	History:
//	-Sep 23, 2002: Created by Sergiy Migdalskiy
//
//	Notes:
//    3D Engine and Character Animation subsystems (as well as perhaps
//    some others) transfer data about the decals that need to be spawned
//    via this structure. This is to avoid passing many parameters through
//    each function call, and to save on copying these parameters when just
//    simply passing the structure from one function to another.
//
//////////////////////////////////////////////////////////////////////

#ifndef _CRY_ENGINE_DECAL_INFO_HDR_
#define _CRY_ENGINE_DECAL_INFO_HDR_

//! Structure containing common parameters that describe a decal
struct CryEngineDecalInfo
{
	struct IEntityRender * pDecalOwner; // owner (decal will be rendered on this entity)
	Vec3_tpl<float> vPos;						// decal position, in world coordinates
	Vec3_tpl<float> vNormal;				// decal/face normal
	float fSize;					// decal size
	float fLifeTime;			// decal life time (in seconds?)
	INT_PTR	nTid;					// Texture Id		//AMD Port
	float fAngle;					// angle of rotation
	INT_PTR	nPartID;				// the entity part id, that determines the bone id in case of a character, on which the hit was made	//AMD Port
	struct IStatObj * pStatObj; // decal geometry
	Vec3_tpl<float> vHitDirection;	// direction from weapon/player position to decal position (bullet direction)
	float m_fGrowTime;		// for blood pools
	bool bAdjustPos; // place decal on some visible surface

	// the constructor fills in some non-obligatory fields; the other fields must be filled in by the client
	CryEngineDecalInfo ()
	{
		memset(this,0,sizeof(*this));
		nPartID = -1;
		bAdjustPos = true;
	}
};


#endif