//////////////////////////////////////////////////////////////////////
//
//  CryEngine Source code
//	
//	File:IBindable.h
//  Interface for IBindable class, which must be implemented by all
//  objects that can be bound to a character bone
//
//	History:
//	April 07, 2003: Created by Sergiy Migdalskiy
//
//////////////////////////////////////////////////////////////////////

#ifndef _CRY_COMMON_BINDABLE_INTERFACE_HDR_
#define _CRY_COMMON_BINDABLE_INTERFACE_HDR_

struct IBindable
{
	//! Return dynamic bbox of object
	virtual void GetBBox(Vec3& Mins, Vec3& Maxs)=0;
	//! Returns position of specified helper ( exported into cgf file )
	virtual Vec3 GetHelperPos(const char * szHelperName) = 0;
	//! Returns the matrix of the specified helper ( exported into cgf file )
	virtual const Matrix44 * GetHelperMatrixByName(const char * szHelperName) = 0;

	// renders the shadow volumes of this whole object (together with attachments if any)
	// the implementation may or may not implement the limit lod functionality: if it does,
	// it will render the specified or lower LOD
	virtual void RenderShadowVolumes(const struct SRendParams *pParams, int nLimitLod = -1)=0;

	//! Sets shader template for rendering
	virtual bool SetShaderTemplate(int nTemplate, const char *TemplName, const char *ShaderName, bool bOnlyRegister=false, int * pnNewTemplateId=NULL)=0;

	// flags for the flags param of SetShaderTemplateName
	enum {FLAGS_SET_SHADER_RECURSIVE = 1};

	//! Set shader template to be used with character
	virtual bool SetShaderTemplateName(const char *TemplName, int Id, const char *ShaderName=0,struct IMatInfo *pCustomMaterial=0,unsigned nFlags = 0)
	{
		// [Sergiy] please ask Tiago about details: this function maps to SetShaderTemplate because some of the derived classes (IStatObj)
		// don't implement it, but do implement SetShaderTemplate. The mapping is exactly like in ScriptObjectEntity::SetShader function
		return SetShaderTemplate(-1,TemplName,NULL);
	}

	//there must be only one function
	//! Render object ( register render elements into renderer )
	virtual void Render(const struct SRendParams & rParams, int nLodLevel=0)=0;

	//! Start the specified animation with the given parameters, if the bindable is an animatable object
	virtual bool StartAnimation (const char* szAnimName, const struct CryCharAnimationParams& params){return false;}

	//! Start the specified by parameters morph target, if the bindable is a morphable object
	virtual void StartMorph (const char* szMorphTarget, const struct CryCharMorphParams& params) {}

	//! Resets all animation layers ( stops all animations )
	virtual void ResetAnimations() {}

	//! Stops all morphs
	virtual void StopAllMorphs() {}

	//! freezes all currently playing morphs at the point they're at
	virtual void FreezeAllMorphs(){}

	//! Processes skining (call this function every frame to animate character)
	//! dwFlags	is a bitwise OR of one of the flags specified in the UpdateEnum enumeration
	virtual void Update (Vec3 vPos = Vec3(0,0,0), float fRadius=0, unsigned uFlags = 0) {}

	//! start preloading of object resources
	virtual void PreloadResources(float fDist, float fTime, int dwFlags) = 0;


	// returns the pointer to this static object, if it's static object
	virtual struct IStatObj* GetIStatObj() {return NULL;}

	// returns the pointer to this character instance, if it's a character instance
	virtual struct ICryCharInstance* GetICryCharInstance() {return NULL;}
};

#endif