#ifndef _IPATHCONTROL_H_
#define _IPATHCONTROL_H_

#define IPATH_LINEAR	1
#define IPATH_QBEZIER	2
#define IPATH_CBEZIER 3
#define IPATH_TCB			4

struct ITagPoint;

typedef struct IPathControl
{
	virtual ITagPoint *GetTagPoint(unsigned int order) = 0;
	virtual void AddTagPoint(ITagPoint *pPoint, int order = -1) = 0;
	virtual void RemoveTagPoint(ITagPoint *pPoint) = 0;

	virtual bool SetName(const char *name) = 0;
	virtual char *GetName() = 0;

	virtual void Release() = 0;
	
	virtual bool SetInterpolation(int) = 0;		// sets what interpolation is to be used for path calculation
	virtual void SetSpeedScale(float) = 0;		// speed of animation (between 0 and 1)
} IPathControl;


#endif// _IPATHCONTROL_H_

