//////////////////////////////////////////////////////////////////////
//
//  CryEngine Source code
//	
//	File:IStatObj.h
//  Interface for CStatObj class
//
//	History:
//	-:Created by Vladimir Kajalin
//
//////////////////////////////////////////////////////////////////////

#ifndef _IStatObj_H_
#define _IStatObj_H_

// forward declarations
//////////////////////////////////////////////////////////////////////
class			CIndexedMesh;
struct		CLeafBuffer;
template	<class T> class list2;
struct		ShadowMapLightSourceInstance;
struct		ShadowMapLightSource;
class			CCObject;
struct		ItShadowVolume;
struct		IShader;
class			CDLight;
class     CIndoorArea;

//! Interface to non animated object
struct phys_geometry;

#include "IBindable.h"

//! IStatObj interface
struct IStatObj: public IBindable
{
  //! Access to source geometry for indoor engine ( lists of texcoord, normals, positions, faces )
  virtual CIndexedMesh * GetTriData()=0;
  //! Access to rendering geometry for indoor engine ( optimized vert arrays, lists of shader pointers )
  virtual CLeafBuffer * GetLeafBuffer()=0;
	//! Assign leaf buffer to static object.
	virtual void SetLeafBuffer( CLeafBuffer *buf ) = 0;
	//! Prepare leaf buffer for lightmaps, return true if success
  virtual bool EnableLightamapSupport() = 0;
  //! Access to physic representation of object	( nType: 0 - return phys geometry, 1 - return obstruct geometry )
  virtual phys_geometry * GetPhysGeom(int nType = 0)=0;
  //! Returns script material name
  virtual const char * GetScriptMaterialName(int Id=-1)=0;

  //! Returns object min bounding box component
  virtual Vec3 GetBoxMin()=0;
  //! Returns object max bounding box component
  virtual Vec3 GetBoxMax()=0;
	
  //! Set min object bounding box component
  virtual void	SetBBoxMin(const Vec3 &vBBoxMin)=0;
  //! Set max object bounding box component
  virtual void	SetBBoxMax(const Vec3 &vBBoxMax)=0;

  //! Returns object radius
  virtual float GetRadius()=0;

  //! Sets shader template for rendering
//  virtual bool SetShaderTemplate(int nTemplate, const char *TemplName, const char *ShaderName, bool bOnlyRegister=false)=0;

  //! Sets shader float parameter
  virtual void SetShaderFloat(const char *Name, float Val)=0;

  //! Sets color parameter
  virtual void SetColor(const char *Name, float fR, float fG, float fB, float fA)=0;

  //! Refresh object ( reload shaders or/and object geometry )
  virtual void Refresh(int nFlags)=0;

  //! Render object ( register render elements into renderer )
  virtual void Render(const struct SRendParams & rParams, int nLodLevel=0)=0;

	//! return lod object if present, return this if nLodLevel is 0
	virtual IStatObj * GetLodObject(int nLodLevel)=0;

	// renders the shadow volumes of this whole object (together with attachments if any)
	// the implementation may or may not implement the limit lod functionality: if it does,
	// it will render the specified or lower LOD
	virtual void RenderShadowVolumes(const struct SRendParams *pParams, int nLimitLod = -1)=0;
  
	//! Get object's light sources by id ( returns 0 if id is out of range )
	virtual const CDLight * GetLightSources(int nId) = 0;

	//! Returns folder name
	virtual const char *GetFolderName()=0;

	//! Returns filename
	virtual	const char *GetFileName()=0;		

	//! Returns geoname
	virtual	const char *GetGeoName()=0;		

	//! Is Same Object
	virtual bool IsSameObject(const char * szFileName, const char * szGeomName)=0;

  //! Returns position of specified helper ( exported into cgf file )
  virtual Vec3 GetHelperPos(const char * szHelperName)=0;

  //! Returns name, position and rotation for specified helper id, returns false if id is out of range
  virtual const char *GetHelperById(int nId, Vec3 & vPos, Matrix44 * pMat = NULL, int * pnType = NULL)=0;

  //! Returns the matrix of the specified helper ( exported into cgf file )
  virtual const Matrix44 * GetHelperMatrixByName(const char * szHelperName) = 0;

  //! Increase ref counter if pointer was copied
  virtual void RegisterUser() = 0;
  //! Reduce ref conter and delete object if nobody use it
  virtual void UnregisterUser() = 0;

	//! Tell us if the object is not found 
	virtual bool IsDefaultObject()=0;

  //! Generates picture of this object for preview
  virtual bool MakeObjectPicture(UCHAR * pRGBAData, int nWidth) = 0;
  
	//! get shadow volume object
	virtual ItShadowVolume *GetShadowVolume()=0;

	//! set shadow volume object
	virtual void SetShadowVolume(ItShadowVolume *pSvObj)=0;

  //! returns occlusion volume in object space
  virtual bool GetOcclusionVolume(list2<Vec3> * & plstOcclVolVerts, list2<int> * & plstOcclVolInds) = 0;

	//! free source geometry (data loaded from CGF file)
	virtual void FreeTriData() = 0;
	//	virtual void SetBending(float fBending) = 0;

	// Pushes the underlying tree of objects into the given Sizer object for statistics gathering
	virtual void GetMemoryUsage(class ICrySizer* pSizer) {} // TODO: implement

  //! returns true if all shaders used in this object can be used for vegetations
  virtual bool CheckValidVegetation() = 0;

  //! used for sprites
  virtual float & GetRadiusVert() = 0;

  //! used for sprites
  virtual float & GetRadiusHors() = 0;

	//! return true if loaded object has physics
	virtual bool IsPhysicsExist() = 0;

	//! will start preloading of textures, shaders and sprites
	virtual void PreloadResources(float fDist, float fTime, int dwFlags) = 0;

	// returns the pointer to this static object, if it's static object
	virtual struct IStatObj* GetIStatObj() {return this;}
};

#endif // _IStatObj_H_
