#ifndef __LM_COMP_STRUCTURES_H__
#define __LM_COMP_STRUCTURES_H__

#pragma once 

#include "IRenderer.h"
#define USE_DOT3_ALPHA 

#ifdef USE_DOT3_ALPHA 
	#define APPLY_COLOUR_FIX
#endif

#ifdef USE_DOT3_ALPHA
//	#define USE_ALPHA_FOR_LOWSPEC
#endif

//lightmap generation modes
typedef enum ELMMode
{
	ELMMode_ALL = 0,
	ELMMode_CHANGES,
	ELMMode_SEL
}ELMMode;

namespace NSAVE_RESULT
{
	static const unsigned int ESUCCESS = 0;
	static const unsigned int EPAK_FILE_UPDATE_FAIL = 1;
	static const unsigned int EDXT_COMPRESS_FAIL = 2;
	static const unsigned int EPAK_FILE_OPEN_FAIL = 3;
};

//! \brief Contains a Color + lerp factor / Dominant direction texture pair
struct RenderLMData: public _reference_target_t
{
	//! \brief Requires renderer for texture resource release
	RenderLMData(struct IRenderer *pIRenderer, int iColorLerpTex, int iDomDirectionTex)
	{
		m_pIRenderer = pIRenderer;
		m_iColorLerpTex = iColorLerpTex;
		m_iDomDirectionTex = iDomDirectionTex;
	};

	//! \brief Obtain textures
	int GetColorLerpTex() { return m_iColorLerpTex; };
	int GetDomDirectionTex() { return m_iDomDirectionTex; };

protected:
	//! \brief Destrucktor protected, call Release()
	~RenderLMData() 
	{ 
		m_pIRenderer->RemoveTexture(m_iColorLerpTex);
		m_pIRenderer->RemoveTexture(m_iDomDirectionTex);
	};

	struct IRenderer *m_pIRenderer; //!< Needed to correctly release texture resources
	int m_iColorLerpTex;            //!< Color + lerp factor texture
	int m_iDomDirectionTex;         //!< Dominant direction texture
};

TYPEDEF_AUTOPTR(RenderLMData);

struct LMGenParam
{
	//! \brief Initializes fields with useable defaults
	LMGenParam()
	{
		m_iTextureResolution = 256;
		m_fTexelSize = 0.25f;
		m_bDebugBorders = false;
		m_iSubSampling = 9;
		m_iMinBlockSize = 4;
		m_uiSmoothingAngle = 45;
		m_bComputeShadows = true;
		m_bUseSunLight = false;
		m_bDontMergePolys = false;
		m_bSpotAsPointlight = true;
		m_bOnlyExportLights = false;
	};
 
	UINT m_iTextureResolution;		//!< Resolution of the produced textures
	float m_fTexelSize;				//!< World space size of one texel
	bool m_bDebugBorders;			//!< Add colored borders to the generated lightmaps
	UINT m_iSubSampling;			//!< Amount of sub-sampling used for shadows etc.
	UINT m_iMinBlockSize;			//!< Smallest possible block assigned on a lightmap
	UINT m_uiSmoothingAngle;		//!< smoothing angle where edge sharing triangles be treated as smooth even when the normal is not smoothed and normal generation gets smoothed to
	bool m_bComputeShadows;			//!< Set to true to enable shadow casting
	bool m_bUseSunLight;			//!< Specifies if lighting coming from the sun should be taken into account
	bool m_bDontMergePolys;			//!<
	bool m_bSpotAsPointlight;		//!< overrides spotlight to be used as omnilight source
	bool m_bOnlyExportLights;		//!< Export only static lights sources, does not recompile lightmaps.
};

struct TexCoord2Comp
{
	TexCoord2Comp(float _s, float _t) { s = _s; t = _t; };
	TexCoord2Comp() : s(0.f), t(0.f){};
	float s;
	float t;
};

//! \brief Callback interface for compiler output
struct ICompilerProgress
{
	virtual void Output(const char *pszText) = 0;
};

struct LMStatLightFileHeader
{
	LMStatLightFileHeader()
	{
		iVersion = 0;
		iSizeOfDLight = sizeof(CDLight);
		iNumDLights = 0;  
	};

	unsigned __int8 iVersion;
	UINT iSizeOfDLight;
	UINT iNumDLights;
};

typedef struct SSharedLMEditorData
{
	HWND			hwnd;				//!< window handle to set the progress 	
	bool			bCancelled;			//!< if cancel has been pressed, change that to true
	unsigned char	ucProgress;			//!< progress in percent (corresponds to processed GLMs) 
	unsigned int	uiProgressMessage;	//!< message to send to progress bar
	unsigned int	uiMemUsageMessage;	//!< message to send to memory usage bar
	unsigned int	uiMemUsageStatic;	//!< message to send to text for memory usage bar static element
	unsigned int	uiGLMNameEdit;		//!< message to send to display the current glm name

	SSharedLMEditorData() : ucProgress(0), uiMemUsageMessage(0), bCancelled(false), hwnd(0), uiMemUsageStatic(0), uiGLMNameEdit(0)
	{}
}SSharedLMEditorData;

//! \brief Name of the lightmap data file in the level's directory
#define LM_EXPORT_FILE_NAME "Dot3LM.dat"

//! \brief
#define LM_STAT_LIGHTS_EXPORT_FILE_NAME "StatLights.dat"

#endif // __LM_COMP_STRUCTURES_H__