#ifndef EXCEPT_H
#define EXCEPT_H

#ifndef XEDITOR

#ifdef DO_GUARD

		// EXCEPTION MACROS
 #define TRY		try {
 #define CATCH(x)	} catch (x) {
 #define CATCH_ALL	} catch (...) {
 #define END_TRY(str)	} catch (...) { ShGPF("%s", str); throw; }
 #define CATCH_END	}
 #define RAISE(x)	throw (x)
 #define RERAISE	throw
 #define THROW0()	throw ()
 #define THROW1(x)	throw (x)
 #define THROW(x, y)	throw x(y)

#else

 #define TRY
 #define CATCH(x)
 #define CATCH_ALL
 #define END_TRY(str)
 #define CATCH_END
 #define RAISE(x)
 #define RERAISE
 #define THROW0()
 #define THROW1(x)
 #define THROW(x, y)

#endif

#endif

/*-----------------------------------------------------------------------------
	Guard macros for call stack display.
-----------------------------------------------------------------------------*/
//#include <stdio.h>
#if (!defined(GAMECUBE) && !defined (PS2))
#include <excpt.h>
#endif


//
// guard/unguardf/unguard macros.
// For showing calling stack when errors occur in major functions.
// Meant to be enabled in release builds.
//
#if !DO_GUARD
	#define guard(func)			{static const char __FUNC_NAME__[]=#func;
	#define unguard				}
	#define unguardf(msg)		}

	#define guardnw(func)			{static const char __FUNC_NAME__[]=#func;
	#define unguardnw				}
	#define unguardnwf(msg)		}

	#define guardln(func)			{static int __ERR_LINE_NUM__ = 0; static const char __FUNC_NAME__[]=#func;
  #define lnguard         {__ERR_LINE_NUM__ = __LINE__;}
	#define unguardln				}
	#define unguardlnf(msg)		}
#else
//	#define guard(func)			{static const char __FUNC_NAME__[]=#func; __try{
//	#define unguard				} __except(sExcept(GetExceptionInformation()), 1){ShGPF("%s",__FUNC_NAME__); throw;}}
//	#define unguardf(msg)		} __except(sExcept(GetExceptionInformation()), 1){ShGPF("%s",__FUNC_NAME__); ShGPF msg; throw;}}

	#define guard(func)			{static const char __FUNC_NAME__[]=#func; try{
	#define unguard				}catch(char*Err){throw Err;}catch(...){ShGPF("%s",__FUNC_NAME__); throw;}}
	#define unguardf(msg)		}catch(char*Err){throw Err;}catch(...){ShGPF("%s",__FUNC_NAME__); ShGPF msg; throw;}}

	#define guardnw(func)			{static const char __FUNC_NAME__[]=#func; try{
	#define unguardnw				}catch(char*Err){throw Err;}catch(...){ShGPF("%s",__FUNC_NAME__); throw;}}
	#define unguardnwf(msg)		}catch(char*Err){throw Err;}catch(...){ShGPF("%s",__FUNC_NAME__); ShGPF msg; throw;}}

	#define guardln(func)			{static int __ERR_LINE_NUM__ = 0; static const char __FUNC_NAME__[]=#func; try{
  #define lnguard         {__ERR_LINE_NUM__ = __LINE__;}
	#define unguardln				}catch(char*Err){throw Err;}catch(...){ShGPF("%s at line %i",__FUNC_NAME__,__ERR_LINE_NUM__); throw;}}
	#define unguardlnf(msg)		}catch(char*Err){throw Err;}catch(...){ShGPF("%s at line %i",__FUNC_NAME__,__ERR_LINE_NUM__); ShGPF msg; throw;}}
#endif

//
// guardSlow/unguardfSlow/unguardSlow macros.
// For showing calling stack when errors occur in performance-critical functions.
// Meant to be disabled in release builds.
//
#if defined(_DEBUG) || !DO_GUARD || !DO_GUARD_SLOW
	#define guardSlow(func)		{
	#define unguardfSlow(msg)	}
	#define unguardSlow			}
	#define unguardfSlow(msg)	}
#else
	#define guardSlow(func)		guard(func)
	#define unguardSlow			unguard
	#define unguardfSlow(msg)	unguardf(msg)
#endif

//
// For throwing string-exceptions which safely propagate through guard/unguard.
//

/*-----------------------------------------------------------------------------
	Check macros for assertions.
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
	Timing macros.
-----------------------------------------------------------------------------*/

#define check(expr)  {ASSERT (expr);}

// Cutting Edge assert which made an exception also in Release mode...
#ifdef WIN64
#define FIXME_ASSERT(cond) { if(!(cond)) abort(); }
#else
#define FIXME_ASSERT(cond) { if(!(cond)) { _asm { int 3 } } }
#endif

#ifdef _DEBUG

#include "platform.h"

#ifdef WIN32
#include <stdarg.h>
#endif

/*
#define ASSERT(x)																									\
{																													\
    if (!(x)) {																										\
	static char sAssertionMessage[1024];																				\
	\
	sprintf(sAssertionMessage, "Assertion Failed!!\n\nFile: \"%s\"\n\nLine: %d\n", __FILE__, __LINE__);	\
	::MessageBox(NULL, sAssertionMessage, "Assertion Failed", MB_OK | MB_ICONERROR);						\
	_asm { int 3 }																								\
    }																												\
}   */

//@FIXME this function should not be inline.
_inline void __cdecl __CRYTEKDLL_TRACE(const char *sFormat, ... )
{
	va_list vl;
	static char sTraceString[1024];
	
	va_start(vl, sFormat);
	vsprintf(sTraceString, sFormat, vl);
	va_end(vl);

	strcat(sTraceString, "\n");

	#ifdef WIN32
	::OutputDebugString(sTraceString);	
	#endif

	#ifdef GAMECUBE
	OSReport(sTraceString);
	#endif

}

#define TRACE __CRYTEKDLL_TRACE

#ifdef ASSERT
#undef ASSERT
#endif

#define ASSERT(x)	{ if (!(x)) { TRACE("Assertion Failed (%s) File: \"%s\" Line: %d\n", #x, __FILE__, __LINE__); assert(0); } }


#else

#define ASSERT(x)
#define TRACE(str) ;

#endif

#endif
