#ifndef primitives_h
#define primitives_h

namespace primitives {

////////////////////////// primitives //////////////////////

	struct primitive {
	};

	struct box : primitive {
		enum entype { type=0 };
		matrix3x3f Basis;
		int bOriented;
		vectorf center;
		vectorf size;
	};

	struct triangle : primitive {
		enum entype { type=1 };
		vectorf pt[3];
		vectorf n;
	};

	struct indexed_triangle : triangle {
		int idx;
	};

	struct grid : primitive {
		matrix3x3f Basis;
		int bOriented;
		vectorf origin;
		vector2df step,stepr;
		vector2di size;
		vector2di stride;

		int inrange(int ix, int iy) {	return isneg(ix-size.x) & isnonneg(ix) & isneg(iy-size.y) & isnonneg(iy); }
		int getcell_safe(int ix,int iy) { int mask=-inrange(ix,iy); return iy*stride.y+ix*stride.x&mask | size.x*size.y&~mask; }
	};

	struct heightfield : grid {
		enum entype { type=2 };
		heightfield& operator=(const heightfield &src) {
			step = src.step; stepr = src.stepr;
			size = src.size; stride = src.stride;
			pdata = src.pdata; heightscale = src.heightscale;
			pflags = src.pflags; typemask = src.typemask;
			typehole = src.typehole; typepower = src.typepower;
			return *this;
		}

		float getheight(int ix,int iy) const { return getheight(ix*stride.x+iy*stride.y); }
		int gettype(int ix,int iy) const { return gettype(ix*stride.x+iy*stride.y); }
		float getheight(int icell) const { return pdata[icell]*heightscale; }
		int gettype(int icell) const { 
			int itype=pflags[icell]>>typepower & typemask, idelta=itype-typehole;
			return itype | ((idelta-1)>>31 ^ idelta>>31);
		}

		unsigned short *pdata;
		float heightscale;
		unsigned short *pflags;
		unsigned short typemask;
		int typehole;
		int typepower;
	};

	struct ray : primitive {
		enum entype { type=3 };
		vectorf origin;
		vectorf dir;
	};

	struct sphere : primitive {
		enum entype { type=4 };
		vectorf center;
		float r;
	};

	struct cylinder : primitive {
		enum entype { type=5 };
		vectorf center;
		vectorf axis;
		float r,hh;
	};

	struct plane : primitive {
		enum entype { type=6 };
		vectorf n;
		vectorf origin;
	};

	struct coord_plane : plane {
		vectorf axes[2];
	};
}

struct prim_inters {
	prim_inters() { minPtDist2=0.0f; }
	vectorf pt[2];
	vectorf n;
	unsigned char iFeature[2][2];
	float minPtDist2;
	short id[2];
	int iNode[2];
	vectorf *ptborder;
	int nborderpt,nbordersz;
	vectorf ptbest;
	int nBestPtVal;
};

struct contact {
	real t,taux;
	vectorf pt;
	vectorf n;
	unsigned int iFeature[2];
};

const int NPRIMS = 8;

#ifdef PHYSICS_EXPORTS
using namespace primitives;
extern indexed_triangle g_IdxTriBuf[256];
extern int g_IdxTriBufPos;
extern cylinder g_CylBuf[2];
extern int g_CylBufPos;
extern sphere g_SphBuf[2];
extern int g_SphBufPos;
extern box g_BoxBuf[2];
extern int g_BoxBufPos;
#endif

///////////////////// geometry contact structures ///////////////////

struct geom_contact_area {
	enum entype { polygon,polyline };
	int type;
	int npt;
	int nmaxpt;
	float minedge;
	int *piPrim[2];
	int *piFeature[2];
	vectorf *pt;
	vectorf n1; // normal of other object surface (or edge)
};

struct geom_contact {
	real t;
	vectorf pt;
	vectorf n;
	vectorf dir; // unprojection direction
	int iUnprojMode;
	float vel; // original velocity along this direction, <0 if least squares normal was used
	int id[2]; // external ids for colliding geometry parts
	int iPrim[2];
	int iFeature[2];
	int iNode[2]; // BV-tree nodes of contacting primitives
	vectorf *ptborder; // intersection border
	int nborderpt;
	vectorf center;
	bool bBorderConsecutive;
	geom_contact_area *parea;
};

///////////////////// utility functions //////////////////////////

#ifdef PHYSICS_EXPORTS
int ChoosePrimitiveForMesh(strided_pointer<const vectorf> pVertices,const index *pIndices,int nTris, const vector *eigen_axes,const vector &center, 
													 int flags, float tolerance, primitive *&pprim);
void ExtrudeBox(const box *pbox, const vectorf& dir,float step, box *pextbox);
#endif

template<class CellChecker> 
int DrawRayOnGrid(primitives::grid *pgrid, vectorf &origin,vectorf &dir, CellChecker &cell_checker) 
{
	int i,ishort,ilong,bStep,bPrevStep,ilastcell;
	float dshort,dlong,frac;
	quotientf tx[2],ty[2],t[2];
	vector2di istep,icell,idirsgn;

	// crop ray with grid bounds
	idirsgn.set(sgnnz(dir.x),sgnnz(dir.y));
	i = idirsgn.x;
	tx[1-i>>1].set(-origin.x*i, dir.x*i);
	tx[1+i>>1].set((pgrid->size.x*pgrid->step.x-origin.x)*i, dir.x*i);
	i = idirsgn.y;
	ty[1-i>>1].set(-origin.y*i, dir.y*i);
	ty[1+i>>1].set((pgrid->size.y*pgrid->step.y-origin.y)*i, dir.y*i);
	t[0] = max(t[0].set(0,1),max(tx[0],ty[0]));
	t[1] = min(t[1].set(1,1),min(tx[1],ty[1]));
	if (t[0]>=t[1])
		return 0;
	if (t[0]>0)
		origin += dir*t[0].val();
	if (t[0]>0 || t[1]<1)
		dir *= (t[1]-t[0]).val();

	ilong = isneg(fabs_tpl(dir.x)-fabs_tpl(dir.y));
	ishort = ilong^1;
	dshort = fabs_tpl(dir[ishort]); dlong = fabs_tpl(dir[ilong]);
	istep[ilong] = idirsgn[ilong];
	istep[ishort] = idirsgn[ishort];

	icell.set(float2int(origin.x*pgrid->stepr.x-0.5f), float2int(origin.y*pgrid->stepr.y-0.5f));
	ilastcell = float2int((origin.y+dir.y)*pgrid->stepr.y-0.5f)<<16 | float2int((origin.x+dir.x)*pgrid->stepr.x-0.5f);
	if (cell_checker.check_cell(icell,ilastcell) || (icell.y<<16|icell.x)==ilastcell)
		return 1;

	t[0].set((icell[ilong]+(istep[ilong]+1>>1))*pgrid->step[ilong]-origin[ilong], dir[ilong]);
	frac = (origin[ishort]+dir[ishort]*t[0].val() - icell[ishort]*pgrid->step[ishort])*pgrid->stepr[ishort];
	i = isneg(dir[ishort]);
	frac = i+frac*(1-(i<<1));
	if (frac>1.0f) {
		icell[ishort] += istep[ishort];
		if (cell_checker.check_cell(icell,ilastcell) || (icell.y<<16|icell.x)==ilastcell)
			return 1;
		frac -= 1;
	}
	frac *= dlong;
	icell[ilong] += istep[ilong];

	bPrevStep = 0;
	do {
		if (cell_checker.check_cell(icell,ilastcell) || (icell.y<<16|icell.x)==ilastcell)
			return 1;
		frac += dshort*(bPrevStep^1); bStep = isneg(dlong-frac);
		icell[ishort] += bStep*istep[ishort]; frac -= dlong*bStep;
		icell[ilong] += istep[ilong]&~-bStep; 
		bPrevStep = bStep;
	} while(true);

	return 0;
}

#endif