// CryFileXForm.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "ChunkFileReader.h"
#include "ChunkFileWriter.h"


typedef std::map<unsigned, std::string>ChunkTypeNameMap;
ChunkTypeNameMap g_mapChunkTypeName;

void InitChunkTypeNameMap()
{
#define ADD_CHUNK(NAME) g_mapChunkTypeName[ChunkType_##NAME] = "ChunkType_" #NAME;
	ADD_CHUNK(ANY);
	ADD_CHUNK(Mesh);
	ADD_CHUNK(Helper);
	ADD_CHUNK(VertAnim);
	ADD_CHUNK(BoneAnim);
	ADD_CHUNK(GeomNameList);
	ADD_CHUNK(BoneNameList);
	ADD_CHUNK(MtlList);
	ADD_CHUNK(MRM);
	ADD_CHUNK(SceneProps);
	ADD_CHUNK(Light);
	ADD_CHUNK(PatchMesh);
	ADD_CHUNK(Node);
	ADD_CHUNK(Mtl);
	ADD_CHUNK(Controller);
	ADD_CHUNK(Timing);
	ADD_CHUNK(BoneMesh);
	ADD_CHUNK(BoneLightBinding);
	ADD_CHUNK(MeshMorphTarget);
#undef ADD_CHUNK
}

std::string getChunkName (unsigned nChunkType)
{
	if (g_mapChunkTypeName.find (nChunkType) == g_mapChunkTypeName.end())
	{
		char szBuffer [0x50];
		sprintf (szBuffer, "Unknown(%d)", nChunkType);
		return szBuffer;
	}
	else
		return g_mapChunkTypeName[nChunkType].c_str();
}



// the action to perform on each file
typedef void (*ModeFn) (const char* szFilePath);
ModeFn g_fnMode = NULL;

void detectFile (const char* szFilePath)
{
	CChunkFileReader_AutoPtr pReader = new CChunkFileReader();
	if (!pReader->open (szFilePath))
	{
		printf ("%s - not a CryFormat file \n", szFilePath);
		return;
	};

	const FILE_HEADER& hdr = pReader->getFileHeader();
	if (hdr.FileType != FileType_Anim || hdr.Version != AnimFileVersion || memcmp (hdr.Signature,FILE_SIGNATURE,sizeof(hdr.Signature)))
	{
		printf ("%s - not an animation file\n", szFilePath);
		return;
	}

	printf ("%s\n", szFilePath);
  
	unsigned numUnalignedChunks = 0;
	for (int i = 0; i < pReader->numChunks(); ++i)
	{
		if (!(pReader->getChunkSize(i)&3))
			continue;
		numUnalignedChunks ++;
	}

	if (numUnalignedChunks)
		printf ("\t%d unaligned Chunk(s)\n", numUnalignedChunks);
}

void fixFile (const char* szFilePath)
{
	CChunkFileReader_AutoPtr pReader = new CChunkFileReader();
	if (!pReader->open (szFilePath))
	{
		printf ("%s - not a CryFormat file \n", szFilePath);
		return;
	}

	const FILE_HEADER& hdr = pReader->getFileHeader();
	if (hdr.FileType != FileType_Anim || hdr.Version != AnimFileVersion || memcmp (hdr.Signature,FILE_SIGNATURE,sizeof(hdr.Signature)))
	{
		printf ("%s - not an animation file\n", szFilePath);
		return;
	}

	printf ("%s\n", szFilePath);
  
	unsigned numUnalignedChunks = 0;
	for (int i = 0; i < pReader->numChunks(); ++i)
	{
		if (!(pReader->getChunkSize(i)&3))
			continue;
		numUnalignedChunks ++;
	}

	if (numUnalignedChunks)
		printf ("\t%d unaligned Chunk(s)\n", numUnalignedChunks);
	else
		return;

	try
	{
		CChunkFileWriter writer(szFilePath, pReader->getFileHeader().FileType, pReader->getFileHeader().Version);
		for (int nChunk = 0; nChunk < pReader->numChunks(); ++nChunk)
		{
			const CHUNK_HEADER& chunkHeader = pReader->getChunkHeader(nChunk);
			int nChunkSize = pReader->getChunkSize(nChunk);
			writer.addChunk(chunkHeader);
			writer.write (pReader->getChunkData(nChunk), nChunkSize);
			if (nChunkSize & 3)
			{
				printf ("Fixing chunk %s (was %d bytes length, padding with zeros)\n", getChunkName(chunkHeader.ChunkType).c_str(), nChunkSize);

				unsigned long nPad = 0;
				writer.write (&nPad,4-(nChunkSize&3));
			}
		}
	}
	catch (CChunkFileWriter::Error& e)
	{
		printf ("Error:Generic file write error: %s\n", e.c_str());
	}
	catch (std::ios::failure&)
	{
		printf ("Error:std::ios::failure\n");
	}
	
}

// print usage string
void usage ()
{
	printf ("USAGE: CryFileXForm (-detect|-fix) directory_path\n");
	printf ("NOTE: it will scan subdirectories\n");
	exit(0);
}

// scans and performs the required action on the files
void scan (std::string strDir)
{
	_finddata_t fd;
	intptr_t h = _findfirst ((strDir + "\\*.*").c_str(), &fd);
	if (h == -1)
	{
		printf ("%s : not a dir or cannot scan, error %d, attempting open as a file\n", strDir.c_str(), errno);
		g_fnMode (strDir.c_str());
		return;
	}

	printf ("\nScanning %s\n", strDir.c_str());

	std::vector <std::string> arrSubdirs;

	do 
	{
		if (!strcmp(fd.name, ".") || !strcmp(fd.name, ".."))
			continue;

		if (fd.attrib & _A_SUBDIR)
		{
			arrSubdirs.push_back(fd.name);
			continue;
		}

		char szDrive[4];
		char szDir[0x1000];
		char szFName[0x100];
		char szExt[0x100];
		_splitpath(fd.name, szDrive, szDir, szFName, szExt);
		if (!strcmpi(szExt,".caf"))
			g_fnMode((strDir+ "/" + fd.name).c_str());
	}
	while(_findnext (h, &fd) != -1);

	_findclose (h);

	for (unsigned i = 0; i < arrSubdirs.size(); ++i)
	{
		scan (strDir + "/" + arrSubdirs[i]);
	}
}


int _tmain(int argc, _TCHAR* argv[])
{
	InitChunkTypeNameMap();

	if (argc != 3)
		usage();

	if (!strcmpi(argv[1], "-detect"))
		g_fnMode = detectFile;
	else
	if (!strcmpi(argv[1], "-fix"))
		g_fnMode = fixFile;
	else
		usage();

	scan (argv[2]);	

	return 0;
}

