// BoneNameList.cpp: implementation of the BoneNameList class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CryViewer.h"
#include "BoneNameList.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BoneNameList::BoneNameList() : BaseObj()
{
	memset(&chunk,0,sizeof(chunk));
	names=NULL;
	nBones=0;
}

BoneNameList::~BoneNameList()
{
	if(names) free(names);
}

bool BoneNameList::Load(FILE *f, long pos)
{
	if(fseek(f,pos,SEEK_SET)) return true;

	int res=fread(&chunk,sizeof(chunk),1,f);
	if(res!=1) return true;
	
	if(chunk.chdr.ChunkType != ChunkType_BoneNameList || chunk.chdr.ChunkVersion != BONENAMELIST_CHUNK_DESC_VERSION)
	{
		memset(&chunk,0,sizeof(chunk));
		return true;
	}

	hdr=chunk.chdr;

	names=(NAME_ENTITY*)calloc(chunk.nEntities,sizeof(NAME_ENTITY));
	assert(names);

	res=fread(names,sizeof(NAME_ENTITY),chunk.nEntities,f);
	if(res!=chunk.nEntities) return true;

	nBones=chunk.nEntities;

	return false;
};

