#pragma once



// forward declarations
class CBackBuffer;
class CJukebox;
class CMenuData;



class CFarCryAutoCDApp
{
public:
	static CFarCryAutoCDApp& GetInstance();

public:
	~CFarCryAutoCDApp();	

	void InitInstance( const HINSTANCE& hInstance, int nCmdShow );
	int Run();
	
	LRESULT WndProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam );

private:
	CFarCryAutoCDApp();
	
	ATOM RegisterClass()  const;
	void PrepareTransparency();
	void SetCursorSafe( const TCHAR* pcCursorName );
	void FadeScreen();
    void HandleSysMenu();
	void RunButtonEvent();

    void ClientToScreen( int iClientX, int iClientY, int& iScreenX, int& iScreenY ) const;

	void OnPaint();	
	void OnDraw();	
	void OnKeyDown( unsigned int uiChar, unsigned int uiRepCnt, unsigned int uiFlags );
	void OnMouseMove( int iNewX, int iNewY, unsigned int uiFlags );
	void OnLButtonDown( int iNewX, int iNewY );
	void OnLButtonUp();
	void OnTimer( unsigned int uiTimerID );
	void OnClose();
	void OnSize( unsigned int uiType, unsigned short usWidth, unsigned short usHeight );
	LRESULT OnMouseActivate();

private:
	HINSTANCE m_hInstance;
	HWND m_hWnd;

	CBackBuffer* m_pkBackBuffer;
	CJukebox* m_pkJukebox;
	CMenuData* m_pkMenuData;

	unsigned char m_ucCurButtonID;
	int m_iLastDragMouseScreenX;
	int m_iLastDragMouseScreenY;

	bool m_bLeftMouseButtonPressed;
    bool m_bDragWindow;
	bool m_bScreenIsFading;
	unsigned char m_ucFadeScreenCounter;
};