#include "StdAfx.h"
#include "LocalizationTable.h"
#include "LanguageID.h"



CLocalizationTable::CLocalizationTable()
{
}



CLocalizationTable::~CLocalizationTable()
{
}



tstring 
CLocalizationTable::GetButtonText( EButtonID eButtonID )
{
	switch( GetPrimaryLanguageID() )
	{
	case 0x07:
		{
			return( GetGermanButtonText( eButtonID ) );
		}		
	case 0x09:
		{
			return( GetEnglishButtonText( eButtonID ) );
		}
	case 0x0c:
		{
			return( GetFrenchButtonText( eButtonID ) );
		}		
	case 0x0a:
		{
			return( GetSpanishButtonText( eButtonID ) );
		}		
	case 0x10:
		{
			return( GetItalianButtonText( eButtonID ) );
		}		
	case 0x11:
		{
			return( GetJapaneseButtonText( eButtonID ) );
		}		
	case 0x15:
		{
			return( GetPolishButtonText( eButtonID ) );
		}		
	default:
		{
			return( GetEnglishButtonText( eButtonID ) );
		}
	}
}



tstring 
CLocalizationTable::GetEnglishButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			return( _T( "Install" ) );
		}
	case BID_PLAY:
		{
			return( _T( "Play" ) );
		}
	case BID_UNINSTALL:
		{
			return( _T( "Uninstall" ) );
		}
	case BID_README:
		{
			return( _T( "Readme" ) );
		}
	case BID_MANUAL:
		{
			return( _T( "Manual" ) );
		}
	case BID_REGISTER:
		{
			return( _T( "Register" ) );
		}
	case BID_WEB:
		{
			return( _T( "Web" ) );
		}
	case BID_QUIT:
		{
			return( _T( "Quit" ) );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}



tstring 
CLocalizationTable::GetGermanButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			return( _T( "Installieren" ) );
		}
	case BID_PLAY:
		{
			return( _T( "Spielen" ) );
		}
	case BID_UNINSTALL:
		{
			return( _T( "Deinstallieren" ) );
		}
	case BID_README:
		{
			return( _T( "Readme anzeigen" ) );
		}
	case BID_MANUAL:
		{
			return( _T( "Handbuch" ) );
		}
	case BID_REGISTER:
		{
			return( _T( "Registrieren" ) );
		}
	case BID_WEB:
		{
			return( _T( "Web" ) );
		}
	case BID_QUIT:
		{
			return( _T( "Ende" ) );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}



tstring 
CLocalizationTable::GetFrenchButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			return( _T( "Installer" ) );
		}
	case BID_PLAY:
		{
			return( _T( "Jouer" ) );
		}
	case BID_UNINSTALL:
		{
			return( _T( "Dsinstaller" ) );
		}
	case BID_README:
		{
			return( _T( "Lisez-moi" ) );
		}
	case BID_MANUAL:
		{
			return( _T( "Manuel" ) );
		}
	case BID_REGISTER:
		{
			return( _T( "Enregistrement" ) );
		}
	case BID_WEB:
		{
			return( _T( "Web" ) );
		}
	case BID_QUIT:
		{
			return( _T( "Quitter" ) );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}



tstring 
CLocalizationTable::GetSpanishButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			return( _T( "Instalar" ) );
		}
	case BID_PLAY:
		{
			return( _T( "Jugar" ) );
		}
	case BID_UNINSTALL:
		{
			return( _T( "Desinstalar" ) );
		}
	case BID_README:
		{
			return( _T( "Leme" ) );
		}
	case BID_MANUAL:
		{
			return( _T( "Manual" ) );
		}
	case BID_REGISTER:
		{
			return( _T( "Registro" ) );
		}
	case BID_WEB:
		{
			return( _T( "Pgina web" ) );
		}
	case BID_QUIT:
		{
			return( _T( "Salir" ) );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}



tstring 
CLocalizationTable::GetItalianButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			return( _T( "Installa" ) );
		}
	case BID_PLAY:
		{
			return( _T( "Gioca" ) );
		}
	case BID_UNINSTALL:
		{
			return( _T( "Disinstalla" ) );
		}
	case BID_README:
		{
			return( _T( "Leggimi" ) );
		}
	case BID_MANUAL:
		{
			return( _T( "Manuale" ) );
		}
	case BID_REGISTER:
		{
			return( _T( "Registrati" ) );
		}
	case BID_WEB:
		{
			return( _T( "Web" ) );
		}
	case BID_QUIT:
		{
			return( _T( "Esci" ) );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}


#ifdef UNICODE
tstring 
CLocalizationTable::GetJapaneseButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			const TCHAR c_msgInstall[] = { 0x30A4, 0x30F3, 0x30B9, 0x30C8, 0x30FC, 0x30EB, 0x0000 };
			return( c_msgInstall );
		}
	case BID_PLAY:
		{
			const TCHAR c_msgPlay[] = { 0x30D7, 0x30EC, 0x30A4, 0x0000 };
			return( c_msgPlay );
		}
	case BID_UNINSTALL:
		{
			const TCHAR c_msgUninstall[] = { 0x30A2, 0x30F3, 0x30A4, 0x30F3, 0x30B9, 0x30C8, 0x30FC, 0x30EB, 0x0000 };
			return( c_msgUninstall );
		}
	case BID_README:
		{
			return( _T( "Readme" ) );
		}
	case BID_MANUAL:
		{
			const TCHAR c_msgManual[] = { 0x30DE, 0x30CB, 0x30E5, 0x30A2, 0x30EB, 0x0000 };
			return( c_msgManual );
		}
	case BID_REGISTER:
		{
			const TCHAR c_msgRegister[] = { 0x30AA, 0x30F3, 0x30E9, 0x30A4, 0x30F3, 0x767B, 0x9332, 0x0000 };
			return( c_msgRegister );
		}
	case BID_WEB:
		{
			return( _T( "Web" ) );
		}
	case BID_QUIT:
		{
			const TCHAR c_msgQuit[] = { 0x7D42, 0x4E86, 0x0000 };
			return( c_msgQuit );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}
#else
tstring 
CLocalizationTable::GetJapaneseButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			return( _T( "CXg[" ) );
		}
	case BID_PLAY:
		{
			return( _T( "vC" ) );
		}
	case BID_UNINSTALL:
		{
			return( _T( "ACXg[" ) );
		}
	case BID_README:
		{
			return( _T( "Readme" ) );
		}
	case BID_MANUAL:
		{
			return( _T( "}jA" ) );
		}
	case BID_REGISTER:
		{
			return( _T( "ICo^" ) );
		}
	case BID_WEB:
		{
			return( _T( "Web" ) );
		}
	case BID_QUIT:
		{
			return( _T( "I" ) );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}
#endif



tstring 
CLocalizationTable::GetPolishButtonText( EButtonID eButtonID )
{
	switch( eButtonID )
	{
	case BID_INSTALL:
		{
			return( _T( "Instaluj" ) );
		}
	case BID_PLAY:
		{
			return( _T( "Graj" ) );
		}
	case BID_UNINSTALL:
		{
			return( _T( "Usu" ) );
		}
	case BID_README:
		{
			return( _T( "Readme" ) );
		}
	case BID_MANUAL:
		{
			return( _T( "Instrukcja" ) );
		}
	case BID_REGISTER:
		{
			return( _T( "Zarejestruj" ) );
		}
	case BID_WEB:
		{
			return( _T( "Sie" ) );
		}
	case BID_QUIT:
		{
			return( _T( "Wyjd" ) );
		}
	default:
		{
			return( _T( "!Error!" ) );
		}
	}
}