#pragma once



#include "ButtonIDs.h"
#include <vector>



class CBackBuffer;



typedef std::vector< unsigned int > Raw32BitImage;
typedef std::vector< unsigned char > Raw8BitImage;



inline unsigned int
GetOffset( unsigned int uiX, unsigned int uiY )
{
	return( c_iWndWidth * uiY + uiX );
}



class CMenuData
{
public:
	CMenuData( const HINSTANCE& hInstance, CBackBuffer* pkBackBuffer );
	~CMenuData();

	const Raw32BitImage& GetMenuBase() const;
	const Raw32BitImage& GetMenuHighlighted() const;
	const Raw32BitImage& GetMenuSelected() const;
	const Raw8BitImage& GetMenuMask() const;

private:
	void LoadJpegFromResource( Raw32BitImage& image, unsigned int& uiWidth, unsigned int& uiHeight, const HINSTANCE& hInstance, const TCHAR* pcResourceName ) const;
	void LoadJpegFromMemory( Raw32BitImage& image, unsigned int& uiWidth, unsigned int& uiHeight, const unsigned char* pucJpegData, unsigned int uiJpegSize ) const;

	void LoadMenuBackground( Raw32BitImage& imgMenuBackground, const HINSTANCE& hInstance ) const;
	void LoadSysMenuButtons( Raw32BitImage& imgSysMenuButtons, const HINSTANCE& hInstance ) const;

	void GetMenuButtonTextRect( HDC hBackBufferDC, int iButtonIndex, const tstring& strButtonText, RECT& rect ) const;

	void CreateBaseMenu( const HINSTANCE& hInstance );
	void CreateHighlightedMenu( const HINSTANCE& hInstance );
	void CreateSelectedMenu( const HINSTANCE& hInstance );
	void CreateMenu( const HINSTANCE& hInstance, Raw32BitImage& imgMenu, unsigned int uiMenuFontColor, bool bBold );
    void CreateSysMenu( const HINSTANCE& hInstance, Raw32BitImage& imgMenu, unsigned int uiSysMenuColor );
	void CreateMenuMask();
	void CreateSysMenuMask();

private:
	CBackBuffer* m_pkBackBuffer;

	Raw32BitImage m_imgMenuBase;
	Raw32BitImage m_imgMenuHighlighted;
	Raw32BitImage m_imgMenuSelected;
	Raw8BitImage m_imgMenuMask;

	bool m_pbButtonInactive[ NUM_MENUBUTTONS ];
};



inline const Raw32BitImage& 
CMenuData::GetMenuBase() const
{
	return( m_imgMenuBase );
}



inline const Raw32BitImage& 
CMenuData::GetMenuHighlighted() const
{
	return( m_imgMenuHighlighted );
}



inline const Raw32BitImage& 
CMenuData::GetMenuSelected() const
{
	return( m_imgMenuSelected );
}



inline const Raw8BitImage& 
CMenuData::GetMenuMask() const
{
	return( m_imgMenuMask );
}