#pragma once

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers

#define _WIN32_WINNT ( 0x0500 )	// to get definitions needed for transparent windows



// enable this to check for memory leaks... see CFarCryAutoCDApp::~CFarCryAutoCDApp()
//#define CRTDBG_MAP_ALLOC
//#include <crtdbg.h>



// windows header files
#include <windows.h>
#include <shellapi.h>

// c run time header files
#include <tchar.h>
#include <assert.h>



// project wide constants
const int c_iWndWidth( 512 );
const int c_iWndHeight( 384 );


// some types for easy multi byte / unicode compilation
#include <string>
#include <exception>

typedef std::basic_string< TCHAR > tstring;

class texception : public std::exception
{
public:
	texception( const tstring& description )
	: std::exception()
	, m_description( description )
	{
	}

	const tstring& descr() const
	{
		return( m_description );
	}

private:
	tstring m_description;
};
