#include "stdafx.h"
#include "FarCryConfigurator.h"
#include "FarCryConfiguratorDlg.h"
#include "SystemConfiguration.h"
#include "Helpers.h"
#include "LanguageID.h"
#include "FarCryRegistry.h"

#include <io.h>
#include <vector>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif



using namespace std;



BEGIN_MESSAGE_MAP( CFarCryConfiguratorApp, CWinApp )
//	ON_COMMAND( ID_HELP, CWinApp::OnHelp )
END_MESSAGE_MAP()



CFarCryConfiguratorApp s_kTheApp;

CFarCryConfiguratorApp&
CFarCryConfiguratorApp::GetInstance()
{
	// Meyers singleton can't be used due to MFC restrictions -- sucks ASS!
	// static CFarCryConfiguratorApp s_kTheApp;
	return( s_kTheApp );
}



CFarCryConfiguratorApp::CFarCryConfiguratorApp()
: m_pkSysConfig( 0 )
{
}



CFarCryConfiguratorApp::~CFarCryConfiguratorApp()
{
	SafeRelease( m_pkSysConfig );
}



BOOL
CFarCryConfiguratorApp::InitInstance()
{
	if( FALSE != CWinApp::InitInstance() )
	{
		// parse command line to see if we've been called by Far Cry
		CString strCmdLine( GetCommandLine() );
		int iCmdStartPos( strCmdLine.Find( _T( ".exe" ) ) );


		bool bFarCryIsCaller( false );
		if( 0 <= iCmdStartPos && 0 <= strCmdLine.Find( _T( "/Caller=FarCry" ) ) )
		{
			bFarCryIsCaller = true;
		}

		bool bSetupIsCaller( false );
		if( 0 <= iCmdStartPos && 0 <= strCmdLine.Find( _T( "/Caller=Setup" ) ) )
		{
			bSetupIsCaller = true;
		}

		// init system configuration
		m_pkSysConfig = new CSystemConfiguration( "system.cfg" );
		if( 0 != m_pkSysConfig  )
		{
			if( false != bSetupIsCaller )
			{
				AdjustLanguage();
			}
			else
			{
				// check if launch is necessary
				if( false == bFarCryIsCaller ||
					false != bFarCryIsCaller && false != m_pkSysConfig->IsInitialConfig() )
				{
					if( false != LoadLocalizedResources() )
					{
						InitCommonControls();
						AfxEnableControlContainer();
						SetRegistryKey( _T( "Crytek" ) );

						CFarCryConfiguratorDlg dlg( *m_pkSysConfig, bFarCryIsCaller );
						if( IDOK == dlg.DoModal() )
						{
						}
					}
				}
			}
		}
	}
	return( FALSE );
}



bool
CFarCryConfiguratorApp::LoadLocalizedResources()
{

	HMODULE hResDll( 0 );
	switch( GetPrimaryLanguageID() )
	{
	case 0x07:
		{
			// german
			hResDll = LoadLibrary( _T( "FarCryConfigGer.dll" ) );
			break;
		}
	case 0x09:
		{
			// english
			hResDll = LoadLibrary( _T( "FarCryConfigEng.dll" ) );
			break;
		}
	case 0x0c:
		{
			// french
			hResDll = LoadLibrary( _T( "FarCryConfigFre.dll" ) );
			break;
		}
	case 0x0a:
		{
			// spanish
			hResDll = LoadLibrary( _T( "FarCryConfigSpa.dll" ) );
			break;
		}
	case 0x10:
		{
			// italian
			hResDll = LoadLibrary( _T( "FarCryConfigIta.dll" ) );
			break;
		}
	case 0x11:
		{
			// japanese
			hResDll = LoadLibrary( _T( "FarCryConfigJap.dll" ) );
			break;
		}
	case 0x15:
		{
			// polish
			hResDll = LoadLibrary( _T( "FarCryConfigPol.dll" ) );
			break;
		}
	case 0x19:
		{
			// russian
			hResDll = LoadLibrary( _T( "FarCryConfigRus.dll" ) );
			break;
		}
	default:
		{
			// default to english
			hResDll = LoadLibrary( _T( "FarCryConfigEng.dll" ) );
			break;
		}
	}

	if( 0 != hResDll )
	{
		AfxSetResourceHandle( hResDll );
	}
	return( 0 != hResDll );
}



void
CFarCryConfiguratorApp::AdjustLanguage()
{
	tstring strFarCryInstallationFolder;
	if( false != FarCryRegistry::GetFarCryInstallationFolder( strFarCryInstallationFolder ) )
	{
		tstring strLanguagePakSearch( strFarCryInstallationFolder + _T( "FCData\\Localized\\*.pak" ) );

		__tfinddata64_t fileInfo;
		intptr_t hFile( _tfindfirst64( (TCHAR*) strLanguagePakSearch.c_str(), &fileInfo ) );
		if( -1L != hFile )
		{
			_findclose( hFile );

			tstring strLanguagePakFileName( fileInfo.name );
			if( strLanguagePakFileName.size() > 4 )
			{
				TCHAR cuWorkingFolder[ MAX_PATH ];
				GetCurrentDirectory( MAX_PATH, cuWorkingFolder );
				SetCurrentDirectory( strFarCryInstallationFolder.c_str() );

				size_t length( strLanguagePakFileName.size() - 4 );
				vector< char > cStr( length + 1 );
#ifdef UNICODE
				wcstombs( &cStr[ 0 ], strLanguagePakFileName.c_str(), length );
#else
				memcpy( &cStr[ 0 ], strLanguagePakFileName.c_str(), length );
#endif
				cStr[ length ] = 0;
				strlwr( &cStr[ 0 ] );
				CSystemConfiguration::PatchLanguageFromSetup( &cStr[ 0 ] );

				SetCurrentDirectory( cuWorkingFolder );
			}
		}
	}
}