#include "stdafx.h"
#include "FarCryConfigurator.h"
#include "SoundOptionsPage.h"
#include "SystemConfiguration.h"
#include "SystemAnalysis.h"
#include "Helpers.h"

// include resource IDs of english version, for all other languages the IDs MUST BE THE SAME!!!
#include "..\FarCryConfigEng\resource.h"



IMPLEMENT_DYNAMIC( CSoundOptionsPage, CPropertyPage )



const int c_speakerSetup[] = { 3, 5, 2, 4, 6, 1 };



CSoundOptionsPage::CSoundOptionsPage( CSystemConfiguration& kSysConfig )
: CPropertyPage( IDD_SOUND )
, m_kSysConfig( kSysConfig )
, m_kSpeakerSetupCtrl()
, m_kDopplerEffectCtrl()
, m_kHWMixingCtrl()
, m_kEnableEAXCtrl()
, m_kCompatibilityModeCtrl()
, m_kEnableMusicCtrl()
, m_kMusicQualityCtrl()
, m_kAutoDetectMusicQualityCtrl()
{
}



CSoundOptionsPage::~CSoundOptionsPage()
{
}



void 
CSoundOptionsPage::DoDataExchange( CDataExchange* pDX )
{
	CPropertyPage::DoDataExchange( pDX );

	DDX_Control( pDX, IDC_SPEAKERSETUP, m_kSpeakerSetupCtrl );
	DDX_Control( pDX, IDC_DOPPLEREFFECT, m_kDopplerEffectCtrl );
	DDX_Control( pDX, IDC_HWMIXING, m_kHWMixingCtrl );
	DDX_Control( pDX, IDC_ENABLEEAX, m_kEnableEAXCtrl );
	DDX_Control( pDX, IDC_COMPATIBILITYMODE, m_kCompatibilityModeCtrl );
	DDX_Control( pDX, IDC_ENABLEMUSIC, m_kEnableMusicCtrl );
	DDX_Control( pDX, IDC_MUSICQUALITY, m_kMusicQualityCtrl );
	DDX_Control( pDX, IDC_AD_MUSICQUALITY, m_kAutoDetectMusicQualityCtrl );
}




BEGIN_MESSAGE_MAP( CSoundOptionsPage, CPropertyPage )
	ON_BN_CLICKED( IDC_HWMIXING, OnBnClickedHWMixing )
	ON_BN_CLICKED( IDC_ENABLEMUSIC, OnBnClickedEnableMusic )
	ON_BN_CLICKED( IDC_AD_MUSICQUALITY, OnBnClickedAutoDetectMusicQuality )
END_MESSAGE_MAP()



BOOL 
CSoundOptionsPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	// setup initial speaker setup value
	m_kSpeakerSetupCtrl.AddString( LoadString( IDS_MONO ) );
	m_kSpeakerSetupCtrl.AddString( LoadString( IDS_STEREO ) );
	m_kSpeakerSetupCtrl.AddString( LoadString( IDS_HEADPHONES ) );
	m_kSpeakerSetupCtrl.AddString( LoadString( IDS_QUADROPHONIC ) );
	m_kSpeakerSetupCtrl.AddString( LoadString( IDS_SURROUND ) );
	m_kSpeakerSetupCtrl.AddString( LoadString( IDS_DOLBY51 ) );	

	SysConfigValue s_SpeakerConfig( m_kSysConfig.GetValue( "s_SpeakerConfig" ) );
	for( int i( 0 ); i < sizeof( c_speakerSetup ) / sizeof( c_speakerSetup[ 0 ] ); ++i )
	{
		if( false != IsEqual( s_SpeakerConfig, c_speakerSetup[ i ] ) )
		{
			m_kSpeakerSetupCtrl.SetCurSel( i );
		}
	}

	// setup initial doppler effect value
	SysConfigValue s_DopplerEnable( m_kSysConfig.GetValue( "s_DopplerEnable" ) );
	m_kDopplerEffectCtrl.SetCheck( false != IsEqual( s_DopplerEnable, 0 ) ? 0 : 1 );

	// setup initial hw mixing value
	SysConfigValue s_MaxHWChannels( m_kSysConfig.GetValue( "s_MaxHWChannels" ) );
	if( false == IsEqual( s_MaxHWChannels, 0 ) )
	{
		m_kHWMixingCtrl.SetCheck( 1 );

		// setup initial enable EAX value
		SysConfigValue s_EnableSoundFX( m_kSysConfig.GetValue( "s_EnableSoundFX" ) );
		m_kEnableEAXCtrl.SetCheck( false != IsEqual( s_EnableSoundFX, 0 ) ? 0 : 1 );		
	}
	else
	{
		m_kHWMixingCtrl.SetCheck( 0 );
		m_kEnableEAXCtrl.SetCheck( 0 );
		m_kEnableEAXCtrl.EnableWindow( FALSE );
	}

	// setup initial compatibility mode value
	SysConfigValue s_CompatibleMode( m_kSysConfig.GetValue( "s_CompatibleMode" ) );
	m_kCompatibilityModeCtrl.SetCheck( false != IsEqual( s_CompatibleMode, 0 ) ? 0 : 1 );

	// setup initial music quality value
	m_kMusicQualityCtrl.AddString( LoadString( IDS_LOW ) );
	m_kMusicQualityCtrl.AddString( LoadString( IDS_MEDIUM ) );
	m_kMusicQualityCtrl.AddString( LoadString( IDS_HIGH ) );

	SysConfigValue s_MusicMaxPatterns( m_kSysConfig.GetValue( "s_MusicMaxPatterns" ) );
	SysConfigValue s_MusicStreamedData( m_kSysConfig.GetValue( "s_MusicStreamedData" ) );
	if( false == IsEqual( s_MusicMaxPatterns, 0 ) )
	{
		if( false != IsEqual( s_MusicStreamedData, 0 ) )
		{
			m_kMusicQualityCtrl.SetCurSel( 1 );
		}
		else
		{
			m_kMusicQualityCtrl.SetCurSel( 2 );
		}		
	}
	else
	{
		m_kMusicQualityCtrl.SetCurSel( 0 );
	}

	// setup initial music enable value
	SysConfigValue s_MusicEnable( m_kSysConfig.GetValue( "s_MusicEnable" ) );	
	if( false == IsEqual( s_MusicEnable, 0 ) )
	{
		m_kEnableMusicCtrl.SetCheck( 1 );
	}
	else
	{
		m_kEnableMusicCtrl.SetCheck( 0 );		
		m_kMusicQualityCtrl.EnableWindow( FALSE );
		m_kAutoDetectMusicQualityCtrl.EnableWindow( FALSE );
	}

	// if needed, perform auto detection of optimal settings
	if( false != m_kSysConfig.IsInitialConfig() )
	{
		OnBnClickedAutoDetectMusicQuality();
	}

	return( TRUE );  
}



void 
CSoundOptionsPage::OnBnClickedHWMixing()
{
	if( 0 == m_kHWMixingCtrl.GetCheck() )
	{
		m_kEnableEAXCtrl.SetCheck( 0 );
		m_kEnableEAXCtrl.EnableWindow( FALSE );
	}
	else
	{
		m_kEnableEAXCtrl.EnableWindow( TRUE );
	}
}



void 
CSoundOptionsPage::OnBnClickedEnableMusic()
{
	if( 0 == m_kEnableMusicCtrl.GetCheck() )
	{
		m_kMusicQualityCtrl.EnableWindow( FALSE );
		m_kAutoDetectMusicQualityCtrl.EnableWindow( FALSE );
	}
	else
	{
		m_kMusicQualityCtrl.EnableWindow( TRUE );
		m_kAutoDetectMusicQualityCtrl.EnableWindow( TRUE );
	}
}



void 
CSoundOptionsPage::OnBnClickedAutoDetectMusicQuality()
{
	int index( DetermineMachineSpec( true, false, false, false ) );
	if( index > 2 )
	{
		index = 2;
	}
	m_kMusicQualityCtrl.SetCurSel( index );
}



void 
CSoundOptionsPage::UpdateSystemConfig()
{
	// write new speaker setup value
	int index( m_kSpeakerSetupCtrl.GetCurSel() );
	if( index >= 0 && index < sizeof( c_speakerSetup ) / sizeof( c_speakerSetup[ 0 ] ) )
	{
		char szMode[ 16 ];
		sprintf( szMode, "%d", c_speakerSetup[ index ] );
		m_kSysConfig.SetValue( "s_SpeakerConfig", szMode );
	}	

	// write new doppler effect value
	m_kSysConfig.SetValue( "s_DopplerEnable", ( FALSE != m_kDopplerEffectCtrl.GetCheck() ) ? "1" : "0" );

	// write new hw mixing value
	m_kSysConfig.SetValue( "s_MaxHWChannels", ( FALSE != m_kHWMixingCtrl.GetCheck() ) ? "28" : "0" );

	// write new enable EAX value
	m_kSysConfig.SetValue( "s_EnableSoundFX", ( FALSE != m_kEnableEAXCtrl.GetCheck() ) ? "1" : "0" );

	// write new compatibility mode value
	m_kSysConfig.SetValue( "s_CompatibleMode", ( FALSE != m_kCompatibilityModeCtrl.GetCheck() ) ? "1" : "0" );

	// write new music enable value
	m_kSysConfig.SetValue( "s_MusicEnable", ( FALSE != m_kEnableMusicCtrl.GetCheck() ) ? "1" : "0" );

	// write new music quality value
	index = m_kMusicQualityCtrl.GetCurSel();
	if( index >= 0 && index < 3 )
	{
		switch( index )
		{
		case 0:
			{
				m_kSysConfig.SetValue( "s_MusicMaxPatterns", "0" );
				m_kSysConfig.SetValue( "s_MusicStreamedData", "0" );
				break;
			}
		case 1:
			{
				m_kSysConfig.SetValue( "s_MusicMaxPatterns", "12" );
				m_kSysConfig.SetValue( "s_MusicStreamedData", "0" );
				break;
			}
		case 2:
			{
				m_kSysConfig.SetValue( "s_MusicMaxPatterns", "12" );
				m_kSysConfig.SetValue( "s_MusicStreamedData", "1" );
				break;
			}
		}
	}	
}



void 
CSoundOptionsPage::OnOK()
{
	CPropertyPage::OnOK();
	UpdateSystemConfig();
}
