#pragma once

#include "ConfigComboBox.h"



class CSystemConfiguration;



class CSoundOptionsPage : public CPropertyPage
{
public:
	CSoundOptionsPage( CSystemConfiguration& kSysConfig );
	virtual ~CSoundOptionsPage();
	virtual void OnOK();
	virtual BOOL OnInitDialog();

protected:
	virtual void DoDataExchange( CDataExchange* pDX );
	DECLARE_MESSAGE_MAP()

	afx_msg void OnBnClickedHWMixing();
	afx_msg void OnBnClickedEnableMusic();
	afx_msg void OnBnClickedAutoDetectMusicQuality();

private:
	void UpdateSystemConfig();
	DECLARE_DYNAMIC( CSoundOptionsPage )

private:
	CSystemConfiguration& m_kSysConfig;

	CConfigComboBox m_kSpeakerSetupCtrl;
	CButton m_kDopplerEffectCtrl;
	CButton m_kHWMixingCtrl;
	CButton m_kEnableEAXCtrl;
	CButton m_kCompatibilityModeCtrl;
	CButton m_kEnableMusicCtrl;
	CConfigComboBox m_kMusicQualityCtrl;
	CButton m_kAutoDetectMusicQualityCtrl;
};
