#include "stdafx.h"
#include "VideoAdvCustomEditDlg.h"
#include "VideoAdvCustomEditPage.h"
#include "Helpers.h"

// include resource IDs of english version, for all other languages the IDs MUST BE THE SAME!!!
#include "..\FarCryConfigEng\resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif



IMPLEMENT_DYNAMIC( CVideoAdvCustomEditDlg, CPropertySheet )



CVideoAdvCustomEditDlg::CVideoAdvCustomEditDlg( CSystemConfiguration& kSysConfig, CWnd* pParentWnd )
: CPropertySheet( IDS_VIDEOADVCUSTOMEDIT, pParentWnd )
, m_kSysConfig( kSysConfig )
{
	const unsigned int c_tabLabelIDs[ NUM_PAGES ] =
	{
		IDS_TEXTUREQUALITY, IDS_TEXTUREFILTERQUALITY, IDS_ANISOTROPICFILTERINGLEVEL,
		IDS_PARTICLECOUNT, IDS_SPECIALEFFETCSQUALITY, IDS_ENVIRONMENTQUALITY,
		IDS_SHADOWQUALITY, IDS_WATERQUALITY, IDS_LIGHTINGQUALITY
	};

	for( int i( 0 ); i < NUM_PAGES; ++i )
	{
		// reset page ptr
		m_pkPage[ i ] = 0;

		// tab label
		m_strTabLabel[ i ] = LoadString( c_tabLabelIDs[ i ] );
	}

	// remove flags for apply and help button
	m_psh.dwFlags |= PSH_NOAPPLYNOW;
	m_psh.dwFlags &= ~PSH_HASHELP;

	// create all edit pages
	CreatePages();
}



CVideoAdvCustomEditDlg::~CVideoAdvCustomEditDlg()
{
	for( int i( 0 ); i < NUM_PAGES; ++i )
	{
		SafeRelease( m_pkPage[ i ] );
	}	
}



void
CVideoAdvCustomEditDlg::CreatePages()
{
	// avoid multiple stacks of tabs
	EnableStackedTabs( FALSE );

	// add texture quality edit page
	CVarVector colTextureQualityCVarKeys;
	colTextureQualityCVarKeys.push_back( SCVar( "r_TexResolution", "", new SCVar::CIntValidator( 0, 2 ), IDS_R_TEXRESOLUTION ) );
	colTextureQualityCVarKeys.push_back( SCVar( "r_TexSkyResolution", "", new SCVar::CIntValidator( 0, 2 ), IDS_R_TEXSKYRESOLUTION ) );
	colTextureQualityCVarKeys.push_back( SCVar( "r_TexBumpResolution", "" , new SCVar::CIntValidator( 0, 2 ), IDS_R_TEXBUMPRESOLUTION ) );
	colTextureQualityCVarKeys.push_back( SCVar( "e_detail_texture_quality", "", new SCVar::CIntValidator( 0, 1 ), IDS_E_DETAIL_TEXTURE_QUALITY ) );
	colTextureQualityCVarKeys.push_back( SCVar( "r_DetailTextures", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_DETAILTEXTURES ) );
	colTextureQualityCVarKeys.push_back( SCVar( "r_DetailNumLayers", "", new SCVar::CIntValidator( 0, 2 ), IDS_R_DETAILNUMLAYERS ) );
	colTextureQualityCVarKeys.push_back( SCVar( "r_DetailDistance", "", new SCVar::CDoubleValidator( 0, 16 ), IDS_R_DETAILDISTANCE ) );

	m_pkPage[ 0 ] = new CVideoAdvCustomEditPage( colTextureQualityCVarKeys, m_kSysConfig );
	AddPage( m_pkPage[ 0 ] );

	// add texture filter quality edit page
	CVarVector colTextureFilterQualityCVarKeys;
	colTextureFilterQualityCVarKeys.push_back( SCVar( "d3d9_TextureFilter", "", new SCVar::CStringValidator(), IDS_D3D9_TEXTUREFILTER ) );
	colTextureFilterQualityCVarKeys.push_back( SCVar( "GL_TextureFilter", "", new SCVar::CStringValidator(), IDS_GL_TEXTUREFILTER ) );				

	m_pkPage[ 1 ] = new CVideoAdvCustomEditPage( colTextureFilterQualityCVarKeys, m_kSysConfig );
	AddPage( m_pkPage[ 1 ] );

	// add anisotropic filtering level edit page
	CVarVector colAnisotropicFilteringLevelCVarKeys;
	colAnisotropicFilteringLevelCVarKeys.push_back( SCVar( "r_Texture_Anisotropic_Level", "", new SCVar::CIntValidator( 1, 16 ), IDS_R_TEXTURE_ANISOTROPIC_LEVEL ) );

	m_pkPage[ 2 ] = new CVideoAdvCustomEditPage( colAnisotropicFilteringLevelCVarKeys, m_kSysConfig );
	AddPage( m_pkPage[ 2 ] );

	// add anisotropic filtering level edit page
	CVarVector colParticleCountCVarKeys;
	colParticleCountCVarKeys.push_back( SCVar( "e_particles_max_count", "", new SCVar::CIntValidator( 0 ), IDS_E_PARTICLES_MAX_COUNT ) );
	colParticleCountCVarKeys.push_back( SCVar( "e_particles_lod", "", new SCVar::CDoubleValidator( 0.5, 1.0 ), IDS_E_PARTICLES_LOD ) );

	m_pkPage[ 3 ] = new CVideoAdvCustomEditPage( colParticleCountCVarKeys, m_kSysConfig );
	AddPage( m_pkPage[ 3 ] );

	// add special effects quality edit page
	CVarVector colSpecialEffectsQualityCVarKeys;
	colSpecialEffectsQualityCVarKeys.push_back( SCVar( "r_MotionBlur", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_MOTIONBLUR ) );
	colSpecialEffectsQualityCVarKeys.push_back( SCVar( "r_Glare", "", new SCVar::CIntValidator( 0 ), IDS_R_GLARE ) );
	colSpecialEffectsQualityCVarKeys.push_back( SCVar( "r_GlareQuality", "", new SCVar::CIntValidator( 0, 2 ), IDS_R_GLAREQUALITY ) );
	colSpecialEffectsQualityCVarKeys.push_back( SCVar( "r_Flares", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_FLARES ) );
	colSpecialEffectsQualityCVarKeys.push_back( SCVar( "r_checkSunVis", "", new SCVar::CIntValidator( 0, 3 ), IDS_R_CHECKSUNVIS ) );
	colSpecialEffectsQualityCVarKeys.push_back( SCVar( "r_Coronas", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_CORONAS ) );
	colSpecialEffectsQualityCVarKeys.push_back( SCVar( "r_CoronaFade", "", new SCVar::CDoubleValidator( 0.0, 1.0 ), IDS_R_CORONAFADE ) );
	colSpecialEffectsQualityCVarKeys.push_back( SCVar( "r_HeatHaze", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_HEATHAZE ) );
	colSpecialEffectsQualityCVarKeys.push_back( SCVar( "r_ScopeLens_fx", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_SCOPELENS_FX ) );
	colSpecialEffectsQualityCVarKeys.push_back( SCVar( "r_ProcFlares", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_PROCFLARES ) );
	colSpecialEffectsQualityCVarKeys.push_back( SCVar( "r_CryvisionType", "", new SCVar::CIntValidator( 0, 2 ), IDS_R_CRYVISIONTYPE ) );
	colSpecialEffectsQualityCVarKeys.push_back( SCVar( "r_DisableSfx", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_DISABLESFX ) );
	colSpecialEffectsQualityCVarKeys.push_back( SCVar( "r_Beams", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_BEAMS ) );
	colSpecialEffectsQualityCVarKeys.push_back( SCVar( "es_EnableCloth", "", new SCVar::CIntValidator( 0, 1 ), IDS_ES_ENABLECLOTH ) );

	m_pkPage[ 4 ] = new CVideoAdvCustomEditPage( colSpecialEffectsQualityCVarKeys, m_kSysConfig );
	AddPage( m_pkPage[ 4 ] );

	// add environment quality edit page
	CVarVector colEnvironmentQualityCVarKeys;

	colEnvironmentQualityCVarKeys.push_back( SCVar( "r_VolumetricFog", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_VOLUMETRICFOG ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "r_EnvCMResolution", "", new SCVar::CIntValidator( 0, 2 ), IDS_R_ENVCMRESOLUTION ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "r_EnvCMupdateInterval", "", new SCVar::CDoubleValidator( 0.001, 1.0 ), IDS_R_ENVCMUPDATEINTERVAL ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "r_EnvTexResolution", "", new SCVar::CIntValidator( 0, 3 ), IDS_R_ENVTEXRESOLUTION ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "r_EnvTexUpdateInterval", "", new SCVar::CDoubleValidator( 0.001, 1.0 ), IDS_R_ENVTEXUPDATEINTERVAL ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "e_decals", "", new SCVar::CIntValidator( 0, 1 ), IDS_E_DECALS ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "e_decals_life_time_scale", "", new SCVar::CDoubleValidator( 0.5 ), IDS_E_DECALS_LIFE_TIME_SCALE ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "ca_EnableDecals", "", new SCVar::CIntValidator( 0, 1 ), IDS_CA_ENABLEDECALS ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "e_overlay_geometry", "", new SCVar::CIntValidator( 0, 1 ), IDS_E_OVERLAY_GEOMETRY ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "e_obj_lod_ratio", "", new SCVar::CDoubleValidator( 5.0 ), IDS_E_OBJ_LOD_RATIO ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "e_vegetation_sprites_distance_ratio", "", new SCVar::CDoubleValidator( 0.9 ), IDS_E_VEGETATION_SPRITES_DISTANCE_RATIO ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "e_cgf_load_lods", "", new SCVar::CIntValidator( 0, 1 ), IDS_E_CGF_LOAD_LODS ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "e_vegetation_min_size", "", new SCVar::CDoubleValidator( 0.0 ), IDS_E_VEGETATION_MIN_SIZE ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "e_flocks", "", new SCVar::CIntValidator( 0, 1 ), IDS_E_FLOCKS ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "e_EntitySuppressionLevel", "", new SCVar::CIntValidator( 0 ), IDS_E_ENTITYSUPPRESSIONLEVEL ) );
	colEnvironmentQualityCVarKeys.push_back( SCVar( "sys_skiponlowspec", "", new SCVar::CIntValidator( 0, 1 ), IDS_SYS_SKIPONLOWSPEC ) );

	m_pkPage[ 5 ] = new CVideoAdvCustomEditPage( colEnvironmentQualityCVarKeys, m_kSysConfig );
	AddPage( m_pkPage[ 5 ] );

	// add shadow quality edit page
	CVarVector colShadowQualityCVarKeys;

	colShadowQualityCVarKeys.push_back( SCVar( "e_stencil_shadows", "", new SCVar::CIntValidator( 0, 1 ), IDS_E_STENCIL_SHADOWS ) );
	colShadowQualityCVarKeys.push_back( SCVar( "e_shadow_maps", "", new SCVar::CIntValidator( 0, 1 ), IDS_E_SHADOW_MAPS ) );
	colShadowQualityCVarKeys.push_back( SCVar( "e_active_shadow_maps_receving", "", new SCVar::CIntValidator( 0, 2 ), IDS_E_ACTIVE_SHADOW_MAPS_RECEVING ) );
	colShadowQualityCVarKeys.push_back( SCVar( "r_ShadowBlur", "", new SCVar::CIntValidator( 0, 3 ), IDS_R_SHADOWBLUR ) );
	//colShadowQualityCVarKeys.push_back( SCVar( "r_SelfShadow", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_SELFSHADOW ) );
	colShadowQualityCVarKeys.push_back( SCVar( "e_shadow_maps_view_dist_ratio", "", new SCVar::CDoubleValidator( 10.0 ), IDS_E_SHADOW_MAPS_VIEW_DIST_RATIO ) );

	m_pkPage[ 6 ] = new CVideoAdvCustomEditPage( colShadowQualityCVarKeys, m_kSysConfig );
	AddPage( m_pkPage[ 6 ] );

	// add water quality edit page
	CVarVector colWaterQualityCVarKeys;

	colWaterQualityCVarKeys.push_back( SCVar( "r_WaterRefractions", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_WATERREFRACTIONS ) );
	colWaterQualityCVarKeys.push_back( SCVar( "r_WaterReflections", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_WATERREFLECTIONS ) );
	colWaterQualityCVarKeys.push_back( SCVar( "r_WaterUpdateFactor", "", new SCVar::CDoubleValidator( 0.001, 1.0 ), IDS_R_WATERUPDATEFACTOR ) );
	colWaterQualityCVarKeys.push_back( SCVar( "r_Quality_Reflection", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_QUALITY_REFLECTION ) );
	colWaterQualityCVarKeys.push_back( SCVar( "e_beach", "", new SCVar::CIntValidator( 0, 1 ), IDS_E_BEACH ) );
	colWaterQualityCVarKeys.push_back( SCVar( "e_use_global_fog_in_fog_volumes", "", new SCVar::CIntValidator( 0, 1 ), IDS_E_USE_GLOBAL_FOG_IN_FOG_VOLUMES ) );

	m_pkPage[ 7 ] = new CVideoAdvCustomEditPage( colWaterQualityCVarKeys, m_kSysConfig );
	AddPage( m_pkPage[ 7 ] );
	
	// add lighting quality edit page
	CVarVector colLightingQualityCVarKeys;

	colLightingQualityCVarKeys.push_back( SCVar( "r_Quality_BumpMapping", "", new SCVar::CIntValidator( 0, 3 ), IDS_R_QUALITY_BUMPMAPPING ) );
	colLightingQualityCVarKeys.push_back( SCVar( "r_Vegetation_PerpixelLight", "", new SCVar::CIntValidator( 0, 1 ), IDS_R_VEGETATION_PERPIXELLIGHT ) );
	colLightingQualityCVarKeys.push_back( SCVar( "e_light_maps_quality", "", new SCVar::CIntValidator( 0, 2 ), IDS_E_LIGHT_MAPS_QUALITY ) );
	colLightingQualityCVarKeys.push_back( SCVar( "ca_ambient_light_intensity", "", new SCVar::CDoubleValidator( 0.0, 1.0 ), IDS_CA_AMBIENT_LIGHT_INTENSITY ) );
	colLightingQualityCVarKeys.push_back( SCVar( "ca_ambient_light_range", "", new SCVar::CDoubleValidator( 0.0 ), IDS_CA_AMBIENT_LIGHT_RANGE ) );
	colLightingQualityCVarKeys.push_back( SCVar( "e_max_entity_lights", "", new SCVar::CIntValidator( 1 ), IDS_E_MAX_ENTITY_LIGHTS ) );
	colLightingQualityCVarKeys.push_back( SCVar( "e_stencil_shadows_only_from_strongest_light", "", new SCVar::CIntValidator( 0, 1 ), IDS_E_STENCIL_SHADOWS_ONLY_FROM_STRONGEST_LIGHT ) );
	colLightingQualityCVarKeys.push_back( SCVar( "p_lightrange", "", new SCVar::CDoubleValidator( 0.0 ), IDS_P_LIGHTRANGE ) );
	colLightingQualityCVarKeys.push_back( SCVar( "r_EnvLightCMSize", "", new SCVar::CIntValidator( 4, 64 ), IDS_R_ENVLIGHTCMSIZE ) );
	colLightingQualityCVarKeys.push_back( SCVar( "r_EnvLCMupdateInterval", "", new SCVar::CDoubleValidator( 0.001, 1.0 ), IDS_R_ENVLCMUPDATEINTERVAL ) );
	colLightingQualityCVarKeys.push_back( SCVar( "cl_projectile_light", "", new SCVar::CIntValidator( 0, 1 ), IDS_CL_PROJECTILE_LIGHT ) );
	colLightingQualityCVarKeys.push_back( SCVar( "cl_weapon_light", "", new SCVar::CIntValidator( 0, 2 ), IDS_CL_WEAPON_LIGHT ) );
	
	m_pkPage[ 8 ] = new CVideoAdvCustomEditPage( colLightingQualityCVarKeys, m_kSysConfig );
	AddPage( m_pkPage[ 8 ] );
}



BEGIN_MESSAGE_MAP( CVideoAdvCustomEditDlg, CPropertySheet )
END_MESSAGE_MAP()



BOOL 
CVideoAdvCustomEditDlg::OnInitDialog()
{
	// init property sheet
	BOOL bResult( CPropertySheet::OnInitDialog() );

	///// debug code only....
	//CFont* pNewFont = new CFont();
	//pNewFont->CreateFont( 12, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, 
	//	DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY, 
	//	FF_DONTCARE, _T( "MS Mincho" ) );

	//GetTabControl()->SetFont( pNewFont );

	//for( int j( 0 ); j < NUM_PAGES; ++j )
	//{
	//	SetActivePage( m_pkPage[ j ] );

	//	m_pkPage[ j ]->SetFont( pNewFont );

	//	for( int i( 1000 ); i < 1038; ++i )
	//	{
	//		CWnd* p( m_pkPage[ j ]->GetDlgItem( i ) );
	//		if( 0 != p )
	//		{
	//			p->SetFont( pNewFont );
	//		}
	//	}
	//}
	///// debug code ends

	// label tabs
	for( int i( 0 ); i < NUM_PAGES; ++i )
	{
		TC_ITEM item;
		item.mask = TCIF_TEXT;	
		item.pszText = (LPTSTR) (LPCTSTR) m_strTabLabel[ i ];
		GetTabControl()->SetItem( i, &item );
	}
	
	// manually set active page to force redrawing of sheet (to fix inproperly drawn tab ctrl)
	SetActivePage( m_pkPage[ 0 ] );

	return( bResult );
}



void
CVideoAdvCustomEditDlg::UpdateSystemConfig()
{
	// iterate over all page to update cvar assigned to them
	for( int i( 0 ); i < NUM_PAGES; ++i )
	{
		m_pkPage[ i ]->UpdateSystemConfig();
	}
}