#include "stdafx.h"
#include "FarCryInstallJobs.h"
#include "DirectDrawLoader.h"



// prototype of helper functions
static bool IsAGPHardware( IDirectDraw*& pDD );
static unsigned int GetTotalLocalVideoMemory( IDirectDraw*& pDD );
static unsigned int GetTotalNonLocalVideoMemory( IDirectDraw*& pDD );
static unsigned int GetNextPowerOfTwo( unsigned int uiX );



FARCRYINSTALLJOBS_API BOOL 
CheckAGPApertureSize()
{	
	IDirectDraw* pDD( 0 );
	bool bIsAGPHardware( false );
	unsigned int uiTotalLocalVideoMemoryInMB( 0 );
	unsigned int uiTotalNonLocalVideoMemoryInMB( 0 );

	try
	{
		// to get the approx. aperture size when need to utilize DirectDraw (DD7 to be precise)
		if( 0 == ( pDD = CDirectDrawLoader::GetInstance().DirectDrawCreate() ) )
		{
			throw( 0 );
		}

		// gather data
		bIsAGPHardware = IsAGPHardware( pDD );
		uiTotalLocalVideoMemoryInMB = GetNextPowerOfTwo( GetTotalLocalVideoMemory( pDD ) >> 20 );
		uiTotalNonLocalVideoMemoryInMB = GetNextPowerOfTwo( GetTotalNonLocalVideoMemory( pDD ) >> 20 );

#ifdef _DEBUG
		TCHAR pcDbgOutput[ 128 ];
		_stprintf( pcDbgOutput, _T( "Local Video Memory: %d MB\nNon-Local Video Memory: %d MB\nIs AGP hw: %d" ), 
			uiTotalLocalVideoMemoryInMB, uiTotalNonLocalVideoMemoryInMB, bIsAGPHardware );
		::MessageBox( 0, pcDbgOutput, _T( "In debug build only!" ), MB_OK );
#endif
	}
	catch( ... )
	{
		// release interface
		SafeRelease( pDD );

		// something went wrong so we assume AGP aperture size is ok		
		return( TRUE );
	}	

	// release interface
	SafeRelease( pDD );

	// check aperture size and return
	if( false != bIsAGPHardware )
	{
		// check if aperture is set too low
		if( uiTotalLocalVideoMemoryInMB <= 128 && uiTotalNonLocalVideoMemoryInMB < 64 )
		{
			// aperture size is too low
			return( FALSE );
		}
	}

	// aperture size is ok
	return( TRUE );
}



static bool
IsAGPHardware( IDirectDraw*& pDD )
{
	assert( 0 != pDD );

	DDCAPS sDDDevCaps;
	memset( &sDDDevCaps, 0, sizeof( sDDDevCaps ) );
	sDDDevCaps.dwSize = sizeof( sDDDevCaps );	
	HRESULT hr( pDD->GetCaps( &sDDDevCaps, 0 ) );
	assert( S_OK == hr );

	return( 0 != ( sDDDevCaps.dwCaps2 & DDCAPS2_NONLOCALVIDMEM ) );
}



static unsigned int
GetTotalLocalVideoMemory( IDirectDraw*& pDD )
{
	assert( 0 != pDD );

	IDirectDraw7* pDD7( 0 );
	DWORD dwLocalTotal( 0 );

	if( SUCCEEDED( pDD->QueryInterface( IID_IDirectDraw7, (void**) &pDD7 ) ) && 0 != pDD7 )
	{
		DDSCAPS2 sDDSCaps2;
		ZeroMemory( &sDDSCaps2, sizeof( sDDSCaps2 ) );
		sDDSCaps2.dwCaps = DDSCAPS_LOCALVIDMEM; 

		HRESULT hr( pDD7->GetAvailableVidMem( &sDDSCaps2, &dwLocalTotal, 0 ) );
		assert( S_OK == hr );

		SafeRelease( pDD7 );
	}
	return( dwLocalTotal );
}



static unsigned int
GetTotalNonLocalVideoMemory( IDirectDraw*& pDD )
{
	assert( 0 != pDD );

	IDirectDraw7* pDD7( 0 );
	DWORD dwNonLocalTotal( 0 );

	if( SUCCEEDED( pDD->QueryInterface( IID_IDirectDraw7, (void**) &pDD7 ) ) && 0 != pDD7 )
	{
		DDSCAPS2 sDDSCaps2;
		ZeroMemory( &sDDSCaps2, sizeof( sDDSCaps2 ) );
		sDDSCaps2.dwCaps = DDSCAPS_NONLOCALVIDMEM; 

		HRESULT hr( pDD7->GetAvailableVidMem( &sDDSCaps2, &dwNonLocalTotal, 0 ) );
		assert( S_OK == hr );

		SafeRelease( pDD7 );

	}
	return( dwNonLocalTotal );
}



static unsigned int
GetNextPowerOfTwo( unsigned int uiX )
{
	// check if input is a power of two already
	if( 0 == ( uiX & ( uiX - 1 ) ) )
	{
		return( uiX );
	}
	else
	{
		// shift down to zero and count the number (which is equivalent to the next power's exponent)
		unsigned int uiNumShifts( 0 );
		while( 0 != uiX )
		{
			uiX >>= 1;
			++uiNumShifts;
		}
		return( 1 << uiNumShifts );
	}
}