#pragma once



// singleton class to dynamically load ddraw.dll and create instances on IDirectDraw
class CDirectDrawLoader
{
public:
	typedef HRESULT (WINAPI *FPDirectDrawCreate) ( GUID FAR* lpGUID, LPDIRECTDRAW FAR* lplpDD, IUnknown FAR* pUnkOuter );

public:
	static CDirectDrawLoader& GetInstance();

	~CDirectDrawLoader();

	IDirectDraw* DirectDrawCreate();

private:
	CDirectDrawLoader();

private:
	HMODULE m_hDDraw;
	FPDirectDrawCreate m_pfCreate;
};



CDirectDrawLoader::CDirectDrawLoader()
: m_hDDraw( ::LoadLibrary( _T( "ddraw.dll" ) ) )
, m_pfCreate( 0 )
{
	if( 0 != m_hDDraw )
	{
		m_pfCreate = (FPDirectDrawCreate) GetProcAddress( m_hDDraw, "DirectDrawCreate" );
	}
}   



CDirectDrawLoader::~CDirectDrawLoader()
{
	if( 0 != m_hDDraw )
	{
		::FreeLibrary( m_hDDraw );
	}
}



CDirectDrawLoader& 
CDirectDrawLoader::GetInstance()
{
	static CDirectDrawLoader s_kInstance;
	return( s_kInstance );
}



IDirectDraw* 
CDirectDrawLoader::DirectDrawCreate()
{
	IDirectDraw* pDD( 0 );
	if( 0 != m_pfCreate )
	{
		m_pfCreate( 0, &pDD, 0 );
	}     

	return( pDD );
}

