using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace InternetSimulator
{
	/// <summary>
	/// Summary description for LossForm.
	/// </summary>
	public class LossForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.TrackBar tbPercentage;
		public System.Windows.Forms.TextBox textPercentage;
		private System.Windows.Forms.Button btnOk;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Button btnCancel;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public LossForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.tbPercentage = new System.Windows.Forms.TrackBar();
			this.textPercentage = new System.Windows.Forms.TextBox();
			this.btnOk = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.btnCancel = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.tbPercentage)).BeginInit();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// tbPercentage
			// 
			this.tbPercentage.Location = new System.Drawing.Point(8, 56);
			this.tbPercentage.Maximum = 100;
			this.tbPercentage.Name = "tbPercentage";
			this.tbPercentage.Size = new System.Drawing.Size(256, 42);
			this.tbPercentage.TabIndex = 0;
			this.tbPercentage.TickFrequency = 5;
			this.tbPercentage.ValueChanged += new System.EventHandler(this.tbPercentage_ValueChanged);
			// 
			// textPercentage
			// 
			this.textPercentage.Location = new System.Drawing.Point(16, 24);
			this.textPercentage.Name = "textPercentage";
			this.textPercentage.Size = new System.Drawing.Size(64, 20);
			this.textPercentage.TabIndex = 1;
			this.textPercentage.Text = "0";
			this.textPercentage.TextChanged += new System.EventHandler(this.textPercentage_TextChanged);
			// 
			// btnOk
			// 
			this.btnOk.Location = new System.Drawing.Point(112, 120);
			this.btnOk.Name = "btnOk";
			this.btnOk.TabIndex = 3;
			this.btnOk.Text = "&Ok";
			this.btnOk.Click += new System.EventHandler(this.btnOk_Click);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.textPercentage,
																					this.tbPercentage});
			this.groupBox1.Location = new System.Drawing.Point(8, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(272, 104);
			this.groupBox1.TabIndex = 4;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Loss Precentage";
			// 
			// btnCancel
			// 
			this.btnCancel.Location = new System.Drawing.Point(200, 120);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 5;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// LossForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(290, 151);
			this.ControlBox = false;
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.btnCancel,
																		  this.groupBox1,
																		  this.btnOk});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MinimizeBox = false;
			this.Name = "LossForm";
			this.ShowInTaskbar = false;
			this.Text = "Loss";
			((System.ComponentModel.ISupportInitialize)(this.tbPercentage)).EndInit();
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void btnOk_Click(object sender, System.EventArgs e)
		{
			DialogResult=DialogResult.OK;
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			DialogResult=DialogResult.Cancel;
		}

		private void tbPercentage_CursorChanged(object sender, System.EventArgs e)
		{
			textPercentage.Text=tbPercentage.Value.ToString();
		}

		private void tbPercentage_ValueChanged(object sender, System.EventArgs e)
		{
			textPercentage.Text=tbPercentage.Value.ToString();
		}

		private void textPercentage_TextChanged(object sender, System.EventArgs e)
		{
		
			try 
			{
				int n=Convert.ToInt32(textPercentage.Text);
				if(n>100) n=100;
				tbPercentage.Value=n;
			}
			catch(FormatException )
			{
				tbPercentage.Value=0;
			}
		}

		
		public int percentage
		{
			get
			{
				try 
				{
					return Convert.ToInt32(textPercentage.Text);
				}
				catch(FormatException )
				{
					return 0;
				}
			}
			set
			{
				textPercentage.Text=value.ToString();
			}
		}

	}
}
