using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Xml;


namespace InternetSimulator
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Button btnStartStop;
		private NetSim.CBridgeClass bridge;
		private NetSim.CAdaptersClass adapters;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Button btnSelectTargetDevice;
		private System.Windows.Forms.TextBox textTargetIP;
		private System.Windows.Forms.TextBox textTargetSideDevice;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.TextBox textSourceSideDevice;
		private System.Windows.Forms.Button btnSelectSourceDevice;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button btnLossDev1;
		private System.Windows.Forms.Button btnLossDev2;
		private System.Windows.Forms.Button btnLinkDev1;
		private System.Windows.Forms.Button btnLinkDev2;
		private System.Windows.Forms.Button btnOrderDev1;
		private System.Windows.Forms.Button btnOrderDev2;
		private System.Windows.Forms.Button btnLatencyDev1;
		private System.Windows.Forms.Button btnLatencyDev2;
		private System.Windows.Forms.Button btnJitterDev1;
		private System.Windows.Forms.Button btnJitterDev2;
		private System.Windows.Forms.Label labelLossDev1;
		private System.Windows.Forms.Label labelLatencyDev1;
		private System.Windows.Forms.Label labelLatencyDev2;
		private System.Windows.Forms.Label labelLossDev2;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.GroupBox groupBox4;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.MenuItem menuItem8;
		private System.Windows.Forms.Label labelOrderDev2;
		private System.Windows.Forms.Label labelOrderDev1;
		private System.Windows.Forms.Label labelLinkDev1;
		private System.Windows.Forms.Label labelLinkDev2;
		private System.Windows.Forms.Label labelJitterDev2;
		private System.Windows.Forms.Label labelJitterDev1;
		private bool bridgeStarted = false;
		public MainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			bridge=new NetSim.CBridgeClass();
			bridge.TargetIP=textTargetIP.Text;
			bridge.devSourceSide.DeviceName="No Source device";
			bridge.devTargetSide.DeviceName="No Target device";
			UpdateDialog();
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(MainForm));
			this.btnStartStop = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.label1 = new System.Windows.Forms.Label();
			this.textTargetIP = new System.Windows.Forms.TextBox();
			this.btnSelectTargetDevice = new System.Windows.Forms.Button();
			this.textTargetSideDevice = new System.Windows.Forms.TextBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.btnSelectSourceDevice = new System.Windows.Forms.Button();
			this.textSourceSideDevice = new System.Windows.Forms.TextBox();
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.btnLossDev1 = new System.Windows.Forms.Button();
			this.btnLossDev2 = new System.Windows.Forms.Button();
			this.btnLinkDev1 = new System.Windows.Forms.Button();
			this.btnLinkDev2 = new System.Windows.Forms.Button();
			this.btnOrderDev1 = new System.Windows.Forms.Button();
			this.btnOrderDev2 = new System.Windows.Forms.Button();
			this.btnLatencyDev1 = new System.Windows.Forms.Button();
			this.btnLatencyDev2 = new System.Windows.Forms.Button();
			this.btnJitterDev1 = new System.Windows.Forms.Button();
			this.btnJitterDev2 = new System.Windows.Forms.Button();
			this.labelLossDev1 = new System.Windows.Forms.Label();
			this.labelLossDev2 = new System.Windows.Forms.Label();
			this.labelLatencyDev1 = new System.Windows.Forms.Label();
			this.labelLatencyDev2 = new System.Windows.Forms.Label();
			this.groupBox3 = new System.Windows.Forms.GroupBox();
			this.labelJitterDev2 = new System.Windows.Forms.Label();
			this.labelOrderDev2 = new System.Windows.Forms.Label();
			this.labelLinkDev2 = new System.Windows.Forms.Label();
			this.groupBox4 = new System.Windows.Forms.GroupBox();
			this.labelJitterDev1 = new System.Windows.Forms.Label();
			this.labelOrderDev1 = new System.Windows.Forms.Label();
			this.labelLinkDev1 = new System.Windows.Forms.Label();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.menuItem7 = new System.Windows.Forms.MenuItem();
			this.menuItem8 = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.groupBox3.SuspendLayout();
			this.groupBox4.SuspendLayout();
			this.SuspendLayout();
			// 
			// btnStartStop
			// 
			this.btnStartStop.Location = new System.Drawing.Point(328, 440);
			this.btnStartStop.Name = "btnStartStop";
			this.btnStartStop.TabIndex = 0;
			this.btnStartStop.Text = "Start";
			this.btnStartStop.Click += new System.EventHandler(this.btnStartStop_Click);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.label1,
																					this.textTargetIP,
																					this.btnSelectTargetDevice,
																					this.textTargetSideDevice});
			this.groupBox1.Location = new System.Drawing.Point(8, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(408, 96);
			this.groupBox1.TabIndex = 1;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Target Side Device";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 48);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(120, 16);
			this.label1.TabIndex = 3;
			this.label1.Text = "Target IP";
			// 
			// textTargetIP
			// 
			this.textTargetIP.Location = new System.Drawing.Point(16, 64);
			this.textTargetIP.Name = "textTargetIP";
			this.textTargetIP.Size = new System.Drawing.Size(112, 20);
			this.textTargetIP.TabIndex = 2;
			this.textTargetIP.Text = "127.0.0.1";
			this.textTargetIP.TextChanged += new System.EventHandler(this.textTargetIP_TextChanged);
			// 
			// btnSelectTargetDevice
			// 
			this.btnSelectTargetDevice.Location = new System.Drawing.Point(320, 24);
			this.btnSelectTargetDevice.Name = "btnSelectTargetDevice";
			this.btnSelectTargetDevice.TabIndex = 1;
			this.btnSelectTargetDevice.Text = "Select";
			this.btnSelectTargetDevice.Click += new System.EventHandler(this.btnSelectTargetDevice_Click);
			// 
			// textTargetSideDevice
			// 
			this.textTargetSideDevice.Location = new System.Drawing.Point(16, 24);
			this.textTargetSideDevice.Name = "textTargetSideDevice";
			this.textTargetSideDevice.ReadOnly = true;
			this.textTargetSideDevice.Size = new System.Drawing.Size(296, 20);
			this.textTargetSideDevice.TabIndex = 0;
			this.textTargetSideDevice.Text = "No Device Selected";
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.btnSelectSourceDevice,
																					this.textSourceSideDevice});
			this.groupBox2.Location = new System.Drawing.Point(8, 368);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(408, 64);
			this.groupBox2.TabIndex = 2;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Source Side Device";
			// 
			// btnSelectSourceDevice
			// 
			this.btnSelectSourceDevice.Location = new System.Drawing.Point(320, 24);
			this.btnSelectSourceDevice.Name = "btnSelectSourceDevice";
			this.btnSelectSourceDevice.TabIndex = 2;
			this.btnSelectSourceDevice.Text = "Select";
			this.btnSelectSourceDevice.Click += new System.EventHandler(this.btnSelectSourceDevice_Click);
			// 
			// textSourceSideDevice
			// 
			this.textSourceSideDevice.Location = new System.Drawing.Point(16, 24);
			this.textSourceSideDevice.Name = "textSourceSideDevice";
			this.textSourceSideDevice.ReadOnly = true;
			this.textSourceSideDevice.Size = new System.Drawing.Size(296, 20);
			this.textSourceSideDevice.TabIndex = 0;
			this.textSourceSideDevice.Text = "No Device Selected";
			// 
			// pictureBox2
			// 
			this.pictureBox2.BackColor = System.Drawing.SystemColors.Window;
			this.pictureBox2.Image = ((System.Drawing.Bitmap)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(16, 128);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(100, 224);
			this.pictureBox2.TabIndex = 4;
			this.pictureBox2.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.BackColor = System.Drawing.SystemColors.Window;
			this.pictureBox1.Image = ((System.Drawing.Bitmap)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(224, 128);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(100, 224);
			this.pictureBox1.TabIndex = 5;
			this.pictureBox1.TabStop = false;
			// 
			// btnLossDev1
			// 
			this.btnLossDev1.Location = new System.Drawing.Point(32, 144);
			this.btnLossDev1.Name = "btnLossDev1";
			this.btnLossDev1.TabIndex = 6;
			this.btnLossDev1.Text = "Loss";
			this.btnLossDev1.Click += new System.EventHandler(this.btnLossDev1_Click);
			// 
			// btnLossDev2
			// 
			this.btnLossDev2.Location = new System.Drawing.Point(240, 304);
			this.btnLossDev2.Name = "btnLossDev2";
			this.btnLossDev2.TabIndex = 7;
			this.btnLossDev2.Text = "Loss";
			this.btnLossDev2.Click += new System.EventHandler(this.btnLossDev2_Click);
			// 
			// btnLinkDev1
			// 
			this.btnLinkDev1.Location = new System.Drawing.Point(32, 184);
			this.btnLinkDev1.Name = "btnLinkDev1";
			this.btnLinkDev1.TabIndex = 8;
			this.btnLinkDev1.Text = "Link";
			// 
			// btnLinkDev2
			// 
			this.btnLinkDev2.Location = new System.Drawing.Point(240, 264);
			this.btnLinkDev2.Name = "btnLinkDev2";
			this.btnLinkDev2.TabIndex = 9;
			this.btnLinkDev2.Text = "Link";
			// 
			// btnOrderDev1
			// 
			this.btnOrderDev1.Location = new System.Drawing.Point(32, 224);
			this.btnOrderDev1.Name = "btnOrderDev1";
			this.btnOrderDev1.TabIndex = 10;
			this.btnOrderDev1.Text = "Order";
			// 
			// btnOrderDev2
			// 
			this.btnOrderDev2.Location = new System.Drawing.Point(240, 224);
			this.btnOrderDev2.Name = "btnOrderDev2";
			this.btnOrderDev2.TabIndex = 11;
			this.btnOrderDev2.Text = "Order";
			// 
			// btnLatencyDev1
			// 
			this.btnLatencyDev1.Location = new System.Drawing.Point(32, 264);
			this.btnLatencyDev1.Name = "btnLatencyDev1";
			this.btnLatencyDev1.TabIndex = 12;
			this.btnLatencyDev1.Text = "Latency";
			this.btnLatencyDev1.Click += new System.EventHandler(this.btnLatencyDev1_Click);
			// 
			// btnLatencyDev2
			// 
			this.btnLatencyDev2.Location = new System.Drawing.Point(240, 184);
			this.btnLatencyDev2.Name = "btnLatencyDev2";
			this.btnLatencyDev2.TabIndex = 13;
			this.btnLatencyDev2.Text = "Latency";
			this.btnLatencyDev2.Click += new System.EventHandler(this.btnLatencyDev2_Click);
			// 
			// btnJitterDev1
			// 
			this.btnJitterDev1.Location = new System.Drawing.Point(32, 304);
			this.btnJitterDev1.Name = "btnJitterDev1";
			this.btnJitterDev1.TabIndex = 14;
			this.btnJitterDev1.Text = "Jitter";
			// 
			// btnJitterDev2
			// 
			this.btnJitterDev2.Location = new System.Drawing.Point(240, 144);
			this.btnJitterDev2.Name = "btnJitterDev2";
			this.btnJitterDev2.TabIndex = 15;
			this.btnJitterDev2.Text = "Jitter";
			// 
			// labelLossDev1
			// 
			this.labelLossDev1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.labelLossDev1.Location = new System.Drawing.Point(120, 144);
			this.labelLossDev1.Name = "labelLossDev1";
			this.labelLossDev1.Size = new System.Drawing.Size(72, 24);
			this.labelLossDev1.TabIndex = 16;
			this.labelLossDev1.Text = "labelLossDev1";
			this.labelLossDev1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// labelLossDev2
			// 
			this.labelLossDev2.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.labelLossDev2.Location = new System.Drawing.Point(328, 304);
			this.labelLossDev2.Name = "labelLossDev2";
			this.labelLossDev2.Size = new System.Drawing.Size(72, 24);
			this.labelLossDev2.TabIndex = 17;
			this.labelLossDev2.Text = "label2";
			this.labelLossDev2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// labelLatencyDev1
			// 
			this.labelLatencyDev1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.labelLatencyDev1.Location = new System.Drawing.Point(120, 264);
			this.labelLatencyDev1.Name = "labelLatencyDev1";
			this.labelLatencyDev1.Size = new System.Drawing.Size(72, 24);
			this.labelLatencyDev1.TabIndex = 18;
			this.labelLatencyDev1.Text = "label2";
			this.labelLatencyDev1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// labelLatencyDev2
			// 
			this.labelLatencyDev2.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.labelLatencyDev2.Location = new System.Drawing.Point(328, 184);
			this.labelLatencyDev2.Name = "labelLatencyDev2";
			this.labelLatencyDev2.Size = new System.Drawing.Size(72, 24);
			this.labelLatencyDev2.TabIndex = 19;
			this.labelLatencyDev2.Text = "label2";
			this.labelLatencyDev2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// groupBox3
			// 
			this.groupBox3.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.labelJitterDev2,
																					this.labelOrderDev2,
																					this.labelLinkDev2});
			this.groupBox3.Location = new System.Drawing.Point(216, 112);
			this.groupBox3.Name = "groupBox3";
			this.groupBox3.Size = new System.Drawing.Size(200, 248);
			this.groupBox3.TabIndex = 20;
			this.groupBox3.TabStop = false;
			// 
			// labelJitterDev2
			// 
			this.labelJitterDev2.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.labelJitterDev2.Location = new System.Drawing.Point(112, 32);
			this.labelJitterDev2.Name = "labelJitterDev2";
			this.labelJitterDev2.Size = new System.Drawing.Size(72, 24);
			this.labelJitterDev2.TabIndex = 27;
			this.labelJitterDev2.Text = "label2";
			this.labelJitterDev2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// labelOrderDev2
			// 
			this.labelOrderDev2.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.labelOrderDev2.Location = new System.Drawing.Point(112, 112);
			this.labelOrderDev2.Name = "labelOrderDev2";
			this.labelOrderDev2.Size = new System.Drawing.Size(72, 24);
			this.labelOrderDev2.TabIndex = 23;
			this.labelOrderDev2.Text = "label2";
			this.labelOrderDev2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// labelLinkDev2
			// 
			this.labelLinkDev2.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.labelLinkDev2.Location = new System.Drawing.Point(112, 152);
			this.labelLinkDev2.Name = "labelLinkDev2";
			this.labelLinkDev2.Size = new System.Drawing.Size(72, 24);
			this.labelLinkDev2.TabIndex = 26;
			this.labelLinkDev2.Text = "label2";
			this.labelLinkDev2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// groupBox4
			// 
			this.groupBox4.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.labelJitterDev1,
																					this.labelOrderDev1,
																					this.labelLinkDev1});
			this.groupBox4.Location = new System.Drawing.Point(8, 112);
			this.groupBox4.Name = "groupBox4";
			this.groupBox4.Size = new System.Drawing.Size(200, 248);
			this.groupBox4.TabIndex = 21;
			this.groupBox4.TabStop = false;
			// 
			// labelJitterDev1
			// 
			this.labelJitterDev1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.labelJitterDev1.Location = new System.Drawing.Point(112, 192);
			this.labelJitterDev1.Name = "labelJitterDev1";
			this.labelJitterDev1.Size = new System.Drawing.Size(72, 24);
			this.labelJitterDev1.TabIndex = 28;
			this.labelJitterDev1.Text = "label2";
			this.labelJitterDev1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// labelOrderDev1
			// 
			this.labelOrderDev1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.labelOrderDev1.Location = new System.Drawing.Point(112, 112);
			this.labelOrderDev1.Name = "labelOrderDev1";
			this.labelOrderDev1.Size = new System.Drawing.Size(72, 24);
			this.labelOrderDev1.TabIndex = 24;
			this.labelOrderDev1.Text = "label2";
			this.labelOrderDev1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// labelLinkDev1
			// 
			this.labelLinkDev1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.labelLinkDev1.Location = new System.Drawing.Point(112, 72);
			this.labelLinkDev1.Name = "labelLinkDev1";
			this.labelLinkDev1.Size = new System.Drawing.Size(72, 24);
			this.labelLinkDev1.TabIndex = 25;
			this.labelLinkDev1.Text = "label2";
			this.labelLinkDev1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem1,
																					  this.menuItem6,
																					  this.menuItem4});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem2,
																					  this.menuItem3});
			this.menuItem1.Text = "&File";
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 0;
			this.menuItem2.Text = "&Load settings";
			this.menuItem2.Click += new System.EventHandler(this.menuItem2_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 1;
			this.menuItem3.Text = "&Save settings";
			this.menuItem3.Click += new System.EventHandler(this.menuItem3_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 1;
			this.menuItem6.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem7,
																					  this.menuItem8});
			this.menuItem6.Text = "&Tools";
			// 
			// menuItem7
			// 
			this.menuItem7.Index = 0;
			this.menuItem7.Text = "Mirror se&ttings (T->S)";
			// 
			// menuItem8
			// 
			this.menuItem8.Index = 1;
			this.menuItem8.Text = "Mirror &settings (T<-S)";
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 2;
			this.menuItem4.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem5});
			this.menuItem4.Text = "&Help";
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 0;
			this.menuItem5.Text = "&About";
			this.menuItem5.Click += new System.EventHandler(this.menuItem5_Click);
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(424, 469);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.labelLatencyDev2,
																		  this.labelLatencyDev1,
																		  this.labelLossDev2,
																		  this.labelLossDev1,
																		  this.btnJitterDev2,
																		  this.btnJitterDev1,
																		  this.btnLatencyDev2,
																		  this.btnLatencyDev1,
																		  this.btnOrderDev2,
																		  this.btnOrderDev1,
																		  this.btnLinkDev2,
																		  this.btnLinkDev1,
																		  this.btnLossDev2,
																		  this.btnLossDev1,
																		  this.pictureBox1,
																		  this.pictureBox2,
																		  this.groupBox2,
																		  this.groupBox1,
																		  this.btnStartStop,
																		  this.groupBox3,
																		  this.groupBox4});
			this.Menu = this.mainMenu1;
			this.Name = "MainForm";
			this.Text = "Internet Simulator";
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.groupBox3.ResumeLayout(false);
			this.groupBox4.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

		private void btnStartStop_Click(object sender, System.EventArgs e)
		{
			if(!bridgeStarted)
			{
				try
				{
					bridge.Start();
					bridgeStarted=true;
					btnStartStop.Text="Stop";
				}
				catch(System.Runtime.InteropServices.COMException ex)
				{
					MessageBox.Show(ex.Message,"Internet Simulator");
				}
			}
			else
			{
				bridge.Stop();
				bridgeStarted=false;
				btnStartStop.Text="Start";
			}
		}  

		private int SelectLoss(int percentage)
		{
			LossForm lf=new LossForm();
			lf.percentage=percentage;
			if(lf.ShowDialog(this)==DialogResult.OK)
			{
				return Convert.ToInt32(lf.textPercentage.Text);
			}
			return percentage;
		}
		private void btnLossDev1_Click(object sender, System.EventArgs e)
		{
			bridge.devTargetSide.Loss=SelectLoss(bridge.devTargetSide.Loss);
			UpdateDialog();
		}
		private void SelectLatency(int min,int max, ref int omin, ref int omax)
		{
			LatencyForm lf=new LatencyForm();
            lf.maxLatency=max;
			lf.minLatency=min;
			if(lf.ShowDialog(this)==DialogResult.OK)
			{
				omax=lf.maxLatency;
				omin=lf.minLatency;
				return;
			}
			omax=max;
			omin=min;
			return;
		}
		private void btnLatencyDev1_Click(object sender, System.EventArgs e)
		{
			int min=0,max=0;
			SelectLatency(bridge.devTargetSide.MinLatency,bridge.devTargetSide.MaxLatency,ref min,ref max);
			bridge.devTargetSide.MinLatency=min;
			bridge.devTargetSide.MaxLatency=max;
			UpdateDialog();
		}

		private bool SelectDevice(String curr_selection,ref String selected_device)
		{
			AdapterForm af=new AdapterForm();
			adapters=new NetSim.CAdaptersClass();
			foreach (NetSim.CAdapter adp in adapters)
			{
				af.AddAdapter(adp.name,adp.IPAddress);
			}

			af.SetSelection(curr_selection);

			if(af.ShowDialog(this)==DialogResult.OK)
			{
				selected_device=af.GetSelection();
				return true;
			}
			else
			{
				return false;
			}
		}
		private void btnSelectTargetDevice_Click(object sender, System.EventArgs e)
		{
			String asd="";
			SelectDevice(bridge.devTargetSide.DeviceName,ref asd);
			bridge.devTargetSide.DeviceName=asd;
			UpdateDialog();
		}

		private void btnSelectSourceDevice_Click(object sender, System.EventArgs e)
		{
			String asd="";
			SelectDevice(bridge.devSourceSide.DeviceName,ref asd);
			bridge.devSourceSide.DeviceName=asd;
			UpdateDialog();
		}
		private void UpdateDialog()
		{
			labelLatencyDev1.Text=Convert.ToString(bridge.devTargetSide.MinLatency)+"-"+Convert.ToString(bridge.devTargetSide.MaxLatency)+" ms";
			labelLatencyDev2.Text=Convert.ToString(bridge.devSourceSide.MinLatency)+"-"+Convert.ToString(bridge.devSourceSide.MaxLatency)+" ms";
			labelLossDev1.Text=Convert.ToString(bridge.devTargetSide.Loss)+"%";
			labelLossDev2.Text=Convert.ToString(bridge.devSourceSide.Loss)+"%";
			labelOrderDev1.Text=Convert.ToString(bridge.devTargetSide.OutOfOrder)+"%";
			labelOrderDev2.Text=Convert.ToString(bridge.devSourceSide.OutOfOrder)+"%";
			labelLinkDev1.Text=Convert.ToString(bridge.devTargetSide.BandWidth/1024)+" kbs";
			labelLinkDev2.Text=Convert.ToString(bridge.devSourceSide.BandWidth/1024)+" kbs";
			textTargetIP.Text=bridge.TargetIP;
			textTargetSideDevice.Text=bridge.devTargetSide.DeviceName;
			textSourceSideDevice.Text=bridge.devSourceSide.DeviceName;
			
		}
		private void btnLossDev2_Click(object sender, System.EventArgs e)
		{
			bridge.devSourceSide.Loss=SelectLoss(bridge.devSourceSide.Loss);
			UpdateDialog();
		}
		private void btnLatencyDev2_Click(object sender, System.EventArgs e)
		{
			int min=0,max=0;
			SelectLatency(bridge.devSourceSide.MinLatency,bridge.devSourceSide.MaxLatency,ref min,ref max);
			bridge.devSourceSide.MinLatency=min;
			bridge.devSourceSide.MaxLatency=max;
			UpdateDialog();
		}
		private void SaveDeviceConfig(XmlDocument doc,XmlElement r,NetSim.CDevice d)
		{
			XmlAttribute a;
			XmlElement e;
			a=doc.CreateAttribute("devicename");
			a.Value=d.DeviceName;
			r.SetAttributeNode(a);
			//LOSS
			e=doc.CreateElement("loss");
			r.AppendChild(e);
			a=doc.CreateAttribute("percentage");
			a.Value=Convert.ToString(d.Loss);
			e.SetAttributeNode(a);
			//LATENCY
			e=doc.CreateElement("latency");
			r.AppendChild(e);
			a=doc.CreateAttribute("min");
			a.Value=Convert.ToString(d.MinLatency);
			e.SetAttributeNode(a);
			a=doc.CreateAttribute("max");
			a.Value=Convert.ToString(d.MaxLatency);
			e.SetAttributeNode(a);
			//ORDER
			e=doc.CreateElement("outoforder");
			r.AppendChild(e);
			a=doc.CreateAttribute("percentage");
			a.Value=Convert.ToString(d.OutOfOrder);
			e.SetAttributeNode(a);
			//LINK
			e=doc.CreateElement("link");
			r.AppendChild(e);
			a=doc.CreateAttribute("kbs");
			a.Value=Convert.ToString(d.BandWidth);
			e.SetAttributeNode(a);

		}
		private void LoadDeviceConfig(XmlNode rr,NetSim.CDevice d)
		{
			XmlElement r=(XmlElement)rr;
			XmlElement e;
			XmlNodeList nl;
			IEnumerator en;
			d.DeviceName=r.GetAttribute("devicename");
			//LOSS
			nl=r.GetElementsByTagName("loss");
			en=nl.GetEnumerator();
			en.Reset(); en.MoveNext(); e=(XmlElement)en.Current;
			d.Loss=Convert.ToInt32(e.GetAttribute("percentage"));
			//LATENCY
			nl=r.GetElementsByTagName("latency");
			en=nl.GetEnumerator();
			en.Reset(); en.MoveNext(); e=(XmlElement)en.Current;
			d.MinLatency=Convert.ToInt32(e.GetAttribute("min"));
			d.MaxLatency=Convert.ToInt32(e.GetAttribute("max"));
			//ORDER
			nl=r.GetElementsByTagName("outoforder");
			en=nl.GetEnumerator();
			en.Reset(); en.MoveNext(); e=(XmlElement)en.Current;
			d.OutOfOrder=Convert.ToInt32(e.GetAttribute("percentage"));
			//LINK
			nl=r.GetElementsByTagName("link");
			en=nl.GetEnumerator();
			en.Reset(); en.MoveNext(); e=(XmlElement)en.Current;
			d.BandWidth=Convert.ToInt32(e.GetAttribute("kbs"));
		}
		private void _Save(String name)
		{
			XmlDocument doc=new XmlDocument();
			XmlElement root=doc.CreateElement("inetsim");
			XmlElement t;
			XmlAttribute a;
			a=doc.CreateAttribute("targetip");
			doc.AppendChild(root);
			root.SetAttributeNode(a);
			a.Value=bridge.TargetIP;
			
			t=doc.CreateElement("target");
			SaveDeviceConfig(doc,t,bridge.devTargetSide);
			root.AppendChild(t);
			t=doc.CreateElement("source");
			SaveDeviceConfig(doc,t,bridge.devSourceSide);
			root.AppendChild(t);
			doc.Save(name);
		}
		private void _Load(String name)
		{
			XmlDocument doc=new XmlDocument();
			XmlElement e;
			doc.Load(name);
			e=(XmlElement)doc.FirstChild;
			bridge.TargetIP=e.GetAttribute("targetip");
			XmlNodeList t;
			t=doc.GetElementsByTagName("target");
			IEnumerator en=t.GetEnumerator();
			en.Reset();
			while(en.MoveNext())
			{
				XmlNode node=(XmlNode)en.Current;
				if(node.Name=="target")
				{
					LoadDeviceConfig(node,bridge.devTargetSide);
				}
				else if(node.Name=="source")
				{
					LoadDeviceConfig(node,bridge.devSourceSide);
				}
			}
		}

		private void menuItem2_Click(object sender, System.EventArgs e)
		{
			OpenFileDialog ofd=new OpenFileDialog();
			ofd.Filter = "xml files (*.xml)|*.xml|All files (*.*)|*.*" ;
			ofd.FilterIndex = 1 ;
			ofd.RestoreDirectory = true ;

			if(ofd.ShowDialog()==DialogResult.OK)
			{
				
				_Load(ofd.FileName);
				UpdateDialog();
			}
		}

		private void textTargetIP_TextChanged(object sender, System.EventArgs e)
		{
			bridge.TargetIP=textTargetIP.Text;
		}

		private void menuItem3_Click(object sender, System.EventArgs e)
		{
			SaveFileDialog sfd=new SaveFileDialog();
			sfd.Filter = "xml files (*.xml)|*.xml|All files (*.*)|*.*" ;
			sfd.FilterIndex = 1 ;
			sfd.FileName = "default.xml";
			sfd.RestoreDirectory = true ;

			if(sfd.ShowDialog()==DialogResult.OK)
			{
				
				_Save(sfd.FileName);
				
			}
		}

		private void menuItem5_Click(object sender, System.EventArgs e)
		{
			About a=new About();
			a.ShowDialog(this);
		}

		

	
	
	}
}
