// Adapters.cpp : Implementation of CAdapters

#include "stdafx.h"
#include "Adapter.h"
#include "Adapters.h"
#include "_SmartIEnumVARIANT.h"

HRESULT CAdapters::FinalConstruct()
{
	IP_ADAPTER_INFO ads[10];
	ULONG n=sizeof(ads);
	IP_ADAPTER_INFO *p=ads;
	if(GetAdaptersInfo(ads,&n)==ERROR_SUCCESS)
	{
		do
		{
			CComObject<CAdapter> *pAdapter;
			pAdapter=NULL;
			HRESULT hr=CComObject<CAdapter>::CreateInstance(&pAdapter);
			if(FAILED(hr))
				return Error(_T("Error creating the adapter"));
			m_vAdapters.push_back(((IDispatch *)pAdapter));
			pAdapter->SetAdapter(*p);
			p=p->Next;
		}
		while(p);
	}
	return S_OK;
}
// CAdapters

STDMETHODIMP CAdapters::get_Count(long* retval)
{
	*retval=(long)m_vAdapters.size();
	return S_OK;
}

STDMETHODIMP CAdapters::get_Item(long Index, VARIANT* retval)
{
	if(((long)m_vAdapters.size())>Index)
	{
		return S_OK;
	}
	return E_FAIL;
}

STDMETHODIMP CAdapters::get__NewEnum(IUnknown** retval)
{
	_SmartIEnumVARIANT *ev=new _SmartIEnumVARIANT(&m_vAdapters);
	ev->AddRef();
	*retval=ev;
	return S_OK;
}