// Bridge.cpp : Implementation of CBridge

#include "stdafx.h"
#include "Bridge.h"


// CBridge
HRESULT CBridge::FinalConstruct()
{
	HRESULT hr=0;
	CComObject<CDevice> *pDevice;
	pDevice=NULL;
	hr=CComObject<CDevice>::CreateInstance(&pDevice);
	if(FAILED(hr))
		return Error(_T("Error creating the device config"));
	pDevice->SetTarget(&m_dcTargetSideConfig);
	m_pTargetSideDevice=pDevice;

	pDevice=NULL;
	hr=CComObject<CDevice>::CreateInstance(&pDevice);
	if(FAILED(hr))
		return Error(_T("Error creating the device config"));
	pDevice->SetTarget(&m_dcSourceSideConfig);
	m_pSourceSideDevice=pDevice;
    return S_OK;
}

STDMETHODIMP CBridge::Start(void)
{

	if(!m_IPBridge.Start(m_dcTargetSideConfig,m_dcSourceSideConfig,m_bstrTargetIP))
	{
		return Error("error starting the adapters(check the devices)");
	}

	return S_OK;
}

STDMETHODIMP CBridge::Stop(void)
{
	::MessageBox(NULL,_T("CBridge::Stop"),_T("asd"),MB_OK);
	m_IPBridge.Stop();
	
	return S_OK;
}

STDMETHODIMP CBridge::get_devTargetSide(IDevice** pVal)
{
	m_pTargetSideDevice->AddRef();
	*pVal=m_pTargetSideDevice;
	//m_pTargetSideDevice->QueryInterface(IID_IDispatch,(void **)pVal);
	// TODO: Add your implementation code here

	return S_OK;
}


STDMETHODIMP CBridge::get_devSourceSide(IDevice** pVal)
{
	m_pSourceSideDevice->AddRef();
	*pVal=m_pSourceSideDevice;
	//m_pSourceSideDevice->QueryInterface(IID_IDispatch,(void **)pVal);

	return S_OK;
}


STDMETHODIMP CBridge::get_TargetIP(BSTR* pVal)
{
	*pVal=m_bstrTargetIP;

	return S_OK;
}

STDMETHODIMP CBridge::put_TargetIP(BSTR newVal)
{
	m_bstrTargetIP=newVal;

	return S_OK;
}
