// Device.h : Declaration of the CDevice

#ifndef _DEVICE_H_
#define _DEVICE_H_
#include "resource.h"       // main symbols

struct DeviceConfig
{
	DeviceConfig()
	{
		nMinLatency=0;
		nMaxLatency=0;
		nLoss=0;
		nOutOfOrder=0;
		nBandWidth=0;
	}
	DeviceConfig(const DeviceConfig &dc)
	{
		sDeviceName=dc.sDeviceName;
		nMinLatency=dc.nMinLatency;
		nMaxLatency=dc.nMaxLatency;
		nLoss=dc.nLoss;
		nOutOfOrder=dc.nOutOfOrder;
		nBandWidth=dc.nBandWidth;
	}
	_bstr_t sDeviceName;
	LONG nMinLatency;
	LONG nMaxLatency;
	LONG nLoss;
	LONG nOutOfOrder;
	LONG nBandWidth;
};

// IDevice
[
	object,
	uuid("55D1FB7B-8D90-4693-8772-6EF5E7916940"),
	dual,	helpstring("IDevice Interface"),
	pointer_default(unique)
]
__interface IDevice : IDispatch
{
	[propget, id(1), helpstring("property DeviceName")] HRESULT DeviceName([out, retval] BSTR* pVal);
	[propput, id(1), helpstring("property DeviceName")] HRESULT DeviceName([in] BSTR newVal);
	[propget, id(2), helpstring("property MinLatency")] HRESULT MinLatency([out, retval] LONG* pVal);
	[propput, id(2), helpstring("property MinLatency")] HRESULT MinLatency([in] LONG newVal);
	[propget, id(3), helpstring("property MaxLatency")] HRESULT MaxLatency([out, retval] LONG* pVal);
	[propput, id(3), helpstring("property MaxLatency")] HRESULT MaxLatency([in] LONG newVal);
	[propget, id(4), helpstring("property Loss")] HRESULT Loss([out, retval] LONG* pVal);
	[propput, id(4), helpstring("property Loss")] HRESULT Loss([in] LONG newVal);
	[propget, id(5), helpstring("property OutOfOrder")] HRESULT OutOfOrder([out, retval] LONG* pVal);
	[propput, id(5), helpstring("property OutOfOrder")] HRESULT OutOfOrder([in] LONG newVal);
	[propget, id(6), helpstring("property BandWidth")] HRESULT BandWidth([out, retval] LONG* pVal);
	[propput, id(6), helpstring("property BandWidth")] HRESULT BandWidth([in] LONG newVal);
};



// CDevice

[
	coclass,
	threading("apartment"),
	support_error_info("IDevice"),
	aggregatable("never"),
	vi_progid("NetSim.Device"),
	progid("NetSim.Device.1"),
	version(1.0),
	uuid("259D627F-5C70-4D22-98F2-C902363A590E"),
	helpstring("Device Class")
]

class ATL_NO_VTABLE CDevice : 
	public IDevice
{
public:
	CDevice()
	{
	}


	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}
	
	void FinalRelease() 
	{
	}

public:

	STDMETHOD(get_DeviceName)(BSTR* pVal);
	STDMETHOD(put_DeviceName)(BSTR newVal);
	STDMETHOD(get_MinLatency)(LONG* pVal);
	STDMETHOD(put_MinLatency)(LONG newVal);
	STDMETHOD(get_MaxLatency)(LONG* pVal);
	STDMETHOD(put_MaxLatency)(LONG newVal);
	STDMETHOD(get_Loss)(LONG* pVal);
	STDMETHOD(put_Loss)(LONG newVal);
	STDMETHOD(get_OutOfOrder)(LONG* pVal);
	STDMETHOD(put_OutOfOrder)(LONG newVal);
	STDMETHOD(get_BandWidth)(LONG* pVal);
	STDMETHOD(put_BandWidth)(LONG newVal);
private:
	DeviceConfig *m_pDC;
public:
	void SetTarget(DeviceConfig *p){m_pDC=p;}
};

#endif