#include "StdAfx.h"
#include "ipbridgeimpl.h"

CIPBridgeImpl::CIPBridgeImpl(void)
{
	m_bDone=true;
	m_dwTempPacketSize=0;
}

CIPBridgeImpl::~CIPBridgeImpl(void)
{
	Stop();
}


bool CIPBridgeImpl::Start(DeviceConfig apTargetSide,DeviceConfig apSourceSide,const char *sTargetIP)
{
	if(m_bDone)
	{
		m_bDone=false;
		m_dwTempPacketSize=0;
		m_DeviceConfig[0]=apTargetSide;
		m_DeviceConfig[1]=apSourceSide;
		m_hPacketEvent=::CreateEvent(NULL,TRUE,TRUE,NULL);
		::ResetEvent(m_hPacketEvent);
		m_ipTarget.Set(0,(char *)sTargetIP);
		try{
			m_Adapters[0].Open(m_DeviceConfig[0].sDeviceName,m_ipTarget.m_Address.sin_addr.S_un.S_addr,true);
			m_Adapters[1].Open(m_DeviceConfig[1].sDeviceName,m_ipTarget.m_Address.sin_addr.S_un.S_addr,false);
		}
		catch(...)
		{
			m_bDone=true;
			return false;
		}
		m_Pools[0].Init(500);
		m_Pools[1].Init(500);
		//create working threads
		m_atp[0].pAdapter=&m_Adapters[0];
		m_atp[0].pThis=this;
		m_hCaptureThreads[0]=::CreateThread(NULL,NULL,CIPBridgeImpl::AdapterProc,&m_atp[0],NULL,NULL);
		m_atp[1].pAdapter=&m_Adapters[1];
		m_atp[1].pThis=this;
		m_hCaptureThreads[1]=::CreateThread(NULL,NULL,CIPBridgeImpl::AdapterProc,&m_atp[1],NULL,NULL);
		m_hTransmissionThread=::CreateThread(NULL,NULL,CIPBridgeImpl::TransmissionProc,this,NULL,NULL);
		::SetThreadPriority(m_hTransmissionThread,THREAD_PRIORITY_TIME_CRITICAL);
		return true;
	}
	return false;
}

DWORD WINAPI CIPBridgeImpl::AdapterProc(LPVOID lpParameter)
{
	AdapterThreadParams *atp=(AdapterThreadParams *)lpParameter;
	CIPBridgeImpl *pThis=atp->pThis;
	_Adapter *pAdapter=atp->pAdapter;
	pAdapter->Process(pThis);
	return 0;
}

DWORD WINAPI CIPBridgeImpl::TransmissionProc(LPVOID lpParameter)
{
	CIPBridgeImpl *pThis=(CIPBridgeImpl *)lpParameter;
	CPacketsPool *pool;
	DeviceConfig *param;
	BYTE cPacket[8000];
	DWORD dwSize;
	while(!pThis->m_bDone)
	{
		::WaitForSingleObject(pThis->m_hPacketEvent,1);
		//process stuff;
		//printf("transmission\n");
		// LATENCY
		for(int i=0;i<2;i++){
			pool=&pThis->m_Pools[i];
			param=&pThis->m_DeviceConfig[i];
			DWORD nDeltaLatency=param->nMaxLatency-param->nMinLatency;
			while((param->nMaxLatency==0 && pool->GetNumOfPackets()) 
				|| (pool->GetPacketAge()>param->nMinLatency+(nDeltaLatency*(rand()/(float)RAND_MAX))))
			{
				if((!pThis->m_dwTempPacketSize) //if there is already an out of order packet ...skip
					&& param->nOutOfOrder  //if the out of oder percentage is 0 skip
					&& ((DWORD)rand()/(RAND_MAX*100))<(unsigned int)param->nOutOfOrder) //is time to 
				{
					pThis->m_dwTempPacketSize=pool->PopPacket(pThis->m_cTempPacket);
					printf("out of order\n");
					//return;
				}
				else
				{
					dwSize=pool->PopPacket(cPacket);
					if(dwSize){
						pThis->m_Adapters[(i+1)&0x01].SendPacket(cPacket,dwSize);
						//send the out of order packet(if any)
						if(pThis->m_dwTempPacketSize)
						{
							pThis->m_Adapters[(i+1)&0x01].SendPacket(pThis->m_cTempPacket,pThis->m_dwTempPacketSize);
							pThis->m_dwTempPacketSize=0;
						}
					}
				}
			}
		}
		
		::ResetEvent(pThis->m_hPacketEvent);
	}
	return 0;
}

void CIPBridgeImpl::OnPacket(BYTE *sPacket,DWORD nSize,bool bTargetSide)
{
	//<<FIXME>> BANDWIDTH CONTROL (per link)
	
	//<<FIXME>> ORDER
	DeviceConfig *param;
	CPacketsPool *dest;

	if(bTargetSide)
	{
		param=&m_DeviceConfig[0];
		dest=&m_Pools[0];
	}
	else
	{
		param=&m_DeviceConfig[1];
		dest=&m_Pools[1];
	}

	//LOSS
	if((((DWORD)rand()*100)/(RAND_MAX))<(unsigned int)param->nLoss)
	{
		::OutputDebugString("loss\n");
		return;
	}
	
	dest->PushPacket(sPacket,nSize);
	//m_Adapters[1].SendPacket(sPacket,nSize);
	
	::SetEvent(m_hPacketEvent);
}

void CIPBridgeImpl::Stop()
{
	if(!m_bDone)
	{
		m_bDone=true;
		m_Adapters[0].Close();
		m_Adapters[1].Close();
		::SetEvent(m_hPacketEvent);
		if(::WaitForSingleObject(m_hTransmissionThread,1000)==WAIT_TIMEOUT)
		{
			::TerminateThread(m_hTransmissionThread,-5);
		}
		if(::WaitForMultipleObjects(2,m_hCaptureThreads,TRUE,3000)==WAIT_TIMEOUT)
		{
			::TerminateThread(m_hCaptureThreads[0],-5);
			::TerminateThread(m_hCaptureThreads[1],-6);
		}
		::CloseHandle(m_hPacketEvent);
		m_Pools[0].Shutdown();
		m_Pools[1].Shutdown();
	}

}

