#pragma once
#define CAPTURE_BUF_SIZE 512000

#include "IPAddress.h"
#include "packetspool.h"



#pragma comment (lib ,"Packet.lib")
#pragma comment (lib ,"Ws2_32.lib")
#include "_adapter.h"
#include "Device.h"

/*struct AdapterParams
{
	DWORD dwLossPecentage;
	DWORD dwOutOfOrderPercentage;
	DWORD dwMinLatency;
	DWORD dwMaxLatency;
	DWORD dwKbps;
	char sAdapter[512];
};*/

class CIPBridgeImpl
{
	struct AdapterThreadParams
	{
		CIPBridgeImpl *pThis;
		_Adapter *pAdapter;
	};
public:
	CIPBridgeImpl(void);
	virtual ~CIPBridgeImpl(void);
	bool Start(DeviceConfig apTargetSide,DeviceConfig apSourceSide,const char *sTargetIP);
	void Stop();
	void OnPacket(BYTE *sPacket,DWORD nSize,bool bTargetSide);
private:
	static DWORD WINAPI AdapterProc(LPVOID lpParameter);
	static DWORD WINAPI TransmissionProc(LPVOID lpParameter);
	DeviceConfig m_DeviceConfig[2];
	_Adapter m_Adapters[2];
	CPacketsPool m_Pools[2];
	CIPAddress m_ipTarget;
	HANDLE m_hCaptureThreads[2];
	HANDLE m_hTransmissionThread;
	HANDLE m_hPacketEvent;
	AdapterThreadParams m_atp[2];
	bool m_bDone;
	//for out of order packets
	BYTE m_cTempPacket[MAX_DATA_SIZE];
	DWORD m_dwTempPacketSize;

};
