#pragma once

#define MAX_DATA_SIZE 8000
#include <stack>
struct _Packet
{
	DWORD dwTimestamp;
	DWORD dwSize;
    _Packet *next;
	_Packet *prev;
	BYTE cData[MAX_DATA_SIZE];
};

typedef std::stack<_Packet *> FreePackets;

struct _XCriticalSection
{
	_XCriticalSection(CRITICAL_SECTION *cs)
	{
		m_cs=cs;
		::EnterCriticalSection(m_cs);
	}
	~_XCriticalSection()
	{
		::LeaveCriticalSection(m_cs);
	}
private:
	CRITICAL_SECTION *m_cs;
};
class CPacketsPool
{
public:
	CPacketsPool(void);
	virtual ~CPacketsPool(void);
	void Init(DWORD dwPoolSize);
	void Shutdown();
    void PushPacket(BYTE *pBuf,DWORD dwSize);
	DWORD PopPacket(BYTE *pBuf);
	DWORD GetPacketAge();
	DWORD GetNumOfPackets(){return m_dwNumOfPackets;}
private:
	FreePackets m_stkFreePackets;
	_Packet *m_pPool;
	_Packet *m_pFirst;
	_Packet *m_pLast;
	DWORD m_dwPoolSize;
	DWORD m_dwNumOfPackets;
	CRITICAL_SECTION m_cs;
};
