#pragma once
#include <vector>

class _SmartIEnumVARIANT :
	public IEnumVARIANT
{
	typedef std::vector < _variant_t > CNT;
	typedef std::vector < _variant_t >::iterator CNTItr;
public:

	_SmartIEnumVARIANT(CNT *cnt)
	{
		_cnt=cnt;
		_itor=_cnt->begin();
		_ref=0;
	}

	virtual ~_SmartIEnumVARIANT(void)
	{
		_cnt=0;
	}

	STDMETHOD(Next)(unsigned long celt, 
		VARIANT FAR* rgvar, 
		unsigned long FAR* pceltFetched)
		{
			if(_itor==_cnt->end()){
				*pceltFetched=NULL;
				return S_FALSE;
			}
			rgvar[0]=(*_itor);
			*pceltFetched=1;
			++_itor;
			return S_OK;
		}
		STDMETHOD(Skip)(unsigned long celt)
		{
			for(unsigned long i=0;i<celt;i++)
			{
				if(_itor==_cnt->end()){
					return E_FAIL;
				}
				++_itor;
			}
			return S_OK;
		}
		STDMETHOD(Reset)()
		{
			_itor=_cnt->begin();
			return S_OK;
		}
		STDMETHOD(Clone)(IEnumVARIANT FAR* FAR* ppenum) 
		{
			return E_NOTIMPL;
		}
		ULONG _stdcall AddRef()
		{
			return ++_ref;
		}
		ULONG _stdcall Release()
		{
			ULONG temp=--_ref;
			if(temp<=0) delete this;
			return temp;
		}
		STDMETHOD(QueryInterface)(REFIID iid,void **p)
		{
			if(iid==IID_IEnumVARIANT)
			{
				AddRef();
				*p=this;
				return S_OK;
			}
			if(iid==IID_IUnknown)
			{
				AddRef();
				*p=this;
				return S_OK;
			}
			return E_NOTIMPL;
		}
private:

	CNT *_cnt;
	CNTItr _itor;
	ULONG _ref;

};
